/*
 * Decompiled with CFR 0.152.
 */
package com.kozaris.android.k_mqtt;

import android.content.Context;
import android.util.Log;
import com.kozaris.android.k_mqtt.Connection;
import com.kozaris.android.k_mqtt.MqttClient;
import com.kozaris.android.k_mqtt.R;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttCallbackHandler
implements MqttCallback {
    private final Context context;
    private static final String TAG = "MqttCallbackHandler";

    public MqttCallbackHandler(Context context) {
        this.context = context;
    }

    public void connectionLost(Throwable cause) {
        if (cause != null) {
            Log.d((String)TAG, (String)("Connection Lost: " + cause.getMessage()));
            Connection c = MqttClient.getInstance(this.context).getConnection();
            c.addAction("Connection Lost");
            c.changeConnectionStatus(Connection.ConnectionStatus.DISCONNECTED);
            Log.d((String)TAG, (String)this.context.getString(R.string.connection_lost, new Object[]{c.getId(), c.getHostName()}));
        }
    }

    public void messageArrived(String topic, MqttMessage message) throws Exception {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        c.messageArrived(topic, message);
        String messageString = this.context.getString(R.string.messageRecieved, new Object[]{new String(message.getPayload()), topic + ";qos:" + message.getQos() + ";retained:" + message.isRetained()});
        Log.i((String)TAG, (String)messageString);
        c.addAction(messageString);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
    }
}

