/*
 * Decompiled with CFR 0.152.
 */
package com.kozaris.android.k_mqtt;

import android.content.Context;
import com.kozaris.android.k_mqtt.ActionListener;
import com.kozaris.android.k_mqtt.IReceivedMessageListener;
import com.kozaris.android.k_mqtt.Persistence;
import com.kozaris.android.k_mqtt.PersistenceException;
import com.kozaris.android.k_mqtt.R;
import com.kozaris.android.k_mqtt.ReceivedMessage;
import com.kozaris.android.k_mqtt.Subscription;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.android.service.MqttAndroidClient;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class Connection {
    private String clientId = null;
    private String host = null;
    private int port = 0;
    private ConnectionStatus status = ConnectionStatus.NONE;
    private ArrayList<String> history = null;
    private MqttAndroidClient client = null;
    private final ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private Context context = null;
    private MqttConnectOptions mqttConnectOptions;
    private boolean tlsConnection = true;
    private long persistenceId = -1L;
    private final Map<String, Subscription> subscriptions = new HashMap<String, Subscription>();
    private final ArrayList<ReceivedMessage> messageHistory = new ArrayList();
    private final ArrayList<IReceivedMessageListener> receivedMessageListeners = new ArrayList();

    public static Connection createConnection(String clientId, String host, int port, Context context, boolean tlsConnection) {
        String uri = tlsConnection ? "ssl://" + host + ":" + port : "tcp://" + host + ":" + port;
        MqttAndroidClient client = new MqttAndroidClient(context, uri, clientId);
        return new Connection(clientId, host, port, context, client, tlsConnection);
    }

    public void updateConnection(String clientId, String host, int port, boolean tlsConnection) {
        String uri = tlsConnection ? "ssl://" + host + ":" + port : "tcp://" + host + ":" + port;
        this.clientId = clientId;
        this.host = host;
        this.port = port;
        this.tlsConnection = tlsConnection;
        this.client = new MqttAndroidClient(this.context, uri, clientId);
    }

    private Connection(String clientId, String host, int port, Context context, MqttAndroidClient client, boolean tlsConnection) {
        this.clientId = clientId;
        this.host = host;
        this.port = port;
        this.context = context;
        this.client = client;
        this.tlsConnection = tlsConnection;
        this.history = new ArrayList();
        String sb = "Client: " + clientId + " created";
        this.addAction(sb);
    }

    void addAction(String action) {
        Object[] args = new String[1];
        DateFormat dateTimeFormatter = SimpleDateFormat.getDateTimeInstance(3, 3);
        args[0] = dateTimeFormatter.format(new Date());
        String timestamp = this.context.getString(R.string.timestamp, args);
        this.history.add(action + timestamp);
        this.notifyListeners(new PropertyChangeEvent(this, "history", null, null));
    }

    public boolean isConnected() {
        return this.status == ConnectionStatus.CONNECTED;
    }

    public void changeConnectionStatus(ConnectionStatus connectionStatus) {
        this.status = connectionStatus;
        this.notifyListeners(new PropertyChangeEvent(this, "connectionStatus", null, null));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.clientId);
        sb.append("\n ");
        switch (this.status) {
            case CONNECTED: {
                sb.append(this.context.getString(R.string.connection_connected_to));
                break;
            }
            case DISCONNECTED: {
                sb.append(this.context.getString(R.string.connection_disconnected_from));
                break;
            }
            case NONE: {
                sb.append(this.context.getString(R.string.connection_unknown_status));
                break;
            }
            case CONNECTING: {
                sb.append(this.context.getString(R.string.connection_connecting_to));
                break;
            }
            case DISCONNECTING: {
                sb.append(this.context.getString(R.string.connection_disconnecting_from));
                break;
            }
            case ERROR: {
                sb.append(this.context.getString(R.string.connection_error_connecting_to));
            }
        }
        sb.append(" ");
        sb.append(this.host);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection c = (Connection)o;
        return this.clientId.equals(c.clientId);
    }

    public String getId() {
        return this.clientId;
    }

    public String getHostName() {
        return this.host;
    }

    public MqttAndroidClient getClient() {
        return this.client;
    }

    public void addConnectionOptions(MqttConnectOptions connectOptions) {
        this.mqttConnectOptions = connectOptions;
    }

    public MqttConnectOptions getConnectionOptions() {
        return this.mqttConnectOptions;
    }

    public void registerChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners(PropertyChangeEvent propertyChangeEvent) {
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(propertyChangeEvent);
        }
    }

    public int getPort() {
        return this.port;
    }

    public int isSSL() {
        return this.tlsConnection ? 1 : 0;
    }

    public void assignPersistenceId(long id) {
        this.persistenceId = id;
    }

    public long persistenceId() {
        return this.persistenceId;
    }

    public void addNewSubscription(Subscription subscription) throws MqttException {
        if (!this.subscriptions.containsKey(subscription.getTopic())) {
            try {
                String[] actionArgs = new String[]{subscription.getTopic()};
                ActionListener callback = new ActionListener(this.context, ActionListener.Action.SUBSCRIBE, this, actionArgs);
                this.getClient().subscribe(subscription.getTopic(), subscription.getQos(), null, (IMqttActionListener)callback);
                Persistence persistence = new Persistence(this.context);
                long rowId = persistence.persistSubscription(subscription);
                subscription.setPersistenceId(rowId);
                this.subscriptions.put(subscription.getTopic(), subscription);
            }
            catch (PersistenceException pe) {
                throw new MqttException((Throwable)pe);
            }
        }
    }

    public void unsubscribe(Subscription subscription) throws MqttException {
        if (this.subscriptions.containsKey(subscription.getTopic())) {
            this.getClient().unsubscribe(subscription.getTopic());
            this.subscriptions.remove(subscription.getTopic());
            Persistence persistence = new Persistence(this.context);
            persistence.deleteSubscription(subscription);
        }
    }

    public void setSubscriptions(ArrayList<Subscription> newSubs) {
        for (Subscription sub : newSubs) {
            this.subscriptions.put(sub.getTopic(), sub);
        }
    }

    public ArrayList<Subscription> getSubscriptions() {
        ArrayList<Subscription> subs = new ArrayList<Subscription>();
        subs.addAll(this.subscriptions.values());
        return subs;
    }

    public void addReceivedMessageListener(IReceivedMessageListener listener) {
        this.receivedMessageListeners.add(listener);
    }

    public void messageArrived(String topic, MqttMessage message) {
        ReceivedMessage msg = new ReceivedMessage(topic, message);
        if (this.messageHistory.size() > 20) {
            this.messageHistory.clear();
        }
        this.messageHistory.add(msg);
        if (this.subscriptions.containsKey(topic)) {
            this.subscriptions.get(topic).setLastMessage(new String(message.getPayload()));
        }
        for (IReceivedMessageListener listener : this.receivedMessageListeners) {
            listener.onMessageReceived(msg);
        }
    }

    public ArrayList<ReceivedMessage> getMessages() {
        return this.messageHistory;
    }

    public static enum ConnectionStatus {
        CONNECTING,
        CONNECTED,
        DISCONNECTING,
        DISCONNECTED,
        ERROR,
        NONE;

    }
}

