/*
 * Decompiled with CFR 0.152.
 */
package com.kozaris.android.k_mqtt;

import android.content.Context;
import android.util.Log;
import com.kozaris.android.k_mqtt.Connection;
import com.kozaris.android.k_mqtt.MqttClient;
import com.kozaris.android.k_mqtt.R;
import com.kozaris.android.k_mqtt.Subscription;
import java.util.ArrayList;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttException;

public class ActionListener
implements IMqttActionListener {
    private static final String TAG = "ActionListener";
    private final Action action;
    private final String[] additionalArgs;
    private final Connection connection;
    private final Context context;

    public ActionListener(Context context, Action action, Connection connection, String ... additionalArgs) {
        this.context = context;
        this.action = action;
        this.connection = connection;
        this.additionalArgs = additionalArgs;
    }

    public void onSuccess(IMqttToken asyncActionToken) {
        switch (this.action) {
            case CONNECT: {
                this.connect();
                break;
            }
            case DISCONNECT: {
                this.disconnect();
                break;
            }
            case SUBSCRIBE: {
                this.subscribe();
                break;
            }
            case PUBLISH: {
                this.publish();
            }
        }
    }

    private void publish() {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        String actionTaken = this.context.getString(R.string.toast_pub_success, (Object[])this.additionalArgs);
        c.addAction(actionTaken);
        System.out.print("Published");
    }

    private void subscribe() {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        String actionTaken = this.context.getString(R.string.toast_sub_success, (Object[])this.additionalArgs);
        c.addAction(actionTaken);
        System.out.print(actionTaken);
    }

    private void disconnect() {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        c.changeConnectionStatus(Connection.ConnectionStatus.DISCONNECTED);
        String actionTaken = this.context.getString(R.string.toast_disconnected);
        c.addAction(actionTaken);
        Log.i((String)TAG, (String)(c.getId() + " disconnected."));
    }

    private void connect() {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        c.changeConnectionStatus(Connection.ConnectionStatus.CONNECTED);
        c.addAction("Client Connected");
        Log.i((String)TAG, (String)(c.getId() + " connected."));
        try {
            ArrayList<Subscription> subscriptions = this.connection.getSubscriptions();
            for (Subscription sub : subscriptions) {
                Log.i((String)TAG, (String)("Auto-subscribing to: " + sub.getTopic() + "@ QoS: " + sub.getQos()));
                this.connection.getClient().subscribe(sub.getTopic(), sub.getQos());
            }
        }
        catch (MqttException ex) {
            Log.e((String)TAG, (String)("Failed to Auto-Subscribe: " + ex.getMessage()));
        }
    }

    public void onFailure(IMqttToken token, Throwable exception) {
        switch (this.action) {
            case CONNECT: {
                this.connect(exception);
                break;
            }
            case DISCONNECT: {
                this.disconnect(exception);
                break;
            }
            case SUBSCRIBE: {
                this.subscribe(exception);
                break;
            }
            case PUBLISH: {
                this.publish(exception);
            }
        }
    }

    private void publish(Throwable exception) {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        String action = this.context.getString(R.string.toast_pub_failed, (Object[])this.additionalArgs);
        c.addAction(action);
        System.out.print("Publish failed : " + exception.getMessage());
    }

    private void subscribe(Throwable exception) {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        String action = this.context.getString(R.string.toast_sub_failed, (Object[])this.additionalArgs);
        c.addAction(action);
        System.out.print(action);
        System.out.print("Subscribe failed : " + exception.getMessage());
    }

    private void disconnect(Throwable exception) {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        c.changeConnectionStatus(Connection.ConnectionStatus.DISCONNECTED);
        c.addAction("Disconnect Failed - an error occurred");
        System.out.print("Disconnect failed : " + exception.getMessage());
    }

    private void connect(Throwable exception) {
        Connection c = MqttClient.getInstance(this.context).getConnection();
        c.changeConnectionStatus(Connection.ConnectionStatus.ERROR);
        c.addAction("Client failed to connect");
        System.out.println("Client failed to connect");
        System.out.print("Connect failed : " + exception.getMessage());
    }

    public static enum Action {
        CONNECT,
        DISCONNECT,
        SUBSCRIBE,
        PUBLISH;

    }
}

