/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.koverse.kdpapi.client.model.StripeLatestCharge1;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "email", "firstName", "lastName", "workspaceId", "role", "stripeLatestCharge"})
@JsonTypeName(value="User")
public class User
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_ROLE = "role";
    private RoleEnum role;
    public static final String JSON_PROPERTY_STRIPE_LATEST_CHARGE = "stripeLatestCharge";
    private StripeLatestCharge1 stripeLatestCharge;

    public User id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the ID of the user")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public User email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the email of the user")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public User firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the first name of the user")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public User lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the last name of the user")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public User workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the ID of the KDP workspace the user can access")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public User role(RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the workspace role of the user")
    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public RoleEnum getRole() {
        return this.role;
    }

    @JsonProperty(value="role")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRole(RoleEnum role) {
        this.role = role;
    }

    public User stripeLatestCharge(StripeLatestCharge1 stripeLatestCharge) {
        this.stripeLatestCharge = stripeLatestCharge;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="stripeLatestCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StripeLatestCharge1 getStripeLatestCharge() {
        return this.stripeLatestCharge;
    }

    @JsonProperty(value="stripeLatestCharge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStripeLatestCharge(StripeLatestCharge1 stripeLatestCharge) {
        this.stripeLatestCharge = stripeLatestCharge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.id, user.id) && Objects.equals(this.email, user.email) && Objects.equals(this.firstName, user.firstName) && Objects.equals(this.lastName, user.lastName) && Objects.equals(this.workspaceId, user.workspaceId) && Objects.equals((Object)this.role, (Object)user.role) && Objects.equals(this.stripeLatestCharge, user.stripeLatestCharge);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.email, this.firstName, this.lastName, this.workspaceId, this.role, this.stripeLatestCharge});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class User {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    stripeLatestCharge: ").append(this.toIndentedString(this.stripeLatestCharge)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RoleEnum {
        MEMBER("member"),
        ADMIN("admin");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

