/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.AccessControlLabel;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"jobId", "datasetId", "files", "accessControlLabel", "customMetadata"})
@JsonTypeName(value="UploadResponse")
public class UploadResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    private UUID jobId;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_FILES = "files";
    private List<File> files = new ArrayList<File>();
    public static final String JSON_PROPERTY_ACCESS_CONTROL_LABEL = "accessControlLabel";
    private AccessControlLabel accessControlLabel;
    public static final String JSON_PROPERTY_CUSTOM_METADATA = "customMetadata";
    private Object customMetadata;

    public UploadResponse jobId(UUID jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Job ID")
    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobId(UUID jobId) {
        this.jobId = jobId;
    }

    public UploadResponse datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Dataset ID")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public UploadResponse files(List<File> files) {
        this.files = files;
        return this;
    }

    public UploadResponse addFilesItem(File filesItem) {
        this.files.add(filesItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Files")
    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<File> getFiles() {
        return this.files;
    }

    @JsonProperty(value="files")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFiles(List<File> files) {
        this.files = files;
    }

    public UploadResponse accessControlLabel(AccessControlLabel accessControlLabel) {
        this.accessControlLabel = accessControlLabel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessControlLabel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AccessControlLabel getAccessControlLabel() {
        return this.accessControlLabel;
    }

    @JsonProperty(value="accessControlLabel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessControlLabel(AccessControlLabel accessControlLabel) {
        this.accessControlLabel = accessControlLabel;
    }

    public UploadResponse customMetadata(Object customMetadata) {
        this.customMetadata = customMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Custom Metadata")
    @JsonProperty(value="customMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getCustomMetadata() {
        return this.customMetadata;
    }

    @JsonProperty(value="customMetadata")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomMetadata(Object customMetadata) {
        this.customMetadata = customMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadResponse uploadResponse = (UploadResponse)o;
        return Objects.equals(this.jobId, uploadResponse.jobId) && Objects.equals(this.datasetId, uploadResponse.datasetId) && Objects.equals(this.files, uploadResponse.files) && Objects.equals(this.accessControlLabel, uploadResponse.accessControlLabel) && Objects.equals(this.customMetadata, uploadResponse.customMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.datasetId, this.files, this.accessControlLabel, this.customMetadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadResponse {\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    files: ").append(this.toIndentedString(this.files)).append("\n");
        sb.append("    accessControlLabel: ").append(this.toIndentedString(this.accessControlLabel)).append("\n");
        sb.append("    customMetadata: ").append(this.toIndentedString(this.customMetadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

