/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Contains the configuration parameters for the security label parser")
@JsonPropertyOrder(value={"fields", "label", "labelHandlingPolicy", "parserClassName", "replacementString"})
@JsonTypeName(value="SecurityLabelInfoParams")
public class SecurityLabelInfoParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FIELDS = "fields";
    private List<String> fields = null;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LABEL_HANDLING_POLICY = "labelHandlingPolicy";
    private LabelHandlingPolicyEnum labelHandlingPolicy = LabelHandlingPolicyEnum.REPLACE;
    public static final String JSON_PROPERTY_PARSER_CLASS_NAME = "parserClassName";
    private ParserClassNameEnum parserClassName;
    public static final String JSON_PROPERTY_REPLACEMENT_STRING = "replacementString";
    private String replacementString;

    public SecurityLabelInfoParams fields(List<String> fields) {
        this.fields = fields;
        return this;
    }

    public SecurityLabelInfoParams addFieldsItem(String fieldsItem) {
        if (this.fields == null) {
            this.fields = new ArrayList<String>();
        }
        this.fields.add(fieldsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="array of label fields")
    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public SecurityLabelInfoParams label(String label) {
        this.label = label;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the label to apply to all records")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(String label) {
        this.label = label;
    }

    public SecurityLabelInfoParams labelHandlingPolicy(LabelHandlingPolicyEnum labelHandlingPolicy) {
        this.labelHandlingPolicy = labelHandlingPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="how to handle label if value is missing.")
    @JsonProperty(value="labelHandlingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LabelHandlingPolicyEnum getLabelHandlingPolicy() {
        return this.labelHandlingPolicy;
    }

    @JsonProperty(value="labelHandlingPolicy")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabelHandlingPolicy(LabelHandlingPolicyEnum labelHandlingPolicy) {
        this.labelHandlingPolicy = labelHandlingPolicy;
    }

    public SecurityLabelInfoParams parserClassName(ParserClassNameEnum parserClassName) {
        this.parserClassName = parserClassName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Parser name. Please note 'simple-parser' has been deprecated. Use 'identity-parser' instead.")
    @JsonProperty(value="parserClassName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ParserClassNameEnum getParserClassName() {
        return this.parserClassName;
    }

    @JsonProperty(value="parserClassName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setParserClassName(ParserClassNameEnum parserClassName) {
        this.parserClassName = parserClassName;
    }

    public SecurityLabelInfoParams replacementString(String replacementString) {
        this.replacementString = replacementString;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the replacement string to use.")
    @JsonProperty(value="replacementString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReplacementString() {
        return this.replacementString;
    }

    @JsonProperty(value="replacementString")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplacementString(String replacementString) {
        this.replacementString = replacementString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityLabelInfoParams securityLabelInfoParams = (SecurityLabelInfoParams)o;
        return Objects.equals(this.fields, securityLabelInfoParams.fields) && Objects.equals(this.label, securityLabelInfoParams.label) && Objects.equals((Object)this.labelHandlingPolicy, (Object)securityLabelInfoParams.labelHandlingPolicy) && Objects.equals((Object)this.parserClassName, (Object)securityLabelInfoParams.parserClassName) && Objects.equals(this.replacementString, securityLabelInfoParams.replacementString);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fields, this.label, this.labelHandlingPolicy, this.parserClassName, this.replacementString});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityLabelInfoParams {\n");
        sb.append("    fields: ").append(this.toIndentedString(this.fields)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    labelHandlingPolicy: ").append(this.toIndentedString((Object)this.labelHandlingPolicy)).append("\n");
        sb.append("    parserClassName: ").append(this.toIndentedString((Object)this.parserClassName)).append("\n");
        sb.append("    replacementString: ").append(this.toIndentedString(this.replacementString)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum LabelHandlingPolicyEnum {
        IGNORE("ignore"),
        REPLACE("replace"),
        DROP("drop");

        private String value;

        private LabelHandlingPolicyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static LabelHandlingPolicyEnum fromValue(String value) {
            for (LabelHandlingPolicyEnum b : LabelHandlingPolicyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ParserClassNameEnum {
        SIMPLE_PARSER("simple-parser"),
        IDENTITY_PARSER("identity-parser"),
        CAPCO_PARSER("capco-parser"),
        APPLY_LABEL_TO_ALL_RECORDS_PARSER("apply-label-to-all-records-parser");

        private String value;

        private ParserClassNameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParserClassNameEnum fromValue(String value) {
            for (ParserClassNameEnum b : ParserClassNameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

