/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"key", "syncHost", "syncId"})
@JsonTypeName(value="replica_dataset_sync_create_request")
public class ReplicaDatasetSyncCreateRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_SYNC_HOST = "syncHost";
    private String syncHost;
    public static final String JSON_PROPERTY_SYNC_ID = "syncId";
    private UUID syncId;

    public ReplicaDatasetSyncCreateRequest key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Security key used for the dataset sync  Is the **key** field from **Create Sync Key (Create Origin Dataset Sync)** response body.  *Plain Text key is only available from the **Create Sync Key (Create Origin Dataset Sync)** POST response, key is encrypted on GET requests.* ")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(String key) {
        this.key = key;
    }

    public ReplicaDatasetSyncCreateRequest syncHost(String syncHost) {
        this.syncHost = syncHost;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="myReplicaWorkspaceName.api.myReplicaKoverseHostName.com", required=true, value="The Host Name of the paired Sync Workspace")
    @JsonProperty(value="syncHost")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSyncHost() {
        return this.syncHost;
    }

    @JsonProperty(value="syncHost")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSyncHost(String syncHost) {
        this.syncHost = syncHost;
    }

    public ReplicaDatasetSyncCreateRequest syncId(UUID syncId) {
        this.syncId = syncId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The ID of the dataset-sync in paired Sync Workspace  *For a paired replica, this is the Origin Dataset Sync ID*  *For the origin sync, this is the Paired Replica Dataset Sync ID* ")
    @JsonProperty(value="syncId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getSyncId() {
        return this.syncId;
    }

    @JsonProperty(value="syncId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSyncId(UUID syncId) {
        this.syncId = syncId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaDatasetSyncCreateRequest replicaDatasetSyncCreateRequest = (ReplicaDatasetSyncCreateRequest)o;
        return Objects.equals(this.key, replicaDatasetSyncCreateRequest.key) && Objects.equals(this.syncHost, replicaDatasetSyncCreateRequest.syncHost) && Objects.equals(this.syncId, replicaDatasetSyncCreateRequest.syncId);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.syncHost, this.syncId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplicaDatasetSyncCreateRequest {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    syncHost: ").append(this.toIndentedString(this.syncHost)).append("\n");
        sb.append("    syncId: ").append(this.toIndentedString(this.syncId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

