/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.koverse.kdpapi.client.model.SchemaField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A batch of records returned from the query")
@JsonPropertyOrder(value={"records", "schema", "lastRecordId", "more", "total"})
@JsonTypeName(value="RecordBatch")
public class RecordBatch
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RECORDS = "records";
    private List<Map<String, Object>> records = null;
    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private Map<String, SchemaField> schema = null;
    public static final String JSON_PROPERTY_LAST_RECORD_ID = "lastRecordId";
    private String lastRecordId;
    public static final String JSON_PROPERTY_MORE = "more";
    private Boolean more;
    public static final String JSON_PROPERTY_TOTAL = "total";
    private Integer total;

    public RecordBatch records(List<Map<String, Object>> records) {
        this.records = records;
        return this;
    }

    public RecordBatch addRecordsItem(Map<String, Object> recordsItem) {
        if (this.records == null) {
            this.records = new ArrayList<Map<String, Object>>();
        }
        this.records.add(recordsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Map<String, Object>> getRecords() {
        return this.records;
    }

    @JsonProperty(value="records")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecords(List<Map<String, Object>> records) {
        this.records = records;
    }

    public RecordBatch schema(Map<String, SchemaField> schema) {
        this.schema = schema;
        return this;
    }

    public RecordBatch putSchemaItem(String key, SchemaField schemaItem) {
        if (this.schema == null) {
            this.schema = new HashMap<String, SchemaField>();
        }
        this.schema.put(key, schemaItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The schema of the records returned in a batch")
    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SchemaField> getSchema() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(Map<String, SchemaField> schema) {
        this.schema = schema;
    }

    public RecordBatch lastRecordId(String lastRecordId) {
        this.lastRecordId = lastRecordId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the last record returned in the current batch")
    @JsonProperty(value="lastRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLastRecordId() {
        return this.lastRecordId;
    }

    @JsonProperty(value="lastRecordId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastRecordId(String lastRecordId) {
        this.lastRecordId = lastRecordId;
    }

    public RecordBatch more(Boolean more) {
        this.more = more;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When the value is true, the records returned are only a subset of the total records, and additional records can be returned by querying again with an offset")
    @JsonProperty(value="more")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getMore() {
        return this.more;
    }

    @JsonProperty(value="more")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMore(Boolean more) {
        this.more = more;
    }

    public RecordBatch total(Integer total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total count of all records the query can return, includes records even if they are not in the current batch result")
    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTotal() {
        return this.total;
    }

    @JsonProperty(value="total")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotal(Integer total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordBatch recordBatch = (RecordBatch)o;
        return Objects.equals(this.records, recordBatch.records) && Objects.equals(this.schema, recordBatch.schema) && Objects.equals(this.lastRecordId, recordBatch.lastRecordId) && Objects.equals(this.more, recordBatch.more) && Objects.equals(this.total, recordBatch.total);
    }

    public int hashCode() {
        return Objects.hash(this.records, this.schema, this.lastRecordId, this.more, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordBatch {\n");
        sb.append("    records: ").append(this.toIndentedString(this.records)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    lastRecordId: ").append(this.toIndentedString(this.lastRecordId)).append("\n");
        sb.append("    more: ").append(this.toIndentedString(this.more)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

