/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"datasetId", "expression", "limit", "offset", "credentialsSubset"})
@JsonTypeName(value="QueryDocumentLuceneRequest")
public class QueryDocumentLuceneRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_EXPRESSION = "expression";
    private String expression;
    public static final String JSON_PROPERTY_LIMIT = "limit";
    private Integer limit;
    public static final String JSON_PROPERTY_OFFSET = "offset";
    private Integer offset;
    public static final String JSON_PROPERTY_CREDENTIALS_SUBSET = "credentialsSubset";
    private List<String> credentialsSubset = null;

    public QueryDocumentLuceneRequest datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="97d23549-fd63-41b2-9950-bcc7f566e4d4", value="The ID of the dataset where this query will run")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public QueryDocumentLuceneRequest expression(String expression) {
        this.expression = expression;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="alphabet:a", value="The query in lucene query syntax")
    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpression() {
        return this.expression;
    }

    @JsonProperty(value="expression")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public QueryDocumentLuceneRequest limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10", value="The maximum number of records to return for the query, providing -1 returns all records")
    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getLimit() {
        return this.limit;
    }

    @JsonProperty(value="limit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public QueryDocumentLuceneRequest offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of records from the beginning of a record batch where the current batch will start, used for paging results")
    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getOffset() {
        return this.offset;
    }

    @JsonProperty(value="offset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public QueryDocumentLuceneRequest credentialsSubset(List<String> credentialsSubset) {
        this.credentialsSubset = credentialsSubset;
        return this;
    }

    public QueryDocumentLuceneRequest addCredentialsSubsetItem(String credentialsSubsetItem) {
        if (this.credentialsSubset == null) {
            this.credentialsSubset = new ArrayList<String>();
        }
        this.credentialsSubset.add(credentialsSubsetItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of credentials that can be provided to return records of a more limited subset than that of the authenticated caller")
    @JsonProperty(value="credentialsSubset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getCredentialsSubset() {
        return this.credentialsSubset;
    }

    @JsonProperty(value="credentialsSubset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentialsSubset(List<String> credentialsSubset) {
        this.credentialsSubset = credentialsSubset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryDocumentLuceneRequest queryDocumentLuceneRequest = (QueryDocumentLuceneRequest)o;
        return Objects.equals(this.datasetId, queryDocumentLuceneRequest.datasetId) && Objects.equals(this.expression, queryDocumentLuceneRequest.expression) && Objects.equals(this.limit, queryDocumentLuceneRequest.limit) && Objects.equals(this.offset, queryDocumentLuceneRequest.offset) && Objects.equals(this.credentialsSubset, queryDocumentLuceneRequest.credentialsSubset);
    }

    public int hashCode() {
        return Objects.hash(this.datasetId, this.expression, this.limit, this.offset, this.credentialsSubset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryDocumentLuceneRequest {\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    expression: ").append(this.toIndentedString(this.expression)).append("\n");
        sb.append("    limit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("    offset: ").append(this.toIndentedString(this.offset)).append("\n");
        sb.append("    credentialsSubset: ").append(this.toIndentedString(this.credentialsSubset)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

