/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"document_id", "pdfPreviewBytes", "videoThumbnailBytes", "createPdfPreview", "createVideoThumbnail", "documentRowId", "documentMetadataRowId"})
@JsonTypeName(value="KoverseDocumentMetadata")
public class KoverseDocumentMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOCUMENT_ID = "document_id";
    private UUID documentId;
    public static final String JSON_PROPERTY_PDF_PREVIEW_BYTES = "pdfPreviewBytes";
    private String pdfPreviewBytes;
    public static final String JSON_PROPERTY_VIDEO_THUMBNAIL_BYTES = "videoThumbnailBytes";
    private String videoThumbnailBytes;
    public static final String JSON_PROPERTY_CREATE_PDF_PREVIEW = "createPdfPreview";
    private Boolean createPdfPreview;
    public static final String JSON_PROPERTY_CREATE_VIDEO_THUMBNAIL = "createVideoThumbnail";
    private Boolean createVideoThumbnail;
    public static final String JSON_PROPERTY_DOCUMENT_ROW_ID = "documentRowId";
    private String documentRowId;
    public static final String JSON_PROPERTY_DOCUMENT_METADATA_ROW_ID = "documentMetadataRowId";
    private String documentMetadataRowId;

    public KoverseDocumentMetadata documentId(UUID documentId) {
        this.documentId = documentId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="koverse document id")
    @JsonProperty(value="document_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDocumentId() {
        return this.documentId;
    }

    @JsonProperty(value="document_id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDocumentId(UUID documentId) {
        this.documentId = documentId;
    }

    public KoverseDocumentMetadata pdfPreviewBytes(String pdfPreviewBytes) {
        this.pdfPreviewBytes = pdfPreviewBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PDF preview bytes")
    @JsonProperty(value="pdfPreviewBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPdfPreviewBytes() {
        return this.pdfPreviewBytes;
    }

    @JsonProperty(value="pdfPreviewBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPdfPreviewBytes(String pdfPreviewBytes) {
        this.pdfPreviewBytes = pdfPreviewBytes;
    }

    public KoverseDocumentMetadata videoThumbnailBytes(String videoThumbnailBytes) {
        this.videoThumbnailBytes = videoThumbnailBytes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="video thumbnail bytes")
    @JsonProperty(value="videoThumbnailBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVideoThumbnailBytes() {
        return this.videoThumbnailBytes;
    }

    @JsonProperty(value="videoThumbnailBytes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVideoThumbnailBytes(String videoThumbnailBytes) {
        this.videoThumbnailBytes = videoThumbnailBytes;
    }

    public KoverseDocumentMetadata createPdfPreview(Boolean createPdfPreview) {
        this.createPdfPreview = createPdfPreview;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="create PDF preview bytes")
    @JsonProperty(value="createPdfPreview")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCreatePdfPreview() {
        return this.createPdfPreview;
    }

    @JsonProperty(value="createPdfPreview")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatePdfPreview(Boolean createPdfPreview) {
        this.createPdfPreview = createPdfPreview;
    }

    public KoverseDocumentMetadata createVideoThumbnail(Boolean createVideoThumbnail) {
        this.createVideoThumbnail = createVideoThumbnail;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="create video thumbnail bytes")
    @JsonProperty(value="createVideoThumbnail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getCreateVideoThumbnail() {
        return this.createVideoThumbnail;
    }

    @JsonProperty(value="createVideoThumbnail")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreateVideoThumbnail(Boolean createVideoThumbnail) {
        this.createVideoThumbnail = createVideoThumbnail;
    }

    public KoverseDocumentMetadata documentRowId(String documentRowId) {
        this.documentRowId = documentRowId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="the row id of the document record in accumulo")
    @JsonProperty(value="documentRowId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDocumentRowId() {
        return this.documentRowId;
    }

    @JsonProperty(value="documentRowId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDocumentRowId(String documentRowId) {
        this.documentRowId = documentRowId;
    }

    public KoverseDocumentMetadata documentMetadataRowId(String documentMetadataRowId) {
        this.documentMetadataRowId = documentMetadataRowId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="the row id of the document metadata record in accumulo")
    @JsonProperty(value="documentMetadataRowId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDocumentMetadataRowId() {
        return this.documentMetadataRowId;
    }

    @JsonProperty(value="documentMetadataRowId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDocumentMetadataRowId(String documentMetadataRowId) {
        this.documentMetadataRowId = documentMetadataRowId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KoverseDocumentMetadata koverseDocumentMetadata = (KoverseDocumentMetadata)o;
        return Objects.equals(this.documentId, koverseDocumentMetadata.documentId) && Objects.equals(this.pdfPreviewBytes, koverseDocumentMetadata.pdfPreviewBytes) && Objects.equals(this.videoThumbnailBytes, koverseDocumentMetadata.videoThumbnailBytes) && Objects.equals(this.createPdfPreview, koverseDocumentMetadata.createPdfPreview) && Objects.equals(this.createVideoThumbnail, koverseDocumentMetadata.createVideoThumbnail) && Objects.equals(this.documentRowId, koverseDocumentMetadata.documentRowId) && Objects.equals(this.documentMetadataRowId, koverseDocumentMetadata.documentMetadataRowId);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.pdfPreviewBytes, this.videoThumbnailBytes, this.createPdfPreview, this.createVideoThumbnail, this.documentRowId, this.documentMetadataRowId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KoverseDocumentMetadata {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    pdfPreviewBytes: ").append(this.toIndentedString(this.pdfPreviewBytes)).append("\n");
        sb.append("    videoThumbnailBytes: ").append(this.toIndentedString(this.videoThumbnailBytes)).append("\n");
        sb.append("    createPdfPreview: ").append(this.toIndentedString(this.createPdfPreview)).append("\n");
        sb.append("    createVideoThumbnail: ").append(this.toIndentedString(this.createVideoThumbnail)).append("\n");
        sb.append("    documentRowId: ").append(this.toIndentedString(this.documentRowId)).append("\n");
        sb.append("    documentMetadataRowId: ").append(this.toIndentedString(this.documentMetadataRowId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

