/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"key", "secret", "authorizeUrl", "accessUrl", "profileUrl", "scope", "nonce", "state", "oauth"})
@JsonTypeName(value="KeycloakProviderConfiguration")
public class KeycloakProviderConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_SECRET = "secret";
    private String secret;
    public static final String JSON_PROPERTY_AUTHORIZE_URL = "authorizeUrl";
    private String authorizeUrl;
    public static final String JSON_PROPERTY_ACCESS_URL = "accessUrl";
    private String accessUrl;
    public static final String JSON_PROPERTY_PROFILE_URL = "profileUrl";
    private Object profileUrl = null;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private List<String> scope = null;
    public static final String JSON_PROPERTY_NONCE = "nonce";
    private Boolean nonce;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_OAUTH = "oauth";
    private BigDecimal oauth;

    public KeycloakProviderConfiguration key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Key for keycloak configuration")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(String key) {
        this.key = key;
    }

    public KeycloakProviderConfiguration secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Secret for keycloak configuration")
    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getSecret() {
        return this.secret;
    }

    @JsonProperty(value="secret")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSecret(String secret) {
        this.secret = secret;
    }

    public KeycloakProviderConfiguration authorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Url for keycloak authentication")
    @JsonProperty(value="authorizeUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    @JsonProperty(value="authorizeUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public KeycloakProviderConfiguration accessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Url for keycloak token")
    @JsonProperty(value="accessUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessUrl() {
        return this.accessUrl;
    }

    @JsonProperty(value="accessUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessUrl(String accessUrl) {
        this.accessUrl = accessUrl;
    }

    public KeycloakProviderConfiguration profileUrl(Object profileUrl) {
        this.profileUrl = profileUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Url for keycloak user information")
    @JsonProperty(value="profileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getProfileUrl() {
        return this.profileUrl;
    }

    @JsonProperty(value="profileUrl")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfileUrl(Object profileUrl) {
        this.profileUrl = profileUrl;
    }

    public KeycloakProviderConfiguration scope(List<String> scope) {
        this.scope = scope;
        return this;
    }

    public KeycloakProviderConfiguration addScopeItem(String scopeItem) {
        if (this.scope == null) {
            this.scope = new ArrayList<String>();
        }
        this.scope.add(scopeItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"openId\", \"email\"]", value="Scope of the SSO configuration")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public KeycloakProviderConfiguration nonce(Boolean nonce) {
        this.nonce = nonce;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="When enabled provides a random value generated by your app that enables replay protection.")
    @JsonProperty(value="nonce")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getNonce() {
        return this.nonce;
    }

    @JsonProperty(value="nonce")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNonce(Boolean nonce) {
        this.nonce = nonce;
    }

    public KeycloakProviderConfiguration state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="koverse", value="Keycloak configuration state")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public KeycloakProviderConfiguration oauth(BigDecimal oauth) {
        this.oauth = oauth;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OAuth version")
    @JsonProperty(value="oauth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getOauth() {
        return this.oauth;
    }

    @JsonProperty(value="oauth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOauth(BigDecimal oauth) {
        this.oauth = oauth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeycloakProviderConfiguration keycloakProviderConfiguration = (KeycloakProviderConfiguration)o;
        return Objects.equals(this.key, keycloakProviderConfiguration.key) && Objects.equals(this.secret, keycloakProviderConfiguration.secret) && Objects.equals(this.authorizeUrl, keycloakProviderConfiguration.authorizeUrl) && Objects.equals(this.accessUrl, keycloakProviderConfiguration.accessUrl) && Objects.equals(this.profileUrl, keycloakProviderConfiguration.profileUrl) && Objects.equals(this.scope, keycloakProviderConfiguration.scope) && Objects.equals(this.nonce, keycloakProviderConfiguration.nonce) && Objects.equals(this.state, keycloakProviderConfiguration.state) && Objects.equals(this.oauth, keycloakProviderConfiguration.oauth);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.secret, this.authorizeUrl, this.accessUrl, this.profileUrl, this.scope, this.nonce, this.state, this.oauth);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeycloakProviderConfiguration {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    authorizeUrl: ").append(this.toIndentedString(this.authorizeUrl)).append("\n");
        sb.append("    accessUrl: ").append(this.toIndentedString(this.accessUrl)).append("\n");
        sb.append("    profileUrl: ").append(this.toIndentedString(this.profileUrl)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    nonce: ").append(this.toIndentedString(this.nonce)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    oauth: ").append(this.toIndentedString(this.oauth)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

