/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "type", "status", "config", "error", "stage", "totalStages", "datasetId", "workspaceId", "userId"})
@JsonTypeName(value="Job")
public class Job
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private Object config;
    public static final String JSON_PROPERTY_ERROR = "error";
    private Object error;
    public static final String JSON_PROPERTY_STAGE = "stage";
    private BigDecimal stage;
    public static final String JSON_PROPERTY_TOTAL_STAGES = "totalStages";
    private BigDecimal totalStages;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private UUID userId;

    public Job id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="job ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Job type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="job type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Job status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="job status")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Job config(Object config) {
        this.config = config;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="job config")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfig(Object config) {
        this.config = config;
    }

    public Job error(Object error) {
        this.error = error;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="job error")
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(Object error) {
        this.error = error;
    }

    public Job stage(BigDecimal stage) {
        this.stage = stage;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="job stage")
    @JsonProperty(value="stage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getStage() {
        return this.stage;
    }

    @JsonProperty(value="stage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStage(BigDecimal stage) {
        this.stage = stage;
    }

    public Job totalStages(BigDecimal totalStages) {
        this.totalStages = totalStages;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="count of stages")
    @JsonProperty(value="totalStages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigDecimal getTotalStages() {
        return this.totalStages;
    }

    @JsonProperty(value="totalStages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTotalStages(BigDecimal totalStages) {
        this.totalStages = totalStages;
    }

    public Job datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="dataset ID")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public Job workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="workspace ID")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Job userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="user ID")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        return Objects.equals(this.id, job.id) && Objects.equals((Object)this.type, (Object)job.type) && Objects.equals((Object)this.status, (Object)job.status) && Objects.equals(this.config, job.config) && Objects.equals(this.error, job.error) && Objects.equals(this.stage, job.stage) && Objects.equals(this.totalStages, job.totalStages) && Objects.equals(this.datasetId, job.datasetId) && Objects.equals(this.workspaceId, job.workspaceId) && Objects.equals(this.userId, job.userId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.status, this.config, this.error, this.stage, this.totalStages, this.datasetId, this.workspaceId, this.userId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Job {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    stage: ").append(this.toIndentedString(this.stage)).append("\n");
        sb.append("    totalStages: ").append(this.toIndentedString(this.totalStages)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        INGEST("ingest"),
        REINDEX("reindex"),
        CLEAR_DATASET("clear-dataset"),
        DELETE_RECORD("delete-record"),
        DELETE_DOCUMENT("delete-document");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        QUEUED("queued"),
        RUNNING("running"),
        COMPLETED("completed"),
        CANCELED("canceled"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

