/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="delete record by ids request")
@JsonPropertyOrder(value={"recordIds", "deleteAll"})
@JsonTypeName(value="DeleteRecordByIdRequest")
public class DeleteRecordByIdRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_RECORD_IDS = "recordIds";
    private List<String> recordIds = new ArrayList<String>();
    public static final String JSON_PROPERTY_DELETE_ALL = "deleteAll";
    private Boolean deleteAll = false;

    public DeleteRecordByIdRequest recordIds(List<String> recordIds) {
        this.recordIds = recordIds;
        return this;
    }

    public DeleteRecordByIdRequest addRecordIdsItem(String recordIdsItem) {
        this.recordIds.add(recordIdsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Ids of the records to be deleted. To delete all the records in the dataset set this to empty array and set deleteAll parameter to true")
    @JsonProperty(value="recordIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public List<String> getRecordIds() {
        return this.recordIds;
    }

    @JsonProperty(value="recordIds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecordIds(List<String> recordIds) {
        this.recordIds = recordIds;
    }

    public DeleteRecordByIdRequest deleteAll(Boolean deleteAll) {
        this.deleteAll = deleteAll;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="If this boolean is set to true, delete all records in the dataset that are visible to the user")
    @JsonProperty(value="deleteAll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getDeleteAll() {
        return this.deleteAll;
    }

    @JsonProperty(value="deleteAll")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeleteAll(Boolean deleteAll) {
        this.deleteAll = deleteAll;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteRecordByIdRequest deleteRecordByIdRequest = (DeleteRecordByIdRequest)o;
        return Objects.equals(this.recordIds, deleteRecordByIdRequest.recordIds) && Objects.equals(this.deleteAll, deleteRecordByIdRequest.deleteAll);
    }

    public int hashCode() {
        return Objects.hash(this.recordIds, this.deleteAll);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeleteRecordByIdRequest {\n");
        sb.append("    recordIds: ").append(this.toIndentedString(this.recordIds)).append("\n");
        sb.append("    deleteAll: ").append(this.toIndentedString(this.deleteAll)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

