/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@JsonPropertyOrder(value={"id", "datasetId", "status", "type", "key", "createdByUserId", "isOriginWorkspace", "host", "workspaceId", "workspaceUniqueId", "syncId", "syncHost", "syncDatasetId", "syncWorkspaceId", "syncWorkspaceUniqueId", "lastSyncAt"})
@JsonTypeName(value="dataset_sync_update_request")
public class DatasetSyncUpdateRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_CREATED_BY_USER_ID = "createdByUserId";
    private UUID createdByUserId;
    public static final String JSON_PROPERTY_IS_ORIGIN_WORKSPACE = "isOriginWorkspace";
    private Boolean isOriginWorkspace;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_WORKSPACE_UNIQUE_ID = "workspaceUniqueId";
    private UUID workspaceUniqueId;
    public static final String JSON_PROPERTY_SYNC_ID = "syncId";
    private UUID syncId;
    public static final String JSON_PROPERTY_SYNC_HOST = "syncHost";
    private String syncHost;
    public static final String JSON_PROPERTY_SYNC_DATASET_ID = "syncDatasetId";
    private UUID syncDatasetId;
    public static final String JSON_PROPERTY_SYNC_WORKSPACE_ID = "syncWorkspaceId";
    private Object syncWorkspaceId = null;
    public static final String JSON_PROPERTY_SYNC_WORKSPACE_UNIQUE_ID = "syncWorkspaceUniqueId";
    private UUID syncWorkspaceUniqueId;
    public static final String JSON_PROPERTY_LAST_SYNC_AT = "lastSyncAt";
    private OffsetDateTime lastSyncAt;

    public DatasetSyncUpdateRequest id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="dataset sync ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public DatasetSyncUpdateRequest datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="dataset ID")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public DatasetSyncUpdateRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Status of the dataset sync.<br>Pending, active, or canceled.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DatasetSyncUpdateRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Type of the Dataset Sync<br><br>read - the paired replica dataset can only read records from the origin dataset <br><br>write - the paired replica dataset can only write records to the origin dataset <br><br>manage - the paired replica dataset can read records from the origin dataset, <br>write records to the origin dataset, and delete records from the origin dataset")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DatasetSyncUpdateRequest key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Security key used for the dataset sync")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(String key) {
        this.key = key;
    }

    public DatasetSyncUpdateRequest createdByUserId(UUID createdByUserId) {
        this.createdByUserId = createdByUserId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID of User that created the dataset sync")
    @JsonProperty(value="createdByUserId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonProperty(value="createdByUserId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCreatedByUserId(UUID createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public DatasetSyncUpdateRequest isOriginWorkspace(Boolean isOriginWorkspace) {
        this.isOriginWorkspace = isOriginWorkspace;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Indicates if dataset for sync originates in this workspace")
    @JsonProperty(value="isOriginWorkspace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getIsOriginWorkspace() {
        return this.isOriginWorkspace;
    }

    @JsonProperty(value="isOriginWorkspace")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIsOriginWorkspace(Boolean isOriginWorkspace) {
        this.isOriginWorkspace = isOriginWorkspace;
    }

    public DatasetSyncUpdateRequest host(String host) {
        this.host = host;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="myKoverseWorkspaceName.api.myKoverseHostName.com", required=true, value="Our Host name")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setHost(String host) {
        this.host = host;
    }

    public DatasetSyncUpdateRequest workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="myWorkspace", required=true, value="Our workspace ID")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public DatasetSyncUpdateRequest workspaceUniqueId(UUID workspaceUniqueId) {
        this.workspaceUniqueId = workspaceUniqueId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Our workspace uniqueId")
    @JsonProperty(value="workspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getWorkspaceUniqueId() {
        return this.workspaceUniqueId;
    }

    @JsonProperty(value="workspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkspaceUniqueId(UUID workspaceUniqueId) {
        this.workspaceUniqueId = workspaceUniqueId;
    }

    public DatasetSyncUpdateRequest syncId(UUID syncId) {
        this.syncId = syncId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the dataset-sync in paired Sync Workspace  *For a paired replica, this is the Origin Dataset Sync ID*  *For the origin sync, this is the Paired Replica Dataset Sync ID* ")
    @JsonProperty(value="syncId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSyncId() {
        return this.syncId;
    }

    @JsonProperty(value="syncId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncId(UUID syncId) {
        this.syncId = syncId;
    }

    public DatasetSyncUpdateRequest syncHost(String syncHost) {
        this.syncHost = syncHost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="myReplicaWorkspaceName.api.myReplicaKoverseHostName.com", value="The Host Name of the paired Sync Workspace")
    @JsonProperty(value="syncHost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSyncHost() {
        return this.syncHost;
    }

    @JsonProperty(value="syncHost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncHost(String syncHost) {
        this.syncHost = syncHost;
    }

    public DatasetSyncUpdateRequest syncDatasetId(UUID syncDatasetId) {
        this.syncDatasetId = syncDatasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the dataset in paired Sync Workspace")
    @JsonProperty(value="syncDatasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSyncDatasetId() {
        return this.syncDatasetId;
    }

    @JsonProperty(value="syncDatasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncDatasetId(UUID syncDatasetId) {
        this.syncDatasetId = syncDatasetId;
    }

    public DatasetSyncUpdateRequest syncWorkspaceId(Object syncWorkspaceId) {
        this.syncWorkspaceId = syncWorkspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the paired Sync Workspace")
    @JsonProperty(value="syncWorkspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSyncWorkspaceId() {
        return this.syncWorkspaceId;
    }

    @JsonProperty(value="syncWorkspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncWorkspaceId(Object syncWorkspaceId) {
        this.syncWorkspaceId = syncWorkspaceId;
    }

    public DatasetSyncUpdateRequest syncWorkspaceUniqueId(UUID syncWorkspaceUniqueId) {
        this.syncWorkspaceUniqueId = syncWorkspaceUniqueId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UniqueId of the paired Sync Workspace")
    @JsonProperty(value="syncWorkspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSyncWorkspaceUniqueId() {
        return this.syncWorkspaceUniqueId;
    }

    @JsonProperty(value="syncWorkspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncWorkspaceUniqueId(UUID syncWorkspaceUniqueId) {
        this.syncWorkspaceUniqueId = syncWorkspaceUniqueId;
    }

    public DatasetSyncUpdateRequest lastSyncAt(OffsetDateTime lastSyncAt) {
        this.lastSyncAt = lastSyncAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last Sync At - Time of last successful Sync")
    @JsonProperty(value="lastSyncAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastSyncAt() {
        return this.lastSyncAt;
    }

    @JsonProperty(value="lastSyncAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastSyncAt(OffsetDateTime lastSyncAt) {
        this.lastSyncAt = lastSyncAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetSyncUpdateRequest datasetSyncUpdateRequest = (DatasetSyncUpdateRequest)o;
        return Objects.equals(this.id, datasetSyncUpdateRequest.id) && Objects.equals(this.datasetId, datasetSyncUpdateRequest.datasetId) && Objects.equals((Object)this.status, (Object)datasetSyncUpdateRequest.status) && Objects.equals((Object)this.type, (Object)datasetSyncUpdateRequest.type) && Objects.equals(this.key, datasetSyncUpdateRequest.key) && Objects.equals(this.createdByUserId, datasetSyncUpdateRequest.createdByUserId) && Objects.equals(this.isOriginWorkspace, datasetSyncUpdateRequest.isOriginWorkspace) && Objects.equals(this.host, datasetSyncUpdateRequest.host) && Objects.equals(this.workspaceId, datasetSyncUpdateRequest.workspaceId) && Objects.equals(this.workspaceUniqueId, datasetSyncUpdateRequest.workspaceUniqueId) && Objects.equals(this.syncId, datasetSyncUpdateRequest.syncId) && Objects.equals(this.syncHost, datasetSyncUpdateRequest.syncHost) && Objects.equals(this.syncDatasetId, datasetSyncUpdateRequest.syncDatasetId) && Objects.equals(this.syncWorkspaceId, datasetSyncUpdateRequest.syncWorkspaceId) && Objects.equals(this.syncWorkspaceUniqueId, datasetSyncUpdateRequest.syncWorkspaceUniqueId) && Objects.equals(this.lastSyncAt, datasetSyncUpdateRequest.lastSyncAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.datasetId, this.status, this.type, this.key, this.createdByUserId, this.isOriginWorkspace, this.host, this.workspaceId, this.workspaceUniqueId, this.syncId, this.syncHost, this.syncDatasetId, this.syncWorkspaceId, this.syncWorkspaceUniqueId, this.lastSyncAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetSyncUpdateRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    createdByUserId: ").append(this.toIndentedString(this.createdByUserId)).append("\n");
        sb.append("    isOriginWorkspace: ").append(this.toIndentedString(this.isOriginWorkspace)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    workspaceUniqueId: ").append(this.toIndentedString(this.workspaceUniqueId)).append("\n");
        sb.append("    syncId: ").append(this.toIndentedString(this.syncId)).append("\n");
        sb.append("    syncHost: ").append(this.toIndentedString(this.syncHost)).append("\n");
        sb.append("    syncDatasetId: ").append(this.toIndentedString(this.syncDatasetId)).append("\n");
        sb.append("    syncWorkspaceId: ").append(this.toIndentedString(this.syncWorkspaceId)).append("\n");
        sb.append("    syncWorkspaceUniqueId: ").append(this.toIndentedString(this.syncWorkspaceUniqueId)).append("\n");
        sb.append("    lastSyncAt: ").append(this.toIndentedString(this.lastSyncAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        ACTIVE("active"),
        CANCELED("canceled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        READ("read"),
        WRITE("write"),
        MANAGE("manage");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

