/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.threeten.bp.OffsetDateTime;

@JsonPropertyOrder(value={"id", "datasetId", "status", "type", "key", "createdByUserId", "isOriginWorkspace", "host", "workspaceId", "workspaceUniqueId", "syncId", "syncHost", "syncDatasetId", "syncWorkspaceId", "syncWorkspaceUniqueId", "lastSyncAt"})
@JsonTypeName(value="dataset_sync_patch_request")
public class DatasetSyncPatchRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_CREATED_BY_USER_ID = "createdByUserId";
    private UUID createdByUserId;
    public static final String JSON_PROPERTY_IS_ORIGIN_WORKSPACE = "isOriginWorkspace";
    private Boolean isOriginWorkspace;
    public static final String JSON_PROPERTY_HOST = "host";
    private String host;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_WORKSPACE_UNIQUE_ID = "workspaceUniqueId";
    private UUID workspaceUniqueId;
    public static final String JSON_PROPERTY_SYNC_ID = "syncId";
    private UUID syncId;
    public static final String JSON_PROPERTY_SYNC_HOST = "syncHost";
    private String syncHost;
    public static final String JSON_PROPERTY_SYNC_DATASET_ID = "syncDatasetId";
    private UUID syncDatasetId;
    public static final String JSON_PROPERTY_SYNC_WORKSPACE_ID = "syncWorkspaceId";
    private Object syncWorkspaceId = null;
    public static final String JSON_PROPERTY_SYNC_WORKSPACE_UNIQUE_ID = "syncWorkspaceUniqueId";
    private UUID syncWorkspaceUniqueId;
    public static final String JSON_PROPERTY_LAST_SYNC_AT = "lastSyncAt";
    private OffsetDateTime lastSyncAt;

    public DatasetSyncPatchRequest id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="dataset sync ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public DatasetSyncPatchRequest datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="dataset ID")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public DatasetSyncPatchRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Status of the dataset sync.<br>Pending, active, or canceled.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public DatasetSyncPatchRequest type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of the Dataset Sync<br><br>read - the paired replica dataset can only read records from the origin dataset <br><br>write - the paired replica dataset can only write records to the origin dataset <br><br>manage - the paired replica dataset can read records from the origin dataset, <br>write records to the origin dataset, and delete records from the origin dataset")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DatasetSyncPatchRequest key(String key) {
        this.key = key;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Security key used for the dataset sync")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKey(String key) {
        this.key = key;
    }

    public DatasetSyncPatchRequest createdByUserId(UUID createdByUserId) {
        this.createdByUserId = createdByUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of User that created the dataset sync")
    @JsonProperty(value="createdByUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getCreatedByUserId() {
        return this.createdByUserId;
    }

    @JsonProperty(value="createdByUserId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedByUserId(UUID createdByUserId) {
        this.createdByUserId = createdByUserId;
    }

    public DatasetSyncPatchRequest isOriginWorkspace(Boolean isOriginWorkspace) {
        this.isOriginWorkspace = isOriginWorkspace;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if dataset for sync originates in this workspace")
    @JsonProperty(value="isOriginWorkspace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getIsOriginWorkspace() {
        return this.isOriginWorkspace;
    }

    @JsonProperty(value="isOriginWorkspace")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsOriginWorkspace(Boolean isOriginWorkspace) {
        this.isOriginWorkspace = isOriginWorkspace;
    }

    public DatasetSyncPatchRequest host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="myKoverseWorkspaceName.api.myKoverseHostName.com", value="Our Host name")
    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getHost() {
        return this.host;
    }

    @JsonProperty(value="host")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHost(String host) {
        this.host = host;
    }

    public DatasetSyncPatchRequest workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="myWorkspace", value="Our workspace ID")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public DatasetSyncPatchRequest workspaceUniqueId(UUID workspaceUniqueId) {
        this.workspaceUniqueId = workspaceUniqueId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Our workspace uniqueId")
    @JsonProperty(value="workspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getWorkspaceUniqueId() {
        return this.workspaceUniqueId;
    }

    @JsonProperty(value="workspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspaceUniqueId(UUID workspaceUniqueId) {
        this.workspaceUniqueId = workspaceUniqueId;
    }

    public DatasetSyncPatchRequest syncId(UUID syncId) {
        this.syncId = syncId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the dataset-sync in paired Sync Workspace  *For a paired replica, this is the Origin Dataset Sync ID*  *For the origin sync, this is the Paired Replica Dataset Sync ID* ")
    @JsonProperty(value="syncId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSyncId() {
        return this.syncId;
    }

    @JsonProperty(value="syncId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncId(UUID syncId) {
        this.syncId = syncId;
    }

    public DatasetSyncPatchRequest syncHost(String syncHost) {
        this.syncHost = syncHost;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="myReplicaWorkspaceName.api.myReplicaKoverseHostName.com", value="The Host Name of the paired Sync Workspace")
    @JsonProperty(value="syncHost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSyncHost() {
        return this.syncHost;
    }

    @JsonProperty(value="syncHost")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncHost(String syncHost) {
        this.syncHost = syncHost;
    }

    public DatasetSyncPatchRequest syncDatasetId(UUID syncDatasetId) {
        this.syncDatasetId = syncDatasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the dataset in paired Sync Workspace")
    @JsonProperty(value="syncDatasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSyncDatasetId() {
        return this.syncDatasetId;
    }

    @JsonProperty(value="syncDatasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncDatasetId(UUID syncDatasetId) {
        this.syncDatasetId = syncDatasetId;
    }

    public DatasetSyncPatchRequest syncWorkspaceId(Object syncWorkspaceId) {
        this.syncWorkspaceId = syncWorkspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the paired Sync Workspace")
    @JsonProperty(value="syncWorkspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getSyncWorkspaceId() {
        return this.syncWorkspaceId;
    }

    @JsonProperty(value="syncWorkspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncWorkspaceId(Object syncWorkspaceId) {
        this.syncWorkspaceId = syncWorkspaceId;
    }

    public DatasetSyncPatchRequest syncWorkspaceUniqueId(UUID syncWorkspaceUniqueId) {
        this.syncWorkspaceUniqueId = syncWorkspaceUniqueId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UniqueId of the paired Sync Workspace")
    @JsonProperty(value="syncWorkspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getSyncWorkspaceUniqueId() {
        return this.syncWorkspaceUniqueId;
    }

    @JsonProperty(value="syncWorkspaceUniqueId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSyncWorkspaceUniqueId(UUID syncWorkspaceUniqueId) {
        this.syncWorkspaceUniqueId = syncWorkspaceUniqueId;
    }

    public DatasetSyncPatchRequest lastSyncAt(OffsetDateTime lastSyncAt) {
        this.lastSyncAt = lastSyncAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Last Sync At - Time of last successful Sync")
    @JsonProperty(value="lastSyncAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastSyncAt() {
        return this.lastSyncAt;
    }

    @JsonProperty(value="lastSyncAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLastSyncAt(OffsetDateTime lastSyncAt) {
        this.lastSyncAt = lastSyncAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetSyncPatchRequest datasetSyncPatchRequest = (DatasetSyncPatchRequest)o;
        return Objects.equals(this.id, datasetSyncPatchRequest.id) && Objects.equals(this.datasetId, datasetSyncPatchRequest.datasetId) && Objects.equals((Object)this.status, (Object)datasetSyncPatchRequest.status) && Objects.equals((Object)this.type, (Object)datasetSyncPatchRequest.type) && Objects.equals(this.key, datasetSyncPatchRequest.key) && Objects.equals(this.createdByUserId, datasetSyncPatchRequest.createdByUserId) && Objects.equals(this.isOriginWorkspace, datasetSyncPatchRequest.isOriginWorkspace) && Objects.equals(this.host, datasetSyncPatchRequest.host) && Objects.equals(this.workspaceId, datasetSyncPatchRequest.workspaceId) && Objects.equals(this.workspaceUniqueId, datasetSyncPatchRequest.workspaceUniqueId) && Objects.equals(this.syncId, datasetSyncPatchRequest.syncId) && Objects.equals(this.syncHost, datasetSyncPatchRequest.syncHost) && Objects.equals(this.syncDatasetId, datasetSyncPatchRequest.syncDatasetId) && Objects.equals(this.syncWorkspaceId, datasetSyncPatchRequest.syncWorkspaceId) && Objects.equals(this.syncWorkspaceUniqueId, datasetSyncPatchRequest.syncWorkspaceUniqueId) && Objects.equals(this.lastSyncAt, datasetSyncPatchRequest.lastSyncAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.datasetId, this.status, this.type, this.key, this.createdByUserId, this.isOriginWorkspace, this.host, this.workspaceId, this.workspaceUniqueId, this.syncId, this.syncHost, this.syncDatasetId, this.syncWorkspaceId, this.syncWorkspaceUniqueId, this.lastSyncAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetSyncPatchRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    createdByUserId: ").append(this.toIndentedString(this.createdByUserId)).append("\n");
        sb.append("    isOriginWorkspace: ").append(this.toIndentedString(this.isOriginWorkspace)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    workspaceUniqueId: ").append(this.toIndentedString(this.workspaceUniqueId)).append("\n");
        sb.append("    syncId: ").append(this.toIndentedString(this.syncId)).append("\n");
        sb.append("    syncHost: ").append(this.toIndentedString(this.syncHost)).append("\n");
        sb.append("    syncDatasetId: ").append(this.toIndentedString(this.syncDatasetId)).append("\n");
        sb.append("    syncWorkspaceId: ").append(this.toIndentedString(this.syncWorkspaceId)).append("\n");
        sb.append("    syncWorkspaceUniqueId: ").append(this.toIndentedString(this.syncWorkspaceUniqueId)).append("\n");
        sb.append("    lastSyncAt: ").append(this.toIndentedString(this.lastSyncAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StatusEnum {
        PENDING("pending"),
        ACTIVE("active"),
        CANCELED("canceled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TypeEnum {
        READ("read"),
        WRITE("write"),
        MANAGE("manage");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

