/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.koverse.kdpapi.client.model.KeycloakProviderConfiguration;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "workspaceId", "providerType", "config"})
@JsonTypeName(value="CustomIdentityProvider")
public class CustomIdentityProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private UUID workspaceId;
    public static final String JSON_PROPERTY_PROVIDER_TYPE = "providerType";
    private ProviderTypeEnum providerType;
    public static final String JSON_PROPERTY_CONFIG = "config";
    private KeycloakProviderConfiguration config;

    public CustomIdentityProvider id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="custom identity provider ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public CustomIdentityProvider workspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkspaceId(UUID workspaceId) {
        this.workspaceId = workspaceId;
    }

    public CustomIdentityProvider providerType(ProviderTypeEnum providerType) {
        this.providerType = providerType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="providerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ProviderTypeEnum getProviderType() {
        return this.providerType;
    }

    @JsonProperty(value="providerType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setProviderType(ProviderTypeEnum providerType) {
        this.providerType = providerType;
    }

    public CustomIdentityProvider config(KeycloakProviderConfiguration config) {
        this.config = config;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public KeycloakProviderConfiguration getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setConfig(KeycloakProviderConfiguration config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomIdentityProvider customIdentityProvider = (CustomIdentityProvider)o;
        return Objects.equals(this.id, customIdentityProvider.id) && Objects.equals(this.workspaceId, customIdentityProvider.workspaceId) && Objects.equals((Object)this.providerType, (Object)customIdentityProvider.providerType) && Objects.equals(this.config, customIdentityProvider.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.workspaceId, this.providerType, this.config});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomIdentityProvider {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    providerType: ").append(this.toIndentedString((Object)this.providerType)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ProviderTypeEnum {
        KEYCLOAK("keycloak");

        private String value;

        private ProviderTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ProviderTypeEnum fromValue(String value) {
            for (ProviderTypeEnum b : ProviderTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

