/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains the configuration parameters for making a connection to Ingest Data")
@JsonPropertyOrder(value={"urls", "processAsDocument", "processWithOcr"})
@JsonTypeName(value="ConnectionInfo")
public class ConnectionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_URLS = "urls";
    private List<String> urls = null;
    public static final String JSON_PROPERTY_PROCESS_AS_DOCUMENT = "processAsDocument";
    private Boolean processAsDocument;
    public static final String JSON_PROPERTY_PROCESS_WITH_OCR = "processWithOcr";
    private Boolean processWithOcr = false;

    public ConnectionInfo urls(List<String> urls) {
        this.urls = urls;
        return this;
    }

    public ConnectionInfo addUrlsItem(String urlsItem) {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        this.urls.add(urlsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="- \"https://kisp-test.s3-us-west-2.amazonaws.com/nightly_tests/test.csv\" - \"https://kisp-test.s3-us-west-2.amazonaws.com/nightly_tests/test.xls\" ", value="array of urls")
    @JsonProperty(value="urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getUrls() {
        return this.urls;
    }

    @JsonProperty(value="urls")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public ConnectionInfo processAsDocument(Boolean processAsDocument) {
        this.processAsDocument = processAsDocument;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Process the Uploaded File as a Document - for data files (such as CSV) setting this value to true will result in a single CSV document being ingested for preview instead of each individual data row being written as separate records")
    @JsonProperty(value="processAsDocument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProcessAsDocument() {
        return this.processAsDocument;
    }

    @JsonProperty(value="processAsDocument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessAsDocument(Boolean processAsDocument) {
        this.processAsDocument = processAsDocument;
    }

    public ConnectionInfo processWithOcr(Boolean processWithOcr) {
        this.processWithOcr = processWithOcr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL and S3 data sources only - Process the Uploaded PDF and image files (JPG, PNG and TIFF) with OCR. Setting this value to true will result in the file being processed with text recognition, storing the OCR extracted text in the body of the dataset record; if left as the default setting of false, the body element will not be set or returned in the dataset record")
    @JsonProperty(value="processWithOcr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProcessWithOcr() {
        return this.processWithOcr;
    }

    @JsonProperty(value="processWithOcr")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProcessWithOcr(Boolean processWithOcr) {
        this.processWithOcr = processWithOcr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionInfo connectionInfo = (ConnectionInfo)o;
        return Objects.equals(this.urls, connectionInfo.urls) && Objects.equals(this.processAsDocument, connectionInfo.processAsDocument) && Objects.equals(this.processWithOcr, connectionInfo.processWithOcr);
    }

    public int hashCode() {
        return Objects.hash(this.urls, this.processAsDocument, this.processWithOcr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionInfo {\n");
        sb.append("    urls: ").append(this.toIndentedString(this.urls)).append("\n");
        sb.append("    processAsDocument: ").append(this.toIndentedString(this.processAsDocument)).append("\n");
        sb.append("    processWithOcr: ").append(this.toIndentedString(this.processWithOcr)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

