/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonPropertyOrder(value={"strategy", "access_token"})
@JsonTypeName(value="AuthenticationSSO")
public class AuthenticationSSO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_STRATEGY = "strategy";
    private StrategyEnum strategy;
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    private String accessToken;

    public AuthenticationSSO strategy(StrategyEnum strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The method of authentication for single sign-on customers")
    @JsonProperty(value="strategy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StrategyEnum getStrategy() {
        return this.strategy;
    }

    @JsonProperty(value="strategy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStrategy(StrategyEnum strategy) {
        this.strategy = strategy;
    }

    public AuthenticationSSO accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The access_token retrieved by signing into the SSO account")
    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationSSO authenticationSSO = (AuthenticationSSO)o;
        return Objects.equals((Object)this.strategy, (Object)authenticationSSO.strategy) && Objects.equals(this.accessToken, authenticationSSO.accessToken);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.strategy, this.accessToken});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationSSO {\n");
        sb.append("    strategy: ").append(this.toIndentedString((Object)this.strategy)).append("\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StrategyEnum {
        KEYCLOAK("keycloak"),
        MICROSOFT("microsoft"),
        GOOGLE("google"),
        GITHUB("github"),
        OTKA("otka"),
        CUSTOM("custom");

        private String value;

        private StrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StrategyEnum fromValue(String value) {
            for (StrategyEnum b : StrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

