/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"strategy", "email", "password", "workspaceId"})
@JsonTypeName(value="Authentication")
public class Authentication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_STRATEGY = "strategy";
    private StrategyEnum strategy;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;

    public Authentication strategy(StrategyEnum strategy) {
        this.strategy = strategy;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The method of authentication")
    @JsonProperty(value="strategy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public StrategyEnum getStrategy() {
        return this.strategy;
    }

    @JsonProperty(value="strategy")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStrategy(StrategyEnum strategy) {
        this.strategy = strategy;
    }

    public Authentication email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The email associated with the user account")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public Authentication password(String password) {
        this.password = password;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The password of the KDP account")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    public Authentication workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the Workspace")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication authentication = (Authentication)o;
        return Objects.equals((Object)this.strategy, (Object)authentication.strategy) && Objects.equals(this.email, authentication.email) && Objects.equals(this.password, authentication.password) && Objects.equals(this.workspaceId, authentication.workspaceId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.strategy, this.email, this.password, this.workspaceId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Authentication {\n");
        sb.append("    strategy: ").append(this.toIndentedString((Object)this.strategy)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StrategyEnum {
        LOCAL("local"),
        PROXY("proxy");

        private String value;

        private StrategyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StrategyEnum fromValue(String value) {
            for (StrategyEnum b : StrategyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

