/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "type", "userId", "timestampMs", "description", "sourceIP", "datasetId", "actor", "details"})
@JsonTypeName(value="AuditLogEvent")
public class AuditLogEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_USER_ID = "userId";
    private UUID userId;
    public static final String JSON_PROPERTY_TIMESTAMP_MS = "timestampMs";
    private Long timestampMs;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_SOURCE_I_P = "sourceIP";
    private String sourceIP;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;
    public static final String JSON_PROPERTY_ACTOR = "actor";
    private String actor;
    public static final String JSON_PROPERTY_DETAILS = "details";
    private Object details;

    public AuditLogEvent id(UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="event ID")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setId(UUID id) {
        this.id = id;
    }

    public AuditLogEvent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public AuditLogEvent userId(UUID userId) {
        this.userId = userId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="user ID if available")
    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getUserId() {
        return this.userId;
    }

    @JsonProperty(value="userId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserId(UUID userId) {
        this.userId = userId;
    }

    public AuditLogEvent timestampMs(Long timestampMs) {
        this.timestampMs = timestampMs;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="event timestamp - UTC - Required. Number of milliseconds since the Unix epoch (January 1, 1970, 00:00:00 UTC).")
    @JsonProperty(value="timestampMs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getTimestampMs() {
        return this.timestampMs;
    }

    @JsonProperty(value="timestampMs")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTimestampMs(Long timestampMs) {
        this.timestampMs = timestampMs;
    }

    public AuditLogEvent description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="details of the audit log event")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AuditLogEvent sourceIP(String sourceIP) {
        this.sourceIP = sourceIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IP address of the user machine - optional")
    @JsonProperty(value="sourceIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSourceIP() {
        return this.sourceIP;
    }

    @JsonProperty(value="sourceIP")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceIP(String sourceIP) {
        this.sourceIP = sourceIP;
    }

    public AuditLogEvent datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="dataset ID")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public AuditLogEvent actor(String actor) {
        this.actor = actor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The user who requested the action or `KDP Service` if initiated by KDP.")
    @JsonProperty(value="actor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getActor() {
        return this.actor;
    }

    @JsonProperty(value="actor")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActor(String actor) {
        this.actor = actor;
    }

    public AuditLogEvent details(Object details) {
        this.details = details;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="details of the audit log event")
    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getDetails() {
        return this.details;
    }

    @JsonProperty(value="details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetails(Object details) {
        this.details = details;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogEvent auditLogEvent = (AuditLogEvent)o;
        return Objects.equals(this.id, auditLogEvent.id) && Objects.equals((Object)this.type, (Object)auditLogEvent.type) && Objects.equals(this.userId, auditLogEvent.userId) && Objects.equals(this.timestampMs, auditLogEvent.timestampMs) && Objects.equals(this.description, auditLogEvent.description) && Objects.equals(this.sourceIP, auditLogEvent.sourceIP) && Objects.equals(this.datasetId, auditLogEvent.datasetId) && Objects.equals(this.actor, auditLogEvent.actor) && Objects.equals(this.details, auditLogEvent.details);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.userId, this.timestampMs, this.description, this.sourceIP, this.datasetId, this.actor, this.details});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogEvent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    userId: ").append(this.toIndentedString(this.userId)).append("\n");
        sb.append("    timestampMs: ").append(this.toIndentedString(this.timestampMs)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    sourceIP: ").append(this.toIndentedString(this.sourceIP)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    actor: ").append(this.toIndentedString(this.actor)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        LOGIN("Login"),
        USERPROFILEMANAGEMENT("UserProfileManagement"),
        USERMANAGEMENT("UserManagement"),
        AUDITLOGCONFIGMANAGEMENT("AuditLogConfigManagement"),
        WORKSPACEMANAGEMENT("WorkspaceManagement"),
        ATTRIBUTEMANAGEMENT("AttributeManagement"),
        GROUPMANAGEMENT("GroupManagement"),
        DATASETMANAGEMENT("DatasetManagement"),
        BILLINGPLANMANAGEMENT("BillingPlanManagement"),
        DATADOWNLOAD("DataDownload"),
        IDENTITYPROVIDERMANAGEMENT("IdentityProviderManagement"),
        WRITERECORDS("WriteRecords");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

