/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"keepForever", "ageInDays", "workspaceId", "datasetId"})
@JsonTypeName(value="AuditLogConfiguration")
public class AuditLogConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_KEEP_FOREVER = "keepForever";
    private Boolean keepForever;
    public static final String JSON_PROPERTY_AGE_IN_DAYS = "ageInDays";
    private Integer ageInDays;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_DATASET_ID = "datasetId";
    private UUID datasetId;

    public AuditLogConfiguration keepForever(Boolean keepForever) {
        this.keepForever = keepForever;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="flag to never delete the logs")
    @JsonProperty(value="keepForever")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getKeepForever() {
        return this.keepForever;
    }

    @JsonProperty(value="keepForever")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKeepForever(Boolean keepForever) {
        this.keepForever = keepForever;
    }

    public AuditLogConfiguration ageInDays(Integer ageInDays) {
        this.ageInDays = ageInDays;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The age of the logs- Logs older than that would be deleted, if the keepForever flag is false")
    @JsonProperty(value="ageInDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getAgeInDays() {
        return this.ageInDays;
    }

    @JsonProperty(value="ageInDays")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAgeInDays(Integer ageInDays) {
        this.ageInDays = ageInDays;
    }

    public AuditLogConfiguration workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the workspace to which this configuration belongs")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public AuditLogConfiguration datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The id of the dataset in which the audit logs for this workspace is stored")
    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    @JsonProperty(value="datasetId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogConfiguration auditLogConfiguration = (AuditLogConfiguration)o;
        return Objects.equals(this.keepForever, auditLogConfiguration.keepForever) && Objects.equals(this.ageInDays, auditLogConfiguration.ageInDays) && Objects.equals(this.workspaceId, auditLogConfiguration.workspaceId) && Objects.equals(this.datasetId, auditLogConfiguration.datasetId);
    }

    public int hashCode() {
        return Objects.hash(this.keepForever, this.ageInDays, this.workspaceId, this.datasetId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogConfiguration {\n");
        sb.append("    keepForever: ").append(this.toIndentedString(this.keepForever)).append("\n");
        sb.append("    ageInDays: ").append(this.toIndentedString(this.ageInDays)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

