/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.koverse.kdpapi.client.model.ApplicationRequiredDatasetAccess;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"id", "name", "url", "redirectUrl", "workspaceId", "clientId", "clientSecret", "visible", "description", "type", "allowedUsers", "requiredDatasetAccess"})
@JsonTypeName(value="Application")
public class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ID = "id";
    private UUID id;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_REDIRECT_URL = "redirectUrl";
    private String redirectUrl;
    public static final String JSON_PROPERTY_WORKSPACE_ID = "workspaceId";
    private String workspaceId;
    public static final String JSON_PROPERTY_CLIENT_ID = "clientId";
    private String clientId;
    public static final String JSON_PROPERTY_CLIENT_SECRET = "clientSecret";
    private String clientSecret;
    public static final String JSON_PROPERTY_VISIBLE = "visible";
    private Boolean visible;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ALLOWED_USERS = "allowedUsers";
    private List<UUID> allowedUsers = null;
    public static final String JSON_PROPERTY_REQUIRED_DATASET_ACCESS = "requiredDatasetAccess";
    private List<ApplicationRequiredDatasetAccess> requiredDatasetAccess = null;

    public Application id(UUID id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the Application")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(UUID id) {
        this.id = id;
    }

    public Application name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name of the Application")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public Application url(String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(String url) {
        this.url = url;
    }

    public Application redirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="url for redirect")
    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    @JsonProperty(value="redirectUrl")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public Application workspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="ID of the KDP workspace")
    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    @JsonProperty(value="workspaceId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public Application clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID of the client")
    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty(value="clientId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Application clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="secret of the Client")
    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getClientSecret() {
        return this.clientSecret;
    }

    @JsonProperty(value="clientSecret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Application visible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="visible flag")
    @JsonProperty(value="visible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getVisible() {
        return this.visible;
    }

    @JsonProperty(value="visible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public Application description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="application description")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Application type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="type of application")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Application allowedUsers(List<UUID> allowedUsers) {
        this.allowedUsers = allowedUsers;
        return this;
    }

    public Application addAllowedUsersItem(UUID allowedUsersItem) {
        if (this.allowedUsers == null) {
            this.allowedUsers = new ArrayList<UUID>();
        }
        this.allowedUsers.add(allowedUsersItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="array of ID's of allowed users of the application")
    @JsonProperty(value="allowedUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getAllowedUsers() {
        return this.allowedUsers;
    }

    @JsonProperty(value="allowedUsers")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedUsers(List<UUID> allowedUsers) {
        this.allowedUsers = allowedUsers;
    }

    public Application requiredDatasetAccess(List<ApplicationRequiredDatasetAccess> requiredDatasetAccess) {
        this.requiredDatasetAccess = requiredDatasetAccess;
        return this;
    }

    public Application addRequiredDatasetAccessItem(ApplicationRequiredDatasetAccess requiredDatasetAccessItem) {
        if (this.requiredDatasetAccess == null) {
            this.requiredDatasetAccess = new ArrayList<ApplicationRequiredDatasetAccess>();
        }
        this.requiredDatasetAccess.add(requiredDatasetAccessItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="required dataset access")
    @JsonProperty(value="requiredDatasetAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ApplicationRequiredDatasetAccess> getRequiredDatasetAccess() {
        return this.requiredDatasetAccess;
    }

    @JsonProperty(value="requiredDatasetAccess")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequiredDatasetAccess(List<ApplicationRequiredDatasetAccess> requiredDatasetAccess) {
        this.requiredDatasetAccess = requiredDatasetAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application application = (Application)o;
        return Objects.equals(this.id, application.id) && Objects.equals(this.name, application.name) && Objects.equals(this.url, application.url) && Objects.equals(this.redirectUrl, application.redirectUrl) && Objects.equals(this.workspaceId, application.workspaceId) && Objects.equals(this.clientId, application.clientId) && Objects.equals(this.clientSecret, application.clientSecret) && Objects.equals(this.visible, application.visible) && Objects.equals(this.description, application.description) && Objects.equals((Object)this.type, (Object)application.type) && Objects.equals(this.allowedUsers, application.allowedUsers) && Objects.equals(this.requiredDatasetAccess, application.requiredDatasetAccess);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.url, this.redirectUrl, this.workspaceId, this.clientId, this.clientSecret, this.visible, this.description, this.type, this.allowedUsers, this.requiredDatasetAccess});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Application {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    redirectUrl: ").append(this.toIndentedString(this.redirectUrl)).append("\n");
        sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    allowedUsers: ").append(this.toIndentedString(this.allowedUsers)).append("\n");
        sb.append("    requiredDatasetAccess: ").append(this.toIndentedString(this.requiredDatasetAccess)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MLS("mls"),
        SLS("sls");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

