/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.AuditLogConfiguration;
import com.koverse.kdpapi.client.model.AuditLogConfigurationPaginator;
import com.koverse.kdpapi.client.model.AuditLogPaginator;
import com.koverse.kdpapi.client.model.LuceneQueryRequest;
import com.koverse.kdpapi.client.model.Workspace;
import com.koverse.kdpapi.client.model.WorkspaceCreateRequest;
import com.koverse.kdpapi.client.model.WorkspacePaginator;
import com.koverse.kdpapi.client.model.WorkspacePatchRequest;
import com.koverse.kdpapi.client.model.WorkspaceUpdateRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.WorkspacesApi")
public class WorkspacesApi {
    private ApiClient apiClient;

    public WorkspacesApi() {
        this(new ApiClient());
    }

    @Autowired
    public WorkspacesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public AuditLogConfigurationPaginator getAllAuditlogConfigurations(String workspaceId, Boolean keepForever, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (AuditLogConfigurationPaginator)this.getAllAuditlogConfigurationsWithHttpInfo(workspaceId, keepForever, $limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<AuditLogConfigurationPaginator> getAllAuditlogConfigurationsWithHttpInfo(String workspaceId, Boolean keepForever, Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "workspaceId", workspaceId));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "keepForever", keepForever));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AuditLogConfigurationPaginator> returnType = new ParameterizedTypeReference<AuditLogConfigurationPaginator>(){};
        return this.apiClient.invokeAPI("/audit-log-configs/", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public WorkspacePaginator getWorkspaces(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (WorkspacePaginator)this.getWorkspacesWithHttpInfo($limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<WorkspacePaginator> getWorkspacesWithHttpInfo(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<WorkspacePaginator> returnType = new ParameterizedTypeReference<WorkspacePaginator>(){};
        return this.apiClient.invokeAPI("/workspaces", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Workspace getWorkspacesId(String id) throws RestClientException {
        return (Workspace)this.getWorkspacesIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Workspace> getWorkspacesIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getWorkspacesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Workspace> returnType = new ParameterizedTypeReference<Workspace>(){};
        return this.apiClient.invokeAPI("/workspaces/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public AuditLogConfiguration patchAuditlogConfiguration(String auditLogConfigsId, AuditLogConfiguration auditLogConfiguration) throws RestClientException {
        return (AuditLogConfiguration)this.patchAuditlogConfigurationWithHttpInfo(auditLogConfigsId, auditLogConfiguration).getBody();
    }

    public ResponseEntity<AuditLogConfiguration> patchAuditlogConfigurationWithHttpInfo(String auditLogConfigsId, AuditLogConfiguration auditLogConfiguration) throws RestClientException {
        AuditLogConfiguration postBody = auditLogConfiguration;
        if (auditLogConfigsId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'auditLogConfigsId' when calling patchAuditlogConfiguration");
        }
        if (auditLogConfiguration == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'auditLogConfiguration' when calling patchAuditlogConfiguration");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("auditLogConfigsId", auditLogConfigsId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AuditLogConfiguration> returnType = new ParameterizedTypeReference<AuditLogConfiguration>(){};
        return this.apiClient.invokeAPI("/audit-log-configs/{auditLogConfigsId}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Workspace patchWorkspacesId(String id, WorkspacePatchRequest workspacePatchRequest) throws RestClientException {
        return (Workspace)this.patchWorkspacesIdWithHttpInfo(id, workspacePatchRequest).getBody();
    }

    public ResponseEntity<Workspace> patchWorkspacesIdWithHttpInfo(String id, WorkspacePatchRequest workspacePatchRequest) throws RestClientException {
        WorkspacePatchRequest postBody = workspacePatchRequest;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchWorkspacesId");
        }
        if (workspacePatchRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'workspacePatchRequest' when calling patchWorkspacesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Workspace> returnType = new ParameterizedTypeReference<Workspace>(){};
        return this.apiClient.invokeAPI("/workspaces/{id}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public AuditLogPaginator postAuditLogQuery(LuceneQueryRequest luceneQueryRequest, Boolean includeInternalFields) throws RestClientException {
        return (AuditLogPaginator)this.postAuditLogQueryWithHttpInfo(luceneQueryRequest, includeInternalFields).getBody();
    }

    public ResponseEntity<AuditLogPaginator> postAuditLogQueryWithHttpInfo(LuceneQueryRequest luceneQueryRequest, Boolean includeInternalFields) throws RestClientException {
        LuceneQueryRequest postBody = luceneQueryRequest;
        if (luceneQueryRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'luceneQueryRequest' when calling postAuditLogQuery");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "includeInternalFields", includeInternalFields));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<AuditLogPaginator> returnType = new ParameterizedTypeReference<AuditLogPaginator>(){};
        return this.apiClient.invokeAPI("/audit-log/query", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Workspace postWorkspaces(WorkspaceCreateRequest workspaceCreateRequest) throws RestClientException {
        return (Workspace)this.postWorkspacesWithHttpInfo(workspaceCreateRequest).getBody();
    }

    public ResponseEntity<Workspace> postWorkspacesWithHttpInfo(WorkspaceCreateRequest workspaceCreateRequest) throws RestClientException {
        WorkspaceCreateRequest postBody = workspaceCreateRequest;
        if (workspaceCreateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'workspaceCreateRequest' when calling postWorkspaces");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Workspace> returnType = new ParameterizedTypeReference<Workspace>(){};
        return this.apiClient.invokeAPI("/workspaces", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Workspace putWorkspacesId(String id, WorkspaceUpdateRequest workspaceUpdateRequest) throws RestClientException {
        return (Workspace)this.putWorkspacesIdWithHttpInfo(id, workspaceUpdateRequest).getBody();
    }

    public ResponseEntity<Workspace> putWorkspacesIdWithHttpInfo(String id, WorkspaceUpdateRequest workspaceUpdateRequest) throws RestClientException {
        WorkspaceUpdateRequest postBody = workspaceUpdateRequest;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling putWorkspacesId");
        }
        if (workspaceUpdateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'workspaceUpdateRequest' when calling putWorkspacesId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Workspace> returnType = new ParameterizedTypeReference<Workspace>(){};
        return this.apiClient.invokeAPI("/workspaces/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

