/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.DeleteDocumentByQueryRequest;
import com.koverse.kdpapi.client.model.DeleteRecordByIdRequest;
import com.koverse.kdpapi.client.model.DeleteRecordByQueryRequest;
import com.koverse.kdpapi.client.model.Job;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.ManageRecordsApi")
public class ManageRecordsApi {
    private ApiClient apiClient;

    public ManageRecordsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ManageRecordsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Job deleteDatasetDocumentQuery(String datasetId, DeleteDocumentByQueryRequest deleteDocumentByQueryRequest) throws RestClientException {
        return (Job)this.deleteDatasetDocumentQueryWithHttpInfo(datasetId, deleteDocumentByQueryRequest).getBody();
    }

    public ResponseEntity<Job> deleteDatasetDocumentQueryWithHttpInfo(String datasetId, DeleteDocumentByQueryRequest deleteDocumentByQueryRequest) throws RestClientException {
        DeleteDocumentByQueryRequest postBody = deleteDocumentByQueryRequest;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling deleteDatasetDocumentQuery");
        }
        if (deleteDocumentByQueryRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteDocumentByQueryRequest' when calling deleteDatasetDocumentQuery");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/storage/datasets/{datasetId}/deleteDocuments/query", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job deleteDatasetRecordId(UUID datasetId, DeleteRecordByIdRequest deleteRecordByIdRequest) throws RestClientException {
        return (Job)this.deleteDatasetRecordIdWithHttpInfo(datasetId, deleteRecordByIdRequest).getBody();
    }

    public ResponseEntity<Job> deleteDatasetRecordIdWithHttpInfo(UUID datasetId, DeleteRecordByIdRequest deleteRecordByIdRequest) throws RestClientException {
        DeleteRecordByIdRequest postBody = deleteRecordByIdRequest;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling deleteDatasetRecordId");
        }
        if (deleteRecordByIdRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteRecordByIdRequest' when calling deleteDatasetRecordId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/storage/datasets/{datasetId}/deleteRecords", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job deleteDatasetRecordQuery(String datasetId, DeleteRecordByQueryRequest deleteRecordByQueryRequest) throws RestClientException {
        return (Job)this.deleteDatasetRecordQueryWithHttpInfo(datasetId, deleteRecordByQueryRequest).getBody();
    }

    public ResponseEntity<Job> deleteDatasetRecordQueryWithHttpInfo(String datasetId, DeleteRecordByQueryRequest deleteRecordByQueryRequest) throws RestClientException {
        DeleteRecordByQueryRequest postBody = deleteRecordByQueryRequest;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling deleteDatasetRecordQuery");
        }
        if (deleteRecordByQueryRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'deleteRecordByQueryRequest' when calling deleteDatasetRecordQuery");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/storage/datasets/{datasetId}/deleteRecords/query", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Job postClearDataset(String datasetId) throws RestClientException {
        return (Job)this.postClearDatasetWithHttpInfo(datasetId).getBody();
    }

    public ResponseEntity<Job> postClearDatasetWithHttpInfo(String datasetId) throws RestClientException {
        Object postBody = null;
        if (datasetId == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetId' when calling postClearDataset");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("datasetId", datasetId);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Job> returnType = new ParameterizedTypeReference<Job>(){};
        return this.apiClient.invokeAPI("/storage/datasets/{datasetId}/clear", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

