/*
 * Decompiled with CFR 0.152.
 */
package com.koverse.kdpapi.client;

import com.koverse.kdpapi.client.invoker.ApiClient;
import com.koverse.kdpapi.client.model.Application;
import com.koverse.kdpapi.client.model.ApplicationCreateRequest;
import com.koverse.kdpapi.client.model.ApplicationPaginator;
import com.koverse.kdpapi.client.model.ApplicationPatchRequest;
import com.koverse.kdpapi.client.model.ApplicationUpdateRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="com.koverse.kdpapi.client.ApplicationsApi")
public class ApplicationsApi {
    private ApiClient apiClient;

    public ApplicationsApi() {
        this(new ApiClient());
    }

    @Autowired
    public ApplicationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Application deleteApplicationsId(String id) throws RestClientException {
        return (Application)this.deleteApplicationsIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Application> deleteApplicationsIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling deleteApplicationsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Application> returnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/applications/{id}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public ApplicationPaginator getApplications(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        return (ApplicationPaginator)this.getApplicationsWithHttpInfo($limit, $skip, $sort, filter).getBody();
    }

    public ResponseEntity<ApplicationPaginator> getApplicationsWithHttpInfo(Integer $limit, Integer $skip, Object $sort, Object filter) throws RestClientException {
        Object postBody = null;
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$limit", $limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$skip", $skip));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "$sort", $sort));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "filter", filter));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<ApplicationPaginator> returnType = new ParameterizedTypeReference<ApplicationPaginator>(){};
        return this.apiClient.invokeAPI("/applications", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Application getApplicationsId(String id) throws RestClientException {
        return (Application)this.getApplicationsIdWithHttpInfo(id).getBody();
    }

    public ResponseEntity<Application> getApplicationsIdWithHttpInfo(String id) throws RestClientException {
        Object postBody = null;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling getApplicationsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Application> returnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/applications/{id}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Application patchApplicationsId(String id, ApplicationPatchRequest applicationPatchRequest) throws RestClientException {
        return (Application)this.patchApplicationsIdWithHttpInfo(id, applicationPatchRequest).getBody();
    }

    public ResponseEntity<Application> patchApplicationsIdWithHttpInfo(String id, ApplicationPatchRequest applicationPatchRequest) throws RestClientException {
        ApplicationPatchRequest postBody = applicationPatchRequest;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling patchApplicationsId");
        }
        if (applicationPatchRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationPatchRequest' when calling patchApplicationsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Application> returnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/applications/{id}", HttpMethod.PATCH, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Application postApplications(ApplicationCreateRequest applicationCreateRequest) throws RestClientException {
        return (Application)this.postApplicationsWithHttpInfo(applicationCreateRequest).getBody();
    }

    public ResponseEntity<Application> postApplicationsWithHttpInfo(ApplicationCreateRequest applicationCreateRequest) throws RestClientException {
        ApplicationCreateRequest postBody = applicationCreateRequest;
        if (applicationCreateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationCreateRequest' when calling postApplications");
        }
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Application> returnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/applications", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }

    public Application putApplicationsId(String id, ApplicationUpdateRequest applicationUpdateRequest) throws RestClientException {
        return (Application)this.putApplicationsIdWithHttpInfo(id, applicationUpdateRequest).getBody();
    }

    public ResponseEntity<Application> putApplicationsIdWithHttpInfo(String id, ApplicationUpdateRequest applicationUpdateRequest) throws RestClientException {
        ApplicationUpdateRequest postBody = applicationUpdateRequest;
        if (id == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'id' when calling putApplicationsId");
        }
        if (applicationUpdateRequest == null) {
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Missing the required parameter 'applicationUpdateRequest' when calling putApplicationsId");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("id", id);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] contentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"Bearer"};
        ParameterizedTypeReference<Application> returnType = new ParameterizedTypeReference<Application>(){};
        return this.apiClient.invokeAPI("/applications/{id}", HttpMethod.PUT, uriVariables, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, authNames, returnType);
    }
}

