/*
 * Decompiled with CFR 0.152.
 */
package com.ikovac.timepickerwithseconds;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.NumberPicker;
import com.ikovac.timepickerwithseconds.R;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class TimePicker
extends FrameLayout {
    private static final OnTimeChangedListener NO_OP_CHANGE_LISTENER = new OnTimeChangedListener(){

        @Override
        public void onTimeChanged(TimePicker view, int hourOfDay, int minute, int seconds) {
        }
    };
    public static final NumberPicker.Formatter TWO_DIGIT_FORMATTER = new NumberPicker.Formatter(){

        public String format(int value) {
            return String.format("%02d", value);
        }
    };
    private int mCurrentHour = 0;
    private int mCurrentMinute = 0;
    private int mCurrentSeconds = 0;
    private Boolean mIs24HourView = false;
    private boolean mIsAm;
    private final NumberPicker mHourPicker;
    private final NumberPicker mMinutePicker;
    private final NumberPicker mSecondPicker;
    private final Button mAmPmButton;
    private final String mAmText;
    private final String mPmText;
    private OnTimeChangedListener mOnTimeChangedListener;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(R.layout.time_picker_widget, (ViewGroup)this, true);
        this.mHourPicker = (NumberPicker)this.findViewById(R.id.hour);
        this.mHourPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                TimePicker.this.mCurrentHour = newVal;
                if (!TimePicker.this.mIs24HourView.booleanValue()) {
                    if (TimePicker.this.mCurrentHour == 12) {
                        TimePicker.this.mCurrentHour = 0;
                    }
                    if (!TimePicker.this.mIsAm) {
                        TimePicker.this.mCurrentHour = TimePicker.this.mCurrentHour + 12;
                    }
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mMinutePicker = (NumberPicker)this.findViewById(R.id.minute);
        this.mMinutePicker.setMinValue(0);
        this.mMinutePicker.setMaxValue(59);
        this.mMinutePicker.setFormatter(TWO_DIGIT_FORMATTER);
        this.mMinutePicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                TimePicker.this.mCurrentMinute = newVal;
                TimePicker.this.onTimeChanged();
            }
        });
        this.mSecondPicker = (NumberPicker)this.findViewById(R.id.seconds);
        this.mSecondPicker.setMinValue(0);
        this.mSecondPicker.setMaxValue(59);
        this.mSecondPicker.setFormatter(TWO_DIGIT_FORMATTER);
        this.mSecondPicker.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                TimePicker.this.mCurrentSeconds = newVal;
                TimePicker.this.onTimeChanged();
            }
        });
        this.mAmPmButton = (Button)this.findViewById(R.id.amPm);
        this.configurePickerRanges();
        Calendar cal = Calendar.getInstance();
        this.setOnTimeChangedListener(NO_OP_CHANGE_LISTENER);
        this.setCurrentHour(cal.get(11));
        this.setCurrentMinute(cal.get(12));
        this.setCurrentSecond(cal.get(13));
        this.mIsAm = this.mCurrentHour < 12;
        DateFormatSymbols dfs = new DateFormatSymbols();
        String[] dfsAmPm = dfs.getAmPmStrings();
        this.mAmText = dfsAmPm[0];
        this.mPmText = dfsAmPm[1];
        this.mAmPmButton.setText((CharSequence)(this.mIsAm ? this.mAmText : this.mPmText));
        this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TimePicker.this.requestFocus();
                if (TimePicker.this.mIsAm) {
                    if (TimePicker.this.mCurrentHour < 12) {
                        TimePicker.this.mCurrentHour = TimePicker.this.mCurrentHour + 12;
                    }
                } else if (TimePicker.this.mCurrentHour >= 12) {
                    TimePicker.this.mCurrentHour = TimePicker.this.mCurrentHour - 12;
                }
                TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                TimePicker.this.mAmPmButton.setText((CharSequence)(TimePicker.this.mIsAm ? TimePicker.this.mAmText : TimePicker.this.mPmText));
                TimePicker.this.onTimeChanged();
            }
        });
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mMinutePicker.setEnabled(enabled);
        this.mHourPicker.setEnabled(enabled);
        this.mAmPmButton.setEnabled(enabled);
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mCurrentHour, this.mCurrentMinute);
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    public Integer getCurrentHour() {
        return this.mCurrentHour;
    }

    public void setCurrentHour(Integer currentHour) {
        this.mCurrentHour = currentHour;
        this.updateHourDisplay();
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView != is24HourView) {
            this.mIs24HourView = is24HourView;
            this.configurePickerRanges();
            this.updateHourDisplay();
        }
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public Integer getCurrentMinute() {
        return this.mCurrentMinute;
    }

    public void setCurrentMinute(Integer currentMinute) {
        this.mCurrentMinute = currentMinute;
        this.updateMinuteDisplay();
    }

    public Integer getCurrentSeconds() {
        return this.mCurrentSeconds;
    }

    public void setCurrentSecond(Integer currentSecond) {
        this.mCurrentSeconds = currentSecond;
        this.updateSecondsDisplay();
    }

    public int getBaseline() {
        return this.mHourPicker.getBaseline();
    }

    private void updateHourDisplay() {
        int currentHour = this.mCurrentHour;
        if (!this.mIs24HourView.booleanValue()) {
            if (currentHour > 12) {
                currentHour -= 12;
            } else if (currentHour == 0) {
                currentHour = 12;
            }
        }
        this.mHourPicker.setValue(currentHour);
        this.mIsAm = this.mCurrentHour < 12;
        this.mAmPmButton.setText((CharSequence)(this.mIsAm ? this.mAmText : this.mPmText));
        this.onTimeChanged();
    }

    private void configurePickerRanges() {
        if (this.mIs24HourView.booleanValue()) {
            this.mHourPicker.setMinValue(0);
            this.mHourPicker.setMaxValue(23);
            this.mHourPicker.setFormatter(TWO_DIGIT_FORMATTER);
            this.mAmPmButton.setVisibility(8);
        } else {
            this.mHourPicker.setMinValue(1);
            this.mHourPicker.setMaxValue(12);
            this.mHourPicker.setFormatter(null);
            this.mAmPmButton.setVisibility(0);
        }
    }

    private void onTimeChanged() {
        this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute(), this.getCurrentSeconds());
    }

    private void updateMinuteDisplay() {
        this.mMinutePicker.setValue(this.mCurrentMinute);
        this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute(), this.getCurrentSeconds());
    }

    private void updateSecondsDisplay() {
        this.mSecondPicker.setValue(this.mCurrentSeconds);
        this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute(), this.getCurrentSeconds());
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final int mHour;
        private final int mMinute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        private SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        private SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3, int var4);
    }
}

