/*
 * Decompiled with CFR 0.152.
 */
package com.ikovac.timepickerwithseconds;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.view.LayoutInflater;
import android.view.View;
import com.ikovac.timepickerwithseconds.R;
import com.ikovac.timepickerwithseconds.TimePicker;
import java.util.Calendar;

public class MyTimePickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener,
TimePicker.OnTimeChangedListener {
    private static final String HOUR = "hour";
    private static final String MINUTE = "minute";
    private static final String SECONDS = "seconds";
    private static final String IS_24_HOUR = "is24hour";
    private final TimePicker mTimePicker;
    private final OnTimeSetListener mCallback;
    private final Calendar mCalendar;
    private final java.text.DateFormat mDateFormat;
    int mInitialHourOfDay;
    int mInitialMinute;
    int mInitialSeconds;
    boolean mIs24HourView;

    public MyTimePickerDialog(Context context, OnTimeSetListener callBack, int hourOfDay, int minute, int seconds, boolean is24HourView) {
        this(context, 0, callBack, hourOfDay, minute, seconds, is24HourView);
    }

    public MyTimePickerDialog(Context context, int theme, OnTimeSetListener callBack, int hourOfDay, int minute, int seconds, boolean is24HourView) {
        super(context, theme);
        this.requestWindowFeature(1);
        this.mCallback = callBack;
        this.mInitialHourOfDay = hourOfDay;
        this.mInitialMinute = minute;
        this.mInitialSeconds = seconds;
        this.mIs24HourView = is24HourView;
        this.mDateFormat = DateFormat.getTimeFormat((Context)context);
        this.mCalendar = Calendar.getInstance();
        this.updateTitle(this.mInitialHourOfDay, this.mInitialMinute, this.mInitialSeconds);
        this.setButton(context.getText(R.string.time_set), this);
        this.setButton2(context.getText(R.string.cancel), null);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.time_picker_dialog, null);
        this.setView(view);
        this.mTimePicker = (TimePicker)view.findViewById(R.id.timePicker);
        this.mTimePicker.setCurrentHour(this.mInitialHourOfDay);
        this.mTimePicker.setCurrentMinute(this.mInitialMinute);
        this.mTimePicker.setCurrentSecond(this.mInitialSeconds);
        this.mTimePicker.setIs24HourView(this.mIs24HourView);
        this.mTimePicker.setOnTimeChangedListener(this);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallback != null) {
            this.mTimePicker.clearFocus();
            this.mCallback.onTimeSet(this.mTimePicker, this.mTimePicker.getCurrentHour(), this.mTimePicker.getCurrentMinute(), this.mTimePicker.getCurrentSeconds());
        }
    }

    @Override
    public void onTimeChanged(TimePicker view, int hourOfDay, int minute, int seconds) {
        this.updateTitle(hourOfDay, minute, seconds);
    }

    public void updateTime(int hourOfDay, int minutOfHour, int seconds) {
        this.mTimePicker.setCurrentHour(hourOfDay);
        this.mTimePicker.setCurrentMinute(minutOfHour);
        this.mTimePicker.setCurrentSecond(seconds);
    }

    private void updateTitle(int hour, int minute, int seconds) {
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, minute);
        this.mCalendar.set(13, seconds);
        this.setTitle(this.mDateFormat.format(this.mCalendar.getTime()) + ":" + String.format("%02d", seconds));
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(HOUR, this.mTimePicker.getCurrentHour().intValue());
        state.putInt(MINUTE, this.mTimePicker.getCurrentMinute().intValue());
        state.putInt(SECONDS, this.mTimePicker.getCurrentSeconds().intValue());
        state.putBoolean(IS_24_HOUR, this.mTimePicker.is24HourView());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int hour = savedInstanceState.getInt(HOUR);
        int minute = savedInstanceState.getInt(MINUTE);
        int seconds = savedInstanceState.getInt(SECONDS);
        this.mTimePicker.setCurrentHour(hour);
        this.mTimePicker.setCurrentMinute(minute);
        this.mTimePicker.setCurrentSecond(seconds);
        this.mTimePicker.setIs24HourView(savedInstanceState.getBoolean(IS_24_HOUR));
        this.mTimePicker.setOnTimeChangedListener(this);
        this.updateTitle(hour, minute, seconds);
    }

    public static interface OnTimeSetListener {
        public void onTimeSet(TimePicker var1, int var2, int var3, int var4);
    }
}

