/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.text.TextUtils;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.filter.ChunkedOutputFilter;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerRequestImpl;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.MalformedRangeException;
import com.koushikdutta.async.http.server.StreamSkipException;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.util.StreamUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class AsyncHttpServerResponseImpl
implements AsyncHttpServerResponse {
    private Headers mRawHeaders = new Headers();
    private long mContentLength = -1L;
    AsyncSocket mSocket;
    AsyncHttpServerRequestImpl mRequest;
    boolean headWritten = false;
    DataSink mSink;
    WritableCallback writable;
    boolean ended;
    boolean mEnded;
    int code = 200;
    String httpVersion = "HTTP/1.1";
    CompletedCallback closedCallback;

    @Override
    public Headers getHeaders() {
        return this.mRawHeaders;
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public void setSocket(AsyncSocket socket) {
        this.mSocket = socket;
    }

    AsyncHttpServerResponseImpl(AsyncSocket socket, AsyncHttpServerRequestImpl req) {
        this.mSocket = socket;
        this.mRequest = req;
        if (HttpUtil.isKeepAlive(Protocol.HTTP_1_1, req.getHeaders())) {
            this.mRawHeaders.set("Connection", "Keep-Alive");
        }
    }

    @Override
    public AsyncHttpServerRequest getRequest() {
        return this.mRequest;
    }

    @Override
    public void write(ByteBufferList bb) {
        if (!this.headWritten) {
            this.initFirstWrite();
        }
        if (bb.remaining() == 0) {
            return;
        }
        if (this.mSink == null) {
            return;
        }
        this.mSink.write(bb);
    }

    void initFirstWrite() {
        boolean isChunked;
        String contentLength;
        boolean canUseChunked;
        if (this.headWritten) {
            return;
        }
        this.headWritten = true;
        String currentEncoding = this.mRawHeaders.get("Transfer-Encoding");
        if ("".equals(currentEncoding)) {
            this.mRawHeaders.removeAll("Transfer-Encoding");
        }
        boolean bl = canUseChunked = ("Chunked".equalsIgnoreCase(currentEncoding) || currentEncoding == null) && !"close".equalsIgnoreCase(this.mRawHeaders.get("Connection"));
        if (this.mContentLength < 0L && !TextUtils.isEmpty((CharSequence)(contentLength = this.mRawHeaders.get("Content-Length")))) {
            this.mContentLength = Long.valueOf(contentLength);
        }
        if (this.mContentLength < 0L && canUseChunked) {
            this.mRawHeaders.set("Transfer-Encoding", "Chunked");
            isChunked = true;
        } else {
            isChunked = false;
        }
        String statusLine = String.format(Locale.ENGLISH, "%s %s %s", this.httpVersion, this.code, AsyncHttpServer.getResponseCodeDescription(this.code));
        String rh = this.mRawHeaders.toPrefixString(statusLine);
        Util.writeAll((DataSink)this.mSocket, rh.getBytes(), ex -> {
            if (ex != null) {
                this.report(ex);
                return;
            }
            if (isChunked) {
                ChunkedOutputFilter chunked = new ChunkedOutputFilter(this.mSocket);
                chunked.setMaxBuffer(0);
                this.mSink = chunked;
            } else {
                this.mSink = this.mSocket;
            }
            this.mSink.setClosedCallback(this.closedCallback);
            this.closedCallback = null;
            this.mSink.setWriteableCallback(this.writable);
            this.writable = null;
            if (this.ended) {
                this.end();
                return;
            }
            this.getServer().post(() -> {
                WritableCallback wb = this.getWriteableCallback();
                if (wb != null) {
                    wb.onWriteable();
                }
            });
        });
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        if (this.mSink != null) {
            this.mSink.setWriteableCallback(handler);
        } else {
            this.writable = handler;
        }
    }

    @Override
    public WritableCallback getWriteableCallback() {
        if (this.mSink != null) {
            return this.mSink.getWriteableCallback();
        }
        return this.writable;
    }

    @Override
    public void end() {
        if (this.ended) {
            return;
        }
        this.ended = true;
        if (this.headWritten && this.mSink == null) {
            return;
        }
        if (!this.headWritten) {
            this.mRawHeaders.remove("Transfer-Encoding");
        }
        if (this.mSink instanceof ChunkedOutputFilter) {
            this.mSink.end();
        } else if (!this.headWritten) {
            if (!this.mRequest.getMethod().equalsIgnoreCase("HEAD")) {
                this.send("text/html", "");
            } else {
                this.writeHead();
                this.onEnd();
            }
        } else {
            this.onEnd();
        }
    }

    @Override
    public void writeHead() {
        this.initFirstWrite();
    }

    @Override
    public void setContentType(String contentType) {
        this.mRawHeaders.set("Content-Type", contentType);
    }

    @Override
    public void send(String contentType, byte[] bytes) {
        this.send(contentType, new ByteBufferList(bytes));
    }

    @Override
    public <T> void sendBody(AsyncParser<T> body, T value) {
        this.mRawHeaders.set("Content-Type", body.getMime());
        body.write(this, value, ex -> this.end());
    }

    @Override
    public void send(String contentType, ByteBuffer bb) {
        this.send(contentType, new ByteBufferList(bb));
    }

    @Override
    public void send(String contentType, ByteBufferList bb) {
        this.getServer().post(() -> {
            this.mContentLength = bb.remaining();
            this.mRawHeaders.set("Content-Length", Long.toString(this.mContentLength));
            if (contentType != null) {
                this.mRawHeaders.set("Content-Type", contentType);
            }
            Util.writeAll((DataSink)this, bb, ex -> this.onEnd());
        });
    }

    @Override
    public void send(String contentType, String string) {
        try {
            this.send(contentType, string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void onEnd() {
        this.mEnded = true;
    }

    protected void report(Exception e) {
    }

    @Override
    public void send(String string) {
        String contentType = this.mRawHeaders.get("Content-Type");
        if (contentType == null) {
            contentType = "text/html; charset=utf-8";
        }
        this.send(contentType, string);
    }

    @Override
    public void send(JSONObject json) {
        this.send("application/json; charset=utf-8", json.toString());
    }

    @Override
    public void send(JSONArray jsonArray) {
        this.send("application/json; charset=utf-8", jsonArray.toString());
    }

    @Override
    public void sendStream(InputStream inputStream, long totalLength) {
        long start = 0L;
        long end = totalLength - 1L;
        String range = this.mRequest.getHeaders().get("Range");
        if (range != null) {
            String[] parts = range.split("=");
            if (parts.length != 2 || !"bytes".equals(parts[0])) {
                this.code(416);
                this.end();
                return;
            }
            parts = parts[1].split("-");
            try {
                if (parts.length > 2) {
                    throw new MalformedRangeException();
                }
                if (!TextUtils.isEmpty((CharSequence)parts[0])) {
                    start = Long.parseLong(parts[0]);
                }
                end = parts.length == 2 && !TextUtils.isEmpty((CharSequence)parts[1]) ? Long.parseLong(parts[1]) : totalLength - 1L;
                this.code(206);
                this.getHeaders().set("Content-Range", String.format(Locale.ENGLISH, "bytes %d-%d/%d", start, end, totalLength));
            }
            catch (Exception e) {
                this.code(416);
                this.end();
                return;
            }
        }
        try {
            if (start != inputStream.skip(start)) {
                throw new StreamSkipException("skip failed to skip requested amount");
            }
            this.mContentLength = end - start + 1L;
            this.mRawHeaders.set("Content-Length", String.valueOf(this.mContentLength));
            this.mRawHeaders.set("Accept-Ranges", "bytes");
            if (this.mRequest.getMethod().equals("HEAD")) {
                this.writeHead();
                this.onEnd();
                return;
            }
            if (this.mContentLength == 0L) {
                this.writeHead();
                StreamUtility.closeQuietly(inputStream);
                this.onEnd();
                return;
            }
            this.getServer().post(() -> Util.pump(inputStream, this.mContentLength, this, ex -> {
                StreamUtility.closeQuietly(inputStream);
                this.onEnd();
            }));
        }
        catch (Exception e) {
            this.code(500);
            this.end();
        }
    }

    @Override
    public void sendFile(File file) {
        try {
            if (this.mRawHeaders.get("Content-Type") == null) {
                this.mRawHeaders.set("Content-Type", AsyncHttpServer.getContentType(file.getAbsolutePath()));
            }
            FileInputStream fin = new FileInputStream(file);
            this.sendStream(new BufferedInputStream(fin, 64000), file.length());
        }
        catch (FileNotFoundException e) {
            this.code(404);
            this.end();
        }
    }

    @Override
    public void proxy(AsyncHttpResponse remoteResponse) {
        this.code(remoteResponse.code());
        remoteResponse.headers().removeAll("Transfer-Encoding");
        remoteResponse.headers().removeAll("Content-Encoding");
        remoteResponse.headers().removeAll("Connection");
        this.getHeaders().addAll(remoteResponse.headers());
        remoteResponse.headers().set("Connection", "close");
        Util.pump(remoteResponse, (DataSink)this, ex -> {
            remoteResponse.setEndCallback(new CompletedCallback.NullCompletedCallback());
            remoteResponse.setDataCallback(new DataCallback.NullDataCallback());
            this.end();
        });
    }

    @Override
    public AsyncHttpServerResponse code(int code) {
        this.code = code;
        return this;
    }

    @Override
    public int code() {
        return this.code;
    }

    @Override
    public void redirect(String location) {
        this.code(302);
        this.mRawHeaders.set("Location", location);
        this.end();
    }

    @Override
    public String getHttpVersion() {
        return this.httpVersion;
    }

    @Override
    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    @Override
    public void onCompleted(Exception ex) {
        this.end();
    }

    @Override
    public boolean isOpen() {
        if (this.mSink != null) {
            return this.mSink.isOpen();
        }
        return this.mSocket.isOpen();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        if (this.mSink != null) {
            this.mSink.setClosedCallback(handler);
        } else {
            this.closedCallback = handler;
        }
    }

    @Override
    public CompletedCallback getClosedCallback() {
        if (this.mSink != null) {
            return this.mSink.getClosedCallback();
        }
        return this.closedCallback;
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }

    public String toString() {
        if (this.mRawHeaders == null) {
            return super.toString();
        }
        String statusLine = String.format(Locale.ENGLISH, "%s %s %s", this.httpVersion, this.code, AsyncHttpServer.getResponseCodeDescription(this.code));
        return this.mRawHeaders.toPrefixString(statusLine);
    }
}

