/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.parser;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.parser.ByteBufferListParser;
import java.lang.reflect.Type;
import java.nio.charset.Charset;

public class StringParser
implements AsyncParser<String> {
    Charset forcedCharset;

    public StringParser() {
    }

    public StringParser(Charset charset) {
        this.forcedCharset = charset;
    }

    @Override
    public Future<String> parse(DataEmitter emitter) {
        String charset = emitter.charset();
        return new ByteBufferListParser().parse(emitter).thenConvert(from -> {
            Charset charsetToUse = this.forcedCharset;
            if (charsetToUse == null && charset != null) {
                charsetToUse = Charset.forName(charset);
            }
            return from.readString(charsetToUse);
        });
    }

    @Override
    public void write(DataSink sink, String value, CompletedCallback completed) {
        new ByteBufferListParser().write(sink, new ByteBufferList(value.getBytes()), completed);
    }

    @Override
    public Type getType() {
        return String.class;
    }

    @Override
    public String getMime() {
        return null;
    }
}

