/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.cache;

import android.net.Uri;
import android.util.Base64;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.SimpleMiddleware;
import com.koushikdutta.async.http.cache.RawHeaders;
import com.koushikdutta.async.http.cache.RequestHeaders;
import com.koushikdutta.async.http.cache.ResponseHeaders;
import com.koushikdutta.async.http.cache.ResponseSource;
import com.koushikdutta.async.http.cache.StrictLineReader;
import com.koushikdutta.async.util.Allocator;
import com.koushikdutta.async.util.Charsets;
import com.koushikdutta.async.util.FileCache;
import com.koushikdutta.async.util.StreamUtility;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.CacheResponse;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLEngine;

public class ResponseCacheMiddleware
extends SimpleMiddleware {
    public static final int ENTRY_METADATA = 0;
    public static final int ENTRY_BODY = 1;
    public static final int ENTRY_COUNT = 2;
    public static final String SERVED_FROM = "X-Served-From";
    public static final String CONDITIONAL_CACHE = "conditional-cache";
    public static final String CACHE = "cache";
    private static final String LOGTAG = "AsyncHttpCache";
    private boolean caching = true;
    private int writeSuccessCount;
    private int writeAbortCount;
    private FileCache cache;
    private AsyncServer server;
    private int conditionalCacheHitCount;
    private int cacheHitCount;
    private int networkCount;
    private int cacheStoreCount;

    private ResponseCacheMiddleware() {
    }

    public static ResponseCacheMiddleware addCache(AsyncHttpClient client, File cacheDir, long size) throws IOException {
        for (AsyncHttpClientMiddleware middleware : client.getMiddleware()) {
            if (!(middleware instanceof ResponseCacheMiddleware)) continue;
            throw new IOException("Response cache already added to http client");
        }
        ResponseCacheMiddleware ret = new ResponseCacheMiddleware();
        ret.server = client.getServer();
        ret.cache = new FileCache(cacheDir, size, false);
        client.insertMiddleware(ret);
        return ret;
    }

    public FileCache getFileCache() {
        return this.cache;
    }

    public boolean getCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public void removeFromCache(Uri uri) {
        String key = FileCache.toKeyString(uri);
        this.getFileCache().remove(key);
    }

    @Override
    public Cancellable getSocket(final AsyncHttpClientMiddleware.GetSocketData data) {
        FileInputStream cachedResponseBody;
        Map<String, List<String>> responseHeadersMap;
        Entry entry;
        long contentLength;
        RequestHeaders requestHeaders = new RequestHeaders(data.request.getUri(), RawHeaders.fromMultimap(data.request.getHeaders().getMultiMap()));
        data.state.put("request-headers", requestHeaders);
        if (this.cache == null || !this.caching || requestHeaders.isNoCache()) {
            ++this.networkCount;
            return null;
        }
        String key = FileCache.toKeyString(data.request.getUri());
        Closeable[] snapshot = null;
        try {
            snapshot = this.cache.get(key, 2);
            if (snapshot == null) {
                ++this.networkCount;
                return null;
            }
            contentLength = ((FileInputStream)snapshot[1]).available();
            entry = new Entry((InputStream)snapshot[0]);
        }
        catch (IOException e) {
            ++this.networkCount;
            StreamUtility.closeQuietly(snapshot);
            return null;
        }
        if (!entry.matches(data.request.getUri(), data.request.getMethod(), data.request.getHeaders().getMultiMap())) {
            ++this.networkCount;
            StreamUtility.closeQuietly(snapshot);
            return null;
        }
        EntryCacheResponse candidate = new EntryCacheResponse(entry, (FileInputStream)snapshot[1]);
        try {
            responseHeadersMap = candidate.getHeaders();
            cachedResponseBody = candidate.getBody();
        }
        catch (Exception e) {
            ++this.networkCount;
            StreamUtility.closeQuietly(snapshot);
            return null;
        }
        if (responseHeadersMap == null || cachedResponseBody == null) {
            ++this.networkCount;
            StreamUtility.closeQuietly(snapshot);
            return null;
        }
        RawHeaders rawResponseHeaders = RawHeaders.fromMultimap(responseHeadersMap);
        ResponseHeaders cachedResponseHeaders = new ResponseHeaders(data.request.getUri(), rawResponseHeaders);
        rawResponseHeaders.set("Content-Length", String.valueOf(contentLength));
        rawResponseHeaders.removeAll("Content-Encoding");
        rawResponseHeaders.removeAll("Transfer-Encoding");
        cachedResponseHeaders.setLocalTimestamps(System.currentTimeMillis(), System.currentTimeMillis());
        long now = System.currentTimeMillis();
        ResponseSource responseSource = cachedResponseHeaders.chooseResponseSource(now, requestHeaders);
        if (responseSource == ResponseSource.CACHE) {
            data.request.logi("Response retrieved from cache");
            final CachedSocket socket = entry.isHttps() ? new CachedSSLSocket(candidate, contentLength) : new CachedSocket(candidate, contentLength);
            socket.pending.add(ByteBuffer.wrap(rawResponseHeaders.toHeaderString().getBytes()));
            this.server.post(new Runnable(){

                @Override
                public void run() {
                    data.connectCallback.onConnectCompleted(null, socket);
                    socket.sendCachedDataOnNetworkThread();
                }
            });
            ++this.cacheHitCount;
            data.state.put("socket-owner", this);
            SimpleCancellable ret = new SimpleCancellable();
            ret.setComplete();
            return ret;
        }
        if (responseSource == ResponseSource.CONDITIONAL_CACHE) {
            data.request.logi("Response may be served from conditional cache");
            CacheData cacheData = new CacheData();
            cacheData.snapshot = snapshot;
            cacheData.contentLength = contentLength;
            cacheData.cachedResponseHeaders = cachedResponseHeaders;
            cacheData.candidate = candidate;
            data.state.put("cache-data", cacheData);
            return null;
        }
        data.request.logd("Response can not be served from cache");
        ++this.networkCount;
        StreamUtility.closeQuietly(snapshot);
        return null;
    }

    public int getConditionalCacheHitCount() {
        return this.conditionalCacheHitCount;
    }

    public int getCacheHitCount() {
        return this.cacheHitCount;
    }

    public int getNetworkCount() {
        return this.networkCount;
    }

    public int getCacheStoreCount() {
        return this.cacheStoreCount;
    }

    @Override
    public void onBodyDecoder(AsyncHttpClientMiddleware.OnBodyDecoderData data) {
        CachedSocket cached = Util.getWrappedSocket(data.socket, CachedSocket.class);
        if (cached != null) {
            data.response.headers().set(SERVED_FROM, CACHE);
            return;
        }
        CacheData cacheData = (CacheData)data.state.get("cache-data");
        RawHeaders rh = RawHeaders.fromMultimap(data.response.headers().getMultiMap());
        rh.removeAll("Content-Length");
        rh.setStatusLine(String.format(Locale.ENGLISH, "%s %s %s", data.response.protocol(), data.response.code(), data.response.message()));
        ResponseHeaders networkResponse = new ResponseHeaders(data.request.getUri(), rh);
        data.state.put("response-headers", networkResponse);
        if (cacheData != null) {
            if (cacheData.cachedResponseHeaders.validate(networkResponse)) {
                data.request.logi("Serving response from conditional cache");
                ResponseHeaders combined = cacheData.cachedResponseHeaders.combine(networkResponse);
                data.response.headers(new Headers(combined.getHeaders().toMultimap()));
                data.response.code(combined.getHeaders().getResponseCode());
                data.response.message(combined.getHeaders().getResponseMessage());
                data.response.headers().set(SERVED_FROM, CONDITIONAL_CACHE);
                ++this.conditionalCacheHitCount;
                CachedBodyEmitter bodySpewer = new CachedBodyEmitter(cacheData.candidate, cacheData.contentLength);
                bodySpewer.setDataEmitter(data.bodyEmitter);
                data.bodyEmitter = bodySpewer;
                bodySpewer.sendCachedData();
                return;
            }
            data.state.remove("cache-data");
            StreamUtility.closeQuietly(cacheData.snapshot);
        }
        if (!this.caching) {
            return;
        }
        RequestHeaders requestHeaders = (RequestHeaders)data.state.get("request-headers");
        if (requestHeaders == null || !networkResponse.isCacheable(requestHeaders) || !data.request.getMethod().equals("GET")) {
            ++this.networkCount;
            data.request.logd("Response is not cacheable");
            return;
        }
        String key = FileCache.toKeyString(data.request.getUri());
        RawHeaders varyHeaders = requestHeaders.getHeaders().getAll(networkResponse.getVaryFields());
        Entry entry = new Entry(data.request.getUri(), varyHeaders, data.request, networkResponse.getHeaders());
        BodyCacher cacher = new BodyCacher();
        EntryEditor editor = new EntryEditor(key);
        try {
            entry.writeTo(editor);
            editor.newOutputStream(1);
        }
        catch (Exception e) {
            editor.abort();
            ++this.networkCount;
            return;
        }
        cacher.editor = editor;
        cacher.setDataEmitter(data.bodyEmitter);
        data.bodyEmitter = cacher;
        data.state.put("body-cacher", cacher);
        data.request.logd("Caching response");
        ++this.cacheStoreCount;
    }

    @Override
    public void onResponseComplete(AsyncHttpClientMiddleware.OnResponseCompleteData data) {
        BodyCacher cacher;
        CachedSocket cachedSocket;
        CacheData cacheData = (CacheData)data.state.get("cache-data");
        if (cacheData != null && cacheData.snapshot != null) {
            StreamUtility.closeQuietly(cacheData.snapshot);
        }
        if ((cachedSocket = Util.getWrappedSocket(data.socket, CachedSocket.class)) != null) {
            StreamUtility.closeQuietly(cachedSocket.cacheResponse.getBody());
        }
        if ((cacher = (BodyCacher)data.state.get("body-cacher")) != null) {
            if (data.exception != null) {
                cacher.abort();
            } else {
                cacher.commit();
            }
        }
    }

    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    class EntryEditor {
        String key;
        File[] temps;
        FileOutputStream[] outs;
        boolean done;

        public EntryEditor(String key) {
            this.key = key;
            this.temps = ResponseCacheMiddleware.this.cache.getTempFiles(2);
            this.outs = new FileOutputStream[2];
        }

        void commit() {
            StreamUtility.closeQuietly(this.outs);
            if (this.done) {
                return;
            }
            ResponseCacheMiddleware.this.cache.commitTempFiles(this.key, this.temps);
            ResponseCacheMiddleware.this.writeSuccessCount++;
            this.done = true;
        }

        FileOutputStream newOutputStream(int index) throws IOException {
            if (this.outs[index] == null) {
                this.outs[index] = new FileOutputStream(this.temps[index]);
            }
            return this.outs[index];
        }

        void abort() {
            StreamUtility.closeQuietly(this.outs);
            FileCache.removeFiles(this.temps);
            if (this.done) {
                return;
            }
            ResponseCacheMiddleware.this.writeAbortCount++;
            this.done = true;
        }
    }

    private class CachedSocket
    extends CachedBodyEmitter
    implements AsyncSocket {
        boolean closed;
        boolean open;
        CompletedCallback closedCallback;

        public CachedSocket(EntryCacheResponse cacheResponse, long contentLength) {
            super(cacheResponse, contentLength);
            this.allowEnd = true;
        }

        @Override
        public void end() {
        }

        @Override
        protected void report(Exception e) {
            super.report(e);
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.closedCallback != null) {
                this.closedCallback.onCompleted(e);
            }
        }

        @Override
        public void write(ByteBufferList bb) {
            bb.recycle();
        }

        @Override
        public WritableCallback getWriteableCallback() {
            return null;
        }

        @Override
        public void setWriteableCallback(WritableCallback handler) {
        }

        @Override
        public boolean isOpen() {
            return this.open;
        }

        @Override
        public void close() {
            this.open = false;
        }

        @Override
        public CompletedCallback getClosedCallback() {
            return this.closedCallback;
        }

        @Override
        public void setClosedCallback(CompletedCallback handler) {
            this.closedCallback = handler;
        }

        @Override
        public AsyncServer getServer() {
            return ResponseCacheMiddleware.this.server;
        }
    }

    private class CachedSSLSocket
    extends CachedSocket
    implements AsyncSSLSocket {
        public CachedSSLSocket(EntryCacheResponse cacheResponse, long contentLength) {
            super(cacheResponse, contentLength);
        }

        @Override
        public SSLEngine getSSLEngine() {
            return null;
        }

        @Override
        public X509Certificate[] getPeerCertificates() {
            return null;
        }
    }

    static class EntryCacheResponse
    extends CacheResponse {
        private final Entry entry;
        private final FileInputStream snapshot;

        public EntryCacheResponse(Entry entry, FileInputStream snapshot) {
            this.entry = entry;
            this.snapshot = snapshot;
        }

        @Override
        public Map<String, List<String>> getHeaders() {
            return this.entry.responseHeaders.toMultimap();
        }

        @Override
        public FileInputStream getBody() {
            return this.snapshot;
        }
    }

    private static final class Entry {
        private final String uri;
        private final RawHeaders varyHeaders;
        private final String requestMethod;
        private final RawHeaders responseHeaders;
        private final String cipherSuite;
        private final Certificate[] peerCertificates;
        private final Certificate[] localCertificates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Entry(InputStream in) throws IOException {
            StrictLineReader reader = null;
            try {
                reader = new StrictLineReader(in, Charsets.US_ASCII);
                this.uri = reader.readLine();
                this.requestMethod = reader.readLine();
                this.varyHeaders = new RawHeaders();
                int varyRequestHeaderLineCount = reader.readInt();
                for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                    this.varyHeaders.addLine(reader.readLine());
                }
                this.responseHeaders = new RawHeaders();
                this.responseHeaders.setStatusLine(reader.readLine());
                int responseHeaderLineCount = reader.readInt();
                for (int i = 0; i < responseHeaderLineCount; ++i) {
                    this.responseHeaders.addLine(reader.readLine());
                }
                this.cipherSuite = null;
                this.peerCertificates = null;
                this.localCertificates = null;
            }
            catch (Throwable throwable) {
                StreamUtility.closeQuietly(reader, in);
                throw throwable;
            }
            StreamUtility.closeQuietly(reader, in);
        }

        public Entry(Uri uri, RawHeaders varyHeaders, AsyncHttpRequest request, RawHeaders responseHeaders) {
            this.uri = uri.toString();
            this.varyHeaders = varyHeaders;
            this.requestMethod = request.getMethod();
            this.responseHeaders = responseHeaders;
            this.cipherSuite = null;
            this.peerCertificates = null;
            this.localCertificates = null;
        }

        public void writeTo(EntryEditor editor) throws IOException {
            int i;
            FileOutputStream out = editor.newOutputStream(0);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, Charsets.UTF_8));
            writer.write(this.uri + '\n');
            writer.write(this.requestMethod + '\n');
            writer.write(Integer.toString(this.varyHeaders.length()) + '\n');
            for (i = 0; i < this.varyHeaders.length(); ++i) {
                writer.write(this.varyHeaders.getFieldName(i) + ": " + this.varyHeaders.getValue(i) + '\n');
            }
            writer.write(this.responseHeaders.getStatusLine() + '\n');
            writer.write(Integer.toString(this.responseHeaders.length()) + '\n');
            for (i = 0; i < this.responseHeaders.length(); ++i) {
                writer.write(this.responseHeaders.getFieldName(i) + ": " + this.responseHeaders.getValue(i) + '\n');
            }
            if (this.isHttps()) {
                ((Writer)writer).write(10);
                writer.write(this.cipherSuite + '\n');
                this.writeCertArray(writer, this.peerCertificates);
                this.writeCertArray(writer, this.localCertificates);
            }
            ((Writer)writer).close();
        }

        private boolean isHttps() {
            return this.uri.startsWith("https://");
        }

        private Certificate[] readCertArray(StrictLineReader reader) throws IOException {
            int length = reader.readInt();
            if (length == -1) {
                return null;
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Certificate[] result = new Certificate[length];
                for (int i = 0; i < result.length; ++i) {
                    String line = reader.readLine();
                    byte[] bytes = Base64.decode((String)line, (int)0);
                    result[i] = certificateFactory.generateCertificate(new ByteArrayInputStream(bytes));
                }
                return result;
            }
            catch (CertificateException e) {
                throw new IOException(e.getMessage());
            }
        }

        private void writeCertArray(Writer writer, Certificate[] certificates) throws IOException {
            if (certificates == null) {
                writer.write("-1\n");
                return;
            }
            try {
                writer.write(Integer.toString(certificates.length) + '\n');
                for (Certificate certificate : certificates) {
                    byte[] bytes = certificate.getEncoded();
                    String line = Base64.encodeToString((byte[])bytes, (int)0);
                    writer.write(line + '\n');
                }
            }
            catch (CertificateEncodingException e) {
                throw new IOException(e.getMessage());
            }
        }

        public boolean matches(Uri uri, String requestMethod, Map<String, List<String>> requestHeaders) {
            return this.uri.equals(uri.toString()) && this.requestMethod.equals(requestMethod) && new ResponseHeaders(uri, this.responseHeaders).varyMatches(this.varyHeaders.toMultimap(), requestHeaders);
        }
    }

    private static class CachedBodyEmitter
    extends FilteredDataEmitter {
        EntryCacheResponse cacheResponse;
        ByteBufferList pending = new ByteBufferList();
        private boolean paused;
        private Allocator allocator = new Allocator();
        boolean allowEnd;
        Runnable sendCachedDataRunnable = new Runnable(){

            @Override
            public void run() {
                this.sendCachedDataOnNetworkThread();
            }
        };

        public CachedBodyEmitter(EntryCacheResponse cacheResponse, long contentLength) {
            this.cacheResponse = cacheResponse;
            this.allocator.setCurrentAlloc((int)contentLength);
        }

        void sendCachedDataOnNetworkThread() {
            if (this.pending.remaining() > 0) {
                super.onDataAvailable(this, this.pending);
                if (this.pending.remaining() > 0) {
                    return;
                }
            }
            try {
                ByteBuffer buffer = this.allocator.allocate();
                assert (buffer.position() == 0);
                FileInputStream din = this.cacheResponse.getBody();
                int read = din.read(buffer.array(), buffer.arrayOffset(), buffer.capacity());
                if (read == -1) {
                    ByteBufferList.reclaim(buffer);
                    this.allowEnd = true;
                    this.report(null);
                    return;
                }
                this.allocator.track(read);
                buffer.limit(read);
                this.pending.add(buffer);
            }
            catch (IOException e) {
                this.allowEnd = true;
                this.report(e);
                return;
            }
            super.onDataAvailable(this, this.pending);
            if (this.pending.remaining() > 0) {
                return;
            }
            this.getServer().postDelayed(this.sendCachedDataRunnable, 10L);
        }

        void sendCachedData() {
            this.getServer().post(this.sendCachedDataRunnable);
        }

        @Override
        public void resume() {
            this.paused = false;
            this.sendCachedData();
        }

        @Override
        public boolean isPaused() {
            return this.paused;
        }

        @Override
        public void close() {
            if (this.getServer().getAffinity() != Thread.currentThread()) {
                this.getServer().post(new Runnable(){

                    @Override
                    public void run() {
                        this.close();
                    }
                });
                return;
            }
            this.pending.recycle();
            StreamUtility.closeQuietly(this.cacheResponse.getBody());
            super.close();
        }

        @Override
        protected void report(Exception e) {
            if (!this.allowEnd) {
                return;
            }
            StreamUtility.closeQuietly(this.cacheResponse.getBody());
            super.report(e);
        }
    }

    private static class BodyCacher
    extends FilteredDataEmitter {
        EntryEditor editor;
        ByteBufferList cached;

        private BodyCacher() {
        }

        @Override
        protected void report(Exception e) {
            super.report(e);
            if (e != null) {
                this.abort();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
            if (this.cached != null) {
                super.onDataAvailable(emitter, this.cached);
                if (this.cached.remaining() > 0) {
                    return;
                }
                this.cached = null;
            }
            ByteBufferList copy = new ByteBufferList();
            try {
                if (this.editor != null) {
                    FileOutputStream outputStream = this.editor.newOutputStream(1);
                    if (outputStream != null) {
                        while (!bb.isEmpty()) {
                            ByteBuffer b = bb.remove();
                            try {
                                ByteBufferList.writeOutputStream(outputStream, b);
                            }
                            finally {
                                copy.add(b);
                            }
                        }
                    } else {
                        this.abort();
                    }
                }
            }
            catch (Exception e) {
                this.abort();
            }
            finally {
                bb.get(copy);
                copy.get(bb);
            }
            super.onDataAvailable(emitter, bb);
            if (this.editor != null && bb.remaining() > 0) {
                this.cached = new ByteBufferList();
                bb.get(this.cached);
            }
        }

        @Override
        public void close() {
            this.abort();
            super.close();
        }

        public void abort() {
            if (this.editor != null) {
                this.editor.abort();
                this.editor = null;
            }
        }

        public void commit() {
            if (this.editor != null) {
                this.editor.commit();
                this.editor = null;
            }
        }
    }

    public static class CacheData {
        FileInputStream[] snapshot;
        EntryCacheResponse candidate;
        long contentLength;
        ResponseHeaders cachedResponseHeaders;
    }
}

