/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.Futures;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.SimpleMiddleware;
import com.koushikdutta.async.util.ArrayDeque;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Locale;

public class AsyncSocketMiddleware
extends SimpleMiddleware {
    String scheme;
    int port;
    int idleTimeoutMs = 300000;
    protected AsyncHttpClient mClient;
    boolean connectAllAddresses;
    String proxyHost;
    int proxyPort;
    InetSocketAddress proxyAddress;
    Hashtable<String, ConnectionInfo> connectionInfo = new Hashtable();
    int maxConnectionCount = Integer.MAX_VALUE;

    public AsyncSocketMiddleware(AsyncHttpClient client, String scheme, int port) {
        this.mClient = client;
        this.scheme = scheme;
        this.port = port;
    }

    public void setIdleTimeoutMs(int idleTimeoutMs) {
        this.idleTimeoutMs = idleTimeoutMs;
    }

    public int getSchemePort(Uri uri) {
        if (uri.getScheme() == null || !uri.getScheme().equals(this.scheme)) {
            return -1;
        }
        if (uri.getPort() == -1) {
            return this.port;
        }
        return uri.getPort();
    }

    public AsyncSocketMiddleware(AsyncHttpClient client) {
        this(client, "http", 80);
    }

    protected ConnectCallback wrapCallback(AsyncHttpClientMiddleware.GetSocketData data, Uri uri, int port, boolean proxied, ConnectCallback callback) {
        return callback;
    }

    public boolean getConnectAllAddresses() {
        return this.connectAllAddresses;
    }

    public void setConnectAllAddresses(boolean connectAllAddresses) {
        this.connectAllAddresses = connectAllAddresses;
    }

    public void disableProxy() {
        this.proxyPort = -1;
        this.proxyHost = null;
        this.proxyAddress = null;
    }

    public void enableProxy(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyAddress = null;
    }

    String computeLookup(Uri uri, int port, String proxyHost, int proxyPort) {
        String proxy = proxyHost != null ? proxyHost + ":" + proxyPort : "";
        if (proxyHost != null) {
            proxy = proxyHost + ":" + proxyPort;
        }
        return uri.getScheme() + "//" + uri.getHost() + ":" + port + "?proxy=" + proxy;
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public void setMaxConnectionCount(int maxConnectionCount) {
        this.maxConnectionCount = maxConnectionCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cancellable getSocket(AsyncHttpClientMiddleware.GetSocketData data) {
        Uri uri = data.request.getUri();
        int port = this.getSchemePort(data.request.getUri());
        if (port == -1) {
            return null;
        }
        data.state.put("socket-owner", this);
        String lookup = this.computeLookup(uri, port, data.request.getProxyHost(), data.request.getProxyPort());
        ConnectionInfo info = this.getOrCreateConnectionInfo(lookup);
        AsyncSocketMiddleware asyncSocketMiddleware = this;
        synchronized (asyncSocketMiddleware) {
            if (info.openCount >= this.maxConnectionCount) {
                SimpleCancellable queueCancel = new SimpleCancellable();
                info.queue.add(data);
                return queueCancel;
            }
            ++info.openCount;
            while (!info.sockets.isEmpty()) {
                IdleSocketHolder idleSocketHolder = info.sockets.pop();
                AsyncSocket socket = idleSocketHolder.socket;
                if (idleSocketHolder.idleTime + (long)this.idleTimeoutMs < System.currentTimeMillis()) {
                    socket.setClosedCallback(null);
                    socket.close();
                    continue;
                }
                if (!socket.isOpen()) continue;
                data.request.logd("Reusing keep-alive socket");
                data.connectCallback.onConnectCompleted(null, socket);
                SimpleCancellable ret = new SimpleCancellable();
                ret.setComplete();
                return ret;
            }
        }
        if (!this.connectAllAddresses || this.proxyHost != null || data.request.getProxyHost() != null) {
            int unresolvedPort;
            String unresolvedHost;
            data.request.logd("Connecting socket");
            boolean proxied = false;
            if (data.request.getProxyHost() == null && this.proxyHost != null) {
                data.request.enableProxy(this.proxyHost, this.proxyPort);
            }
            if (data.request.getProxyHost() != null) {
                unresolvedHost = data.request.getProxyHost();
                unresolvedPort = data.request.getProxyPort();
                proxied = true;
            } else {
                unresolvedHost = uri.getHost();
                unresolvedPort = port;
            }
            if (proxied) {
                data.request.logv("Using proxy: " + unresolvedHost + ":" + unresolvedPort);
            }
            return this.mClient.getServer().connectSocket(unresolvedHost, unresolvedPort, this.wrapCallback(data, uri, port, proxied, data.connectCallback));
        }
        data.request.logv("Resolving domain and connecting to all available addresses");
        SimpleFuture checkedReturnValue = new SimpleFuture();
        Future socket = this.mClient.getServer().getAllByName(uri.getHost()).then(addresses -> Futures.loopUntil(addresses, address -> {
            SimpleFuture loopResult = new SimpleFuture();
            String inetSockAddress = String.format(Locale.ENGLISH, "%s:%s", address, port);
            data.request.logv("attempting connection to " + inetSockAddress);
            this.mClient.getServer().connectSocket(new InetSocketAddress((InetAddress)address, port), loopResult::setComplete);
            return loopResult;
        })).fail(e -> this.wrapCallback(data, uri, port, false, data.connectCallback).onConnectCompleted(e, null));
        checkedReturnValue.setComplete(socket).setCallback((e, successfulSocket) -> {
            if (successfulSocket == null) {
                return;
            }
            if (e == null) {
                this.wrapCallback(data, uri, port, false, data.connectCallback).onConnectCompleted(null, (AsyncSocket)successfulSocket);
                return;
            }
            data.request.logd("Recycling extra socket leftover from cancelled operation");
            this.idleSocket((AsyncSocket)successfulSocket);
            this.recycleSocket((AsyncSocket)successfulSocket, data.request);
        });
        return checkedReturnValue;
    }

    private ConnectionInfo getOrCreateConnectionInfo(String lookup) {
        ConnectionInfo info = this.connectionInfo.get(lookup);
        if (info == null) {
            info = new ConnectionInfo();
            this.connectionInfo.put(lookup, info);
        }
        return info;
    }

    private void maybeCleanupConnectionInfo(String lookup) {
        ConnectionInfo info = this.connectionInfo.get(lookup);
        if (info == null) {
            return;
        }
        while (!info.sockets.isEmpty()) {
            IdleSocketHolder idleSocketHolder = info.sockets.peekLast();
            AsyncSocket socket = idleSocketHolder.socket;
            if (idleSocketHolder.idleTime + (long)this.idleTimeoutMs > System.currentTimeMillis()) break;
            info.sockets.pop();
            socket.setClosedCallback(null);
            socket.close();
        }
        if (info.openCount == 0 && info.queue.isEmpty() && info.sockets.isEmpty()) {
            this.connectionInfo.remove(lookup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recycleSocket(AsyncSocket socket, AsyncHttpRequest request) {
        ArrayDeque<IdleSocketHolder> sockets;
        if (socket == null) {
            return;
        }
        Uri uri = request.getUri();
        int port = this.getSchemePort(uri);
        final String lookup = this.computeLookup(uri, port, request.getProxyHost(), request.getProxyPort());
        final IdleSocketHolder idleSocketHolder = new IdleSocketHolder(socket);
        AsyncSocketMiddleware asyncSocketMiddleware = this;
        synchronized (asyncSocketMiddleware) {
            ConnectionInfo info = this.getOrCreateConnectionInfo(lookup);
            sockets = info.sockets;
            sockets.push(idleSocketHolder);
        }
        socket.setClosedCallback(new CompletedCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCompleted(Exception ex) {
                AsyncSocketMiddleware asyncSocketMiddleware = AsyncSocketMiddleware.this;
                synchronized (asyncSocketMiddleware) {
                    sockets.remove(idleSocketHolder);
                    AsyncSocketMiddleware.this.maybeCleanupConnectionInfo(lookup);
                }
            }
        });
    }

    private void idleSocket(final AsyncSocket socket) {
        socket.setEndCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                socket.setClosedCallback(null);
                socket.close();
            }
        });
        socket.setWriteableCallback(null);
        socket.setDataCallback(new DataCallback.NullDataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                super.onDataAvailable(emitter, bb);
                bb.recycle();
                socket.setClosedCallback(null);
                socket.close();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextConnection(AsyncHttpRequest request) {
        Uri uri = request.getUri();
        int port = this.getSchemePort(uri);
        String key = this.computeLookup(uri, port, request.getProxyHost(), request.getProxyPort());
        AsyncSocketMiddleware asyncSocketMiddleware = this;
        synchronized (asyncSocketMiddleware) {
            ConnectionInfo info = this.connectionInfo.get(key);
            if (info == null) {
                return;
            }
            --info.openCount;
            while (info.openCount < this.maxConnectionCount && info.queue.size() > 0) {
                AsyncHttpClientMiddleware.GetSocketData gsd = info.queue.remove();
                SimpleCancellable socketCancellable = (SimpleCancellable)gsd.socketCancellable;
                if (socketCancellable.isCancelled()) continue;
                Cancellable connect = this.getSocket(gsd);
                socketCancellable.setParent(connect);
            }
            this.maybeCleanupConnectionInfo(key);
        }
    }

    protected boolean isKeepAlive(AsyncHttpClientMiddleware.OnResponseCompleteData data) {
        return HttpUtil.isKeepAlive(data.response.protocol(), data.response.headers()) && HttpUtil.isKeepAlive(Protocol.HTTP_1_1, data.request.getHeaders());
    }

    @Override
    public void onResponseComplete(AsyncHttpClientMiddleware.OnResponseCompleteData data) {
        if (data.state.get("socket-owner") != this) {
            return;
        }
        try {
            this.idleSocket(data.socket);
            if (data.exception != null || !data.socket.isOpen()) {
                data.request.logv("closing out socket (exception)");
                data.socket.setClosedCallback(null);
                data.socket.close();
                return;
            }
            if (!this.isKeepAlive(data)) {
                data.request.logv("closing out socket (not keep alive)");
                data.socket.setClosedCallback(null);
                data.socket.close();
                return;
            }
            data.request.logd("Recycling keep-alive socket");
            this.recycleSocket(data.socket, data.request);
        }
        finally {
            this.nextConnection(data.request);
        }
    }

    static class ConnectionInfo {
        int openCount;
        ArrayDeque<AsyncHttpClientMiddleware.GetSocketData> queue = new ArrayDeque();
        ArrayDeque<IdleSocketHolder> sockets = new ArrayDeque();

        ConnectionInfo() {
        }
    }

    class IdleSocketHolder {
        AsyncSocket socket;
        long idleTime = System.currentTimeMillis();

        public IdleSocketHolder(AsyncSocket socket) {
            this.socket = socket;
        }
    }
}

