/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import com.koushikdutta.async.AsyncSemaphore;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.DependentFuture;
import com.koushikdutta.async.future.DoneCallback;
import com.koushikdutta.async.future.FailCallback;
import com.koushikdutta.async.future.FailConvertCallback;
import com.koushikdutta.async.future.FailRecoverCallback;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.future.SuccessCallback;
import com.koushikdutta.async.future.ThenCallback;
import com.koushikdutta.async.future.ThenFutureCallback;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class SimpleFuture<T>
extends SimpleCancellable
implements DependentFuture<T> {
    private AsyncSemaphore waiter;
    private Exception exception;
    private T result;
    private boolean silent;
    private FutureCallbackInternal<T> internalCallback;

    public SimpleFuture() {
    }

    public SimpleFuture(T value) {
        this.setComplete(value);
    }

    public SimpleFuture(Exception e) {
        this.setComplete(e);
    }

    public SimpleFuture(Future<T> future) {
        this.setComplete(future);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cancelInternal(boolean silent) {
        FutureCallbackInternal<T> internalCallback;
        if (!super.cancel()) {
            return false;
        }
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            this.exception = new CancellationException();
            this.releaseWaiterLocked();
            internalCallback = this.handleInternalCompleteLocked();
            this.silent = silent;
        }
        this.handleCallbackUnlocked(null, internalCallback);
        return true;
    }

    public boolean cancelSilently() {
        return this.cancelInternal(true);
    }

    @Override
    public boolean cancel() {
        return this.cancelInternal(this.silent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws InterruptedException, ExecutionException {
        AsyncSemaphore waiter;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (this.isCancelled() || this.isDone()) {
                return this.getResultOrThrow();
            }
            waiter = this.ensureWaiterLocked();
        }
        waiter.acquire();
        return this.getResultOrThrow();
    }

    private T getResultOrThrow() throws ExecutionException {
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        AsyncSemaphore waiter;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (this.isCancelled() || this.isDone()) {
                return this.getResultOrThrow();
            }
            waiter = this.ensureWaiterLocked();
        }
        if (!waiter.tryAcquire(timeout, unit)) {
            throw new TimeoutException();
        }
        return this.getResultOrThrow();
    }

    @Override
    public boolean setComplete() {
        return this.setComplete((T)null);
    }

    private FutureCallbackInternal<T> handleInternalCompleteLocked() {
        FutureCallbackInternal<T> callback = this.internalCallback;
        this.internalCallback = null;
        return callback;
    }

    private void handleCallbackUnlocked(FutureCallsite callsite, FutureCallbackInternal<T> internalCallback) {
        if (this.silent) {
            return;
        }
        if (internalCallback == null) {
            return;
        }
        boolean needsLoop = false;
        if (callsite == null) {
            needsLoop = true;
            callsite = new FutureCallsite();
        }
        callsite.callback = internalCallback;
        callsite.e = this.exception;
        callsite.result = this.result;
        if (needsLoop) {
            callsite.loop();
        }
    }

    void releaseWaiterLocked() {
        if (this.waiter != null) {
            this.waiter.release();
            this.waiter = null;
        }
    }

    AsyncSemaphore ensureWaiterLocked() {
        if (this.waiter == null) {
            this.waiter = new AsyncSemaphore();
        }
        return this.waiter;
    }

    public boolean setComplete(Exception e) {
        return this.setComplete(e, null, null);
    }

    public boolean setComplete(T value) {
        return this.setComplete(null, value, null);
    }

    public boolean setComplete(Exception e, T value) {
        return this.setComplete(e, value, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setComplete(Exception e, T value, FutureCallsite callsite) {
        FutureCallbackInternal<T> internalCallback;
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            if (!super.setComplete()) {
                return false;
            }
            this.result = value;
            this.exception = e;
            this.releaseWaiterLocked();
            internalCallback = this.handleInternalCompleteLocked();
        }
        this.handleCallbackUnlocked(callsite, internalCallback);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCallbackInternal(FutureCallsite callsite, FutureCallbackInternal<T> internalCallback) {
        SimpleFuture simpleFuture = this;
        synchronized (simpleFuture) {
            this.internalCallback = internalCallback;
            if (!this.isDone() && !this.isCancelled()) {
                return;
            }
            internalCallback = this.handleInternalCompleteLocked();
        }
        this.handleCallbackUnlocked(callsite, internalCallback);
    }

    @Override
    public void setCallback(FutureCallback<T> callback) {
        if (callback == null) {
            this.setCallbackInternal(null, null);
        } else {
            this.setCallbackInternal(null, (e, result, next) -> callback.onCompleted(e, result));
        }
    }

    private Future<T> setComplete(Future<T> future, FutureCallsite callsite) {
        this.setParent(future);
        SimpleFuture<T> ret = new SimpleFuture<T>();
        if (future instanceof SimpleFuture) {
            ((SimpleFuture)future).setCallbackInternal(callsite, (e, result, next) -> ret.setComplete(this.setComplete(e, result, next) ? null : new CancellationException(), result, next));
        } else {
            future.setCallback((e, result) -> ret.setComplete(this.setComplete(e, result, null) ? null : new CancellationException()));
        }
        return ret;
    }

    public Future<T> setComplete(Future<T> future) {
        return this.setComplete(future, null);
    }

    @Deprecated
    public Object getCallback() {
        return this.internalCallback;
    }

    @Override
    public Future<T> done(DoneCallback<T> done) {
        SimpleFuture ret = new SimpleFuture();
        ret.setParent(this);
        this.setCallbackInternal(null, (e, result, next) -> {
            if (e == null) {
                try {
                    done.done(e, result);
                }
                catch (Exception callbackException) {
                    e = callbackException;
                }
            }
            ret.setComplete(e, result, next);
        });
        return ret;
    }

    @Override
    public Future<T> success(SuccessCallback<T> callback) {
        SimpleFuture ret = new SimpleFuture();
        ret.setParent(this);
        this.setCallbackInternal(null, (e, result, next) -> {
            if (e == null) {
                try {
                    callback.success(result);
                }
                catch (Exception callbackException) {
                    e = callbackException;
                }
            }
            ret.setComplete(e, result, next);
        });
        return ret;
    }

    @Override
    public <R> Future<R> then(ThenFutureCallback<R, T> then) {
        SimpleFuture ret = new SimpleFuture();
        ret.setParent(this);
        this.setCallbackInternal(null, (e, result, next) -> {
            Future out;
            if (e != null) {
                ret.setComplete(e, null, next);
                return;
            }
            try {
                out = then.then(result);
            }
            catch (Exception callbackException) {
                ret.setComplete(callbackException, null, next);
                return;
            }
            ret.setComplete(out, next);
        });
        return ret;
    }

    @Override
    public <R> Future<R> thenConvert(ThenCallback<R, T> callback) {
        return this.then(from -> new SimpleFuture(callback.then(from)));
    }

    @Override
    public Future<T> fail(FailCallback fail) {
        return this.failRecover(e -> {
            fail.fail(e);
            return new SimpleFuture<Object>(null);
        });
    }

    @Override
    public Future<T> failRecover(FailRecoverCallback<T> fail) {
        SimpleFuture ret = new SimpleFuture();
        ret.setParent(this);
        this.setCallbackInternal(null, (e, result, next) -> {
            Future out;
            if (e == null) {
                ret.setComplete(e, result, next);
                return;
            }
            try {
                out = fail.fail(e);
            }
            catch (Exception callbackException) {
                ret.setComplete(callbackException, null, next);
                return;
            }
            ret.setComplete(out, next);
        });
        return ret;
    }

    @Override
    public Future<T> failConvert(FailConvertCallback<T> fail) {
        return this.failRecover(e -> new SimpleFuture(fail.fail(e)));
    }

    @Override
    public boolean setParent(Cancellable parent) {
        return super.setParent(parent);
    }

    @Override
    public SimpleFuture<T> reset() {
        super.reset();
        this.result = null;
        this.exception = null;
        this.waiter = null;
        this.internalCallback = null;
        this.silent = false;
        return this;
    }

    @Override
    public Exception tryGetException() {
        return this.exception;
    }

    @Override
    public T tryGet() {
        return this.result;
    }

    static class FutureCallsite {
        Exception e;
        Object result;
        FutureCallbackInternal callback;

        FutureCallsite() {
        }

        void loop() {
            while (this.callback != null) {
                FutureCallbackInternal callback = this.callback;
                Exception e = this.e;
                Object result = this.result;
                this.callback = null;
                this.e = null;
                this.result = null;
                callback.onCompleted(e, result, this);
            }
        }
    }

    protected static interface FutureCallbackInternal<T> {
        public void onCompleted(Exception var1, T var2, FutureCallsite var3);
    }
}

