/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.future;

import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ContinuationCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.DependentCancellable;
import com.koushikdutta.async.future.DependentFuture;
import com.koushikdutta.async.future.SimpleCancellable;
import java.util.LinkedList;

public class Continuation
extends SimpleCancellable
implements ContinuationCallback,
Runnable,
Cancellable {
    CompletedCallback callback;
    Runnable cancelCallback;
    LinkedList<ContinuationCallback> mCallbacks = new LinkedList();
    private boolean inNext;
    private boolean waiting;
    boolean started;

    public CompletedCallback getCallback() {
        return this.callback;
    }

    public void setCallback(CompletedCallback callback) {
        this.callback = callback;
    }

    public Runnable getCancelCallback() {
        return this.cancelCallback;
    }

    public void setCancelCallback(Runnable cancelCallback) {
        this.cancelCallback = cancelCallback;
    }

    public void setCancelCallback(final Cancellable cancel) {
        if (cancel == null) {
            this.cancelCallback = null;
            return;
        }
        this.cancelCallback = new Runnable(){

            @Override
            public void run() {
                cancel.cancel();
            }
        };
    }

    public Continuation() {
        this(null);
    }

    public Continuation(CompletedCallback callback) {
        this(callback, null);
    }

    public Continuation(CompletedCallback callback, Runnable cancelCallback) {
        this.cancelCallback = cancelCallback;
        this.callback = callback;
    }

    private CompletedCallback wrap() {
        return new CompletedCallback(){
            boolean mThisCompleted;

            @Override
            public void onCompleted(Exception ex) {
                if (this.mThisCompleted) {
                    return;
                }
                this.mThisCompleted = true;
                assert (Continuation.this.waiting);
                Continuation.this.waiting = false;
                if (ex == null) {
                    Continuation.this.next();
                    return;
                }
                Continuation.this.reportCompleted(ex);
            }
        };
    }

    void reportCompleted(Exception ex) {
        if (!this.setComplete()) {
            return;
        }
        if (this.callback != null) {
            this.callback.onCompleted(ex);
        }
    }

    private ContinuationCallback hook(ContinuationCallback callback) {
        if (callback instanceof DependentCancellable) {
            DependentCancellable child = (DependentCancellable)((Object)callback);
            child.setParent(this);
        }
        return callback;
    }

    public Continuation add(ContinuationCallback callback) {
        this.mCallbacks.add(this.hook(callback));
        return this;
    }

    public Continuation insert(ContinuationCallback callback) {
        this.mCallbacks.add(0, this.hook(callback));
        return this;
    }

    public Continuation add(final DependentFuture future) {
        future.setParent(this);
        this.add(new ContinuationCallback(){

            @Override
            public void onContinue(Continuation continuation, CompletedCallback next) throws Exception {
                future.get();
                next.onCompleted(null);
            }
        });
        return this;
    }

    private void next() {
        if (this.inNext) {
            return;
        }
        while (!(this.mCallbacks.size() <= 0 || this.waiting || this.isDone() || this.isCancelled())) {
            ContinuationCallback cb = this.mCallbacks.remove();
            try {
                this.inNext = true;
                this.waiting = true;
                cb.onContinue(this, this.wrap());
            }
            catch (Exception e) {
                this.reportCompleted(e);
            }
            finally {
                this.inNext = false;
            }
        }
        if (this.waiting) {
            return;
        }
        if (this.isDone()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        this.reportCompleted(null);
    }

    @Override
    public boolean cancel() {
        if (!super.cancel()) {
            return false;
        }
        if (this.cancelCallback != null) {
            this.cancelCallback.run();
        }
        return true;
    }

    public Continuation start() {
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        this.started = true;
        this.next();
        return this;
    }

    @Override
    public void onContinue(Continuation continuation, CompletedCallback next) throws Exception {
        this.setCallback(next);
        this.start();
    }

    @Override
    public void run() {
        this.start();
    }
}

