/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.util.Allocator;
import com.koushikdutta.async.util.StreamUtility;
import com.koushikdutta.async.wrapper.AsyncSocketWrapper;
import com.koushikdutta.async.wrapper.DataEmitterWrapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Util {
    public static boolean SUPRESS_DEBUG_EXCEPTIONS = false;

    public static void emitAllData(DataEmitter emitter, ByteBufferList list) {
        int remaining;
        DataCallback handler = null;
        while (!emitter.isPaused() && (handler = emitter.getDataCallback()) != null && (remaining = list.remaining()) > 0) {
            handler.onDataAvailable(emitter, list);
            if (remaining != list.remaining() || handler != emitter.getDataCallback() || emitter.isPaused()) continue;
            System.out.println("handler: " + handler);
            list.recycle();
            if (SUPRESS_DEBUG_EXCEPTIONS) {
                return;
            }
            assert (false);
            throw new RuntimeException("mDataHandler failed to consume data, yet remains the mDataHandler.");
        }
        if (list.remaining() != 0 && !emitter.isPaused()) {
            System.out.println("handler: " + handler);
            System.out.println("emitter: " + emitter);
            list.recycle();
            if (SUPRESS_DEBUG_EXCEPTIONS) {
                return;
            }
            assert (false);
            throw new RuntimeException("Not all data was consumed by Util.emitAllData");
        }
    }

    public static void pump(InputStream is, DataSink ds, CompletedCallback callback) {
        Util.pump(is, Integer.MAX_VALUE, ds, callback);
    }

    public static void pump(final InputStream is, final long max, final DataSink ds, final CompletedCallback callback) {
        final CompletedCallback wrapper = new CompletedCallback(){
            boolean reported;

            @Override
            public void onCompleted(Exception ex) {
                if (this.reported) {
                    return;
                }
                this.reported = true;
                callback.onCompleted(ex);
            }
        };
        WritableCallback cb = new WritableCallback(){
            int totalRead = 0;
            ByteBufferList pending = new ByteBufferList();
            Allocator allocator = new Allocator();

            private void cleanup() {
                ds.setClosedCallback(null);
                ds.setWriteableCallback(null);
                this.pending.recycle();
                StreamUtility.closeQuietly(is);
            }

            @Override
            public void onWriteable() {
                try {
                    do {
                        if (!this.pending.hasRemaining()) {
                            ByteBuffer b = this.allocator.allocate();
                            long toRead = Math.min(max - (long)this.totalRead, (long)b.capacity());
                            int read = is.read(b.array(), 0, (int)toRead);
                            if (read == -1 || (long)this.totalRead == max) {
                                this.cleanup();
                                wrapper.onCompleted(null);
                                return;
                            }
                            this.allocator.track(read);
                            this.totalRead += read;
                            b.position(0);
                            b.limit(read);
                            this.pending.add(b);
                        }
                        ds.write(this.pending);
                    } while (!this.pending.hasRemaining());
                }
                catch (Exception e) {
                    this.cleanup();
                    wrapper.onCompleted(e);
                }
            }
        };
        ds.setWriteableCallback(cb);
        ds.setClosedCallback(wrapper);
        cb.onWriteable();
    }

    public static void pump(final DataEmitter emitter, final DataSink sink, final CompletedCallback callback) {
        DataCallback dataCallback = new DataCallback(){

            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                sink.write(bb);
                if (bb.remaining() > 0) {
                    emitter.pause();
                }
            }
        };
        emitter.setDataCallback(dataCallback);
        sink.setWriteableCallback(new WritableCallback(){

            @Override
            public void onWriteable() {
                emitter.resume();
            }
        });
        final CompletedCallback wrapper = new CompletedCallback(){
            boolean reported;

            @Override
            public void onCompleted(Exception ex) {
                if (this.reported) {
                    return;
                }
                this.reported = true;
                emitter.setDataCallback(null);
                emitter.setEndCallback(null);
                sink.setClosedCallback(null);
                sink.setWriteableCallback(null);
                callback.onCompleted(ex);
            }
        };
        emitter.setEndCallback(wrapper);
        sink.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                if (ex == null) {
                    ex = new IOException("sink was closed before emitter ended");
                }
                wrapper.onCompleted(ex);
            }
        });
    }

    public static void stream(AsyncSocket s1, AsyncSocket s2, CompletedCallback callback) {
        Util.pump(s1, (DataSink)s2, callback);
        Util.pump(s2, (DataSink)s1, callback);
    }

    public static void pump(File file, DataSink ds, final CompletedCallback callback) {
        try {
            if (file == null || ds == null) {
                callback.onCompleted(null);
                return;
            }
            final FileInputStream is = new FileInputStream(file);
            Util.pump(is, ds, new CompletedCallback(){

                @Override
                public void onCompleted(Exception ex) {
                    try {
                        is.close();
                        callback.onCompleted(ex);
                    }
                    catch (IOException e) {
                        callback.onCompleted(e);
                    }
                }
            });
        }
        catch (Exception e) {
            callback.onCompleted(e);
        }
    }

    public static void writeAll(final DataSink sink, final ByteBufferList bb, final CompletedCallback callback) {
        WritableCallback wc = new WritableCallback(){

            @Override
            public void onWriteable() {
                sink.write(bb);
                if (bb.remaining() == 0 && callback != null) {
                    sink.setWriteableCallback(null);
                    callback.onCompleted(null);
                }
            }
        };
        sink.setWriteableCallback(wc);
        wc.onWriteable();
    }

    public static void writeAll(DataSink sink, byte[] bytes, CompletedCallback callback) {
        ByteBuffer bb = ByteBufferList.obtain(bytes.length);
        bb.put(bytes);
        bb.flip();
        ByteBufferList bbl = new ByteBufferList();
        bbl.add(bb);
        Util.writeAll(sink, bbl, callback);
    }

    public static <T extends AsyncSocket> T getWrappedSocket(AsyncSocket socket, Class<T> wrappedClass) {
        if (wrappedClass.isInstance(socket)) {
            return (T)socket;
        }
        while (socket instanceof AsyncSocketWrapper) {
            if (!wrappedClass.isInstance(socket = ((AsyncSocketWrapper)socket).getSocket())) continue;
            return (T)socket;
        }
        return null;
    }

    public static DataEmitter getWrappedDataEmitter(DataEmitter emitter, Class wrappedClass) {
        if (wrappedClass.isInstance(emitter)) {
            return emitter;
        }
        while (emitter instanceof DataEmitterWrapper) {
            if (!wrappedClass.isInstance(emitter = ((AsyncSocketWrapper)emitter).getSocket())) continue;
            return emitter;
        }
        return null;
    }

    public static void end(DataEmitter emitter, Exception e) {
        if (emitter == null) {
            return;
        }
        Util.end(emitter.getEndCallback(), e);
    }

    public static void end(CompletedCallback end, Exception e) {
        if (end != null) {
            end.onCompleted(e);
        }
    }

    public static void writable(DataSink emitter) {
        if (emitter == null) {
            return;
        }
        Util.writable(emitter.getWriteableCallback());
    }

    public static void writable(WritableCallback writable) {
        if (writable != null) {
            writable.onWriteable();
        }
    }
}

