/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.net.Uri;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncHttpResponse;
import com.koushikdutta.async.http.callback.HttpConnectCallback;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.HttpServerRequestCallback;

public class AsyncProxyServer
extends AsyncHttpServer {
    AsyncHttpClient proxyClient;

    public AsyncProxyServer(AsyncServer server) {
        this.proxyClient = new AsyncHttpClient(server);
    }

    @Override
    protected void onRequest(HttpServerRequestCallback callback, AsyncHttpServerRequest request, final AsyncHttpServerResponse response) {
        super.onRequest(callback, request, response);
        if (callback != null) {
            return;
        }
        try {
            Uri uri;
            try {
                uri = Uri.parse((String)request.getPath());
                if (uri.getScheme() == null) {
                    throw new Exception("no host or full uri provided");
                }
            }
            catch (Exception e) {
                String[] splits;
                String host = request.getHeaders().get("Host");
                int port = 80;
                if (host != null && (splits = host.split(":", 2)).length == 2) {
                    host = splits[0];
                    port = Integer.parseInt(splits[1]);
                }
                uri = Uri.parse((String)("http://" + host + ":" + port + request.getPath()));
            }
            this.proxyClient.execute(new AsyncHttpRequest(uri, request.getMethod(), request.getHeaders()), new HttpConnectCallback(){

                @Override
                public void onConnectCompleted(Exception ex, AsyncHttpResponse remoteResponse) {
                    if (ex != null) {
                        response.code(500);
                        response.send(ex.getMessage());
                        return;
                    }
                    response.proxy(remoteResponse);
                }
            });
        }
        catch (Exception e) {
            response.code(500);
            response.send(e.getMessage());
        }
    }

    @Override
    protected boolean onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        return true;
    }
}

