/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.socketio;

import android.net.Uri;
import android.text.TextUtils;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.DependentCancellable;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleFuture;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.socketio.Acknowledge;
import com.koushikdutta.async.http.socketio.ConnectCallback;
import com.koushikdutta.async.http.socketio.DisconnectCallback;
import com.koushikdutta.async.http.socketio.ErrorCallback;
import com.koushikdutta.async.http.socketio.ExceptionCallback;
import com.koushikdutta.async.http.socketio.JSONCallback;
import com.koushikdutta.async.http.socketio.ReconnectCallback;
import com.koushikdutta.async.http.socketio.SocketIOClient;
import com.koushikdutta.async.http.socketio.SocketIOException;
import com.koushikdutta.async.http.socketio.SocketIORequest;
import com.koushikdutta.async.http.socketio.StringCallback;
import com.koushikdutta.async.http.socketio.transport.SocketIOTransport;
import com.koushikdutta.async.http.socketio.transport.WebSocketTransport;
import com.koushikdutta.async.http.socketio.transport.XHRPollingTransport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import org.json.JSONArray;
import org.json.JSONObject;

class SocketIOConnection {
    AsyncHttpClient httpClient;
    int heartbeat;
    long reconnectDelay;
    ArrayList<SocketIOClient> clients = new ArrayList();
    SocketIOTransport transport;
    SocketIORequest request;
    Hashtable<String, Acknowledge> acknowledges = new Hashtable();
    int ackCount;
    Cancellable connecting;

    public SocketIOConnection(AsyncHttpClient httpClient, SocketIORequest request) {
        this.httpClient = httpClient;
        this.request = request;
        this.reconnectDelay = this.request.config.reconnectDelay;
    }

    public boolean isConnected() {
        return this.transport != null && this.transport.isConnected();
    }

    public void emitRaw(int type, SocketIOClient client, String message, Acknowledge acknowledge) {
        String ack = "";
        if (acknowledge != null) {
            String id = "" + this.ackCount++;
            ack = id + "+";
            this.acknowledges.put(id, acknowledge);
        }
        this.transport.send(String.format("%d:%s:%s:%s", type, ack, client.endpoint, message));
    }

    public void connect(SocketIOClient client) {
        if (!this.clients.contains(client)) {
            this.clients.add(client);
        }
        this.transport.send(String.format("1::%s", client.endpoint));
    }

    public void disconnect(SocketIOClient client) {
        this.clients.remove(client);
        boolean needsEndpointDisconnect = true;
        for (SocketIOClient other : this.clients) {
            if (!TextUtils.equals((CharSequence)other.endpoint, (CharSequence)client.endpoint) && !TextUtils.isEmpty((CharSequence)client.endpoint)) continue;
            needsEndpointDisconnect = false;
            break;
        }
        if (needsEndpointDisconnect && this.transport != null) {
            this.transport.send(String.format("0::%s", client.endpoint));
        }
        if (this.clients.size() > 0 || this.transport == null) {
            return;
        }
        this.transport.setStringCallback(null);
        this.transport.setClosedCallback(null);
        this.transport.disconnect();
        this.transport = null;
    }

    void reconnect(DependentCancellable child) {
        if (this.isConnected()) {
            return;
        }
        if (this.connecting != null && !this.connecting.isDone() && !this.connecting.isCancelled()) {
            if (child != null) {
                child.setParent(this.connecting);
            }
            return;
        }
        this.request.logi("Reconnecting socket.io");
        this.connecting = this.httpClient.executeString(this.request, null).then(new TransformFuture<SocketIOTransport, String>(){

            @Override
            protected void transform(String result) throws Exception {
                String[] parts = result.split(":");
                final String sessionId = parts[0];
                SocketIOConnection.this.heartbeat = !"".equals(parts[1]) ? Integer.parseInt(parts[1]) / 2 * 1000 : 0;
                String transportsLine = parts[3];
                String[] transports = transportsLine.split(",");
                HashSet<String> set = new HashSet<String>(Arrays.asList(transports));
                final SimpleFuture<XHRPollingTransport> transport = new SimpleFuture<XHRPollingTransport>();
                if (set.contains("websocket")) {
                    String sessionUrl = Uri.parse((String)SocketIOConnection.this.request.getUri().toString()).buildUpon().appendPath("websocket").appendPath(sessionId).build().toString();
                    SocketIOConnection.this.httpClient.websocket(sessionUrl, null, null).setCallback(new FutureCallback<WebSocket>(){

                        @Override
                        public void onCompleted(Exception e, WebSocket result) {
                            if (e != null) {
                                transport.setComplete(e);
                                return;
                            }
                            transport.setComplete(new WebSocketTransport(result, sessionId));
                        }
                    });
                } else if (set.contains("xhr-polling")) {
                    String sessionUrl = Uri.parse((String)SocketIOConnection.this.request.getUri().toString()).buildUpon().appendPath("xhr-polling").appendPath(sessionId).build().toString();
                    XHRPollingTransport xhrPolling = new XHRPollingTransport(SocketIOConnection.this.httpClient, sessionUrl, sessionId);
                    transport.setComplete(xhrPolling);
                } else {
                    throw new SocketIOException("transport not supported");
                }
                this.setComplete(transport);
            }
        }).setCallback((FutureCallback)new FutureCallback<SocketIOTransport>(){

            @Override
            public void onCompleted(Exception e, SocketIOTransport result) {
                if (e != null) {
                    SocketIOConnection.this.reportDisconnect(e);
                    return;
                }
                SocketIOConnection.this.reconnectDelay = SocketIOConnection.this.request.config.reconnectDelay;
                SocketIOConnection.this.transport = result;
                SocketIOConnection.this.attach();
            }
        });
        if (child != null) {
            child.setParent(this.connecting);
        }
    }

    void setupHeartbeat() {
        final SocketIOTransport ts = this.transport;
        Runnable heartbeatRunner = new Runnable(){

            @Override
            public void run() {
                if (SocketIOConnection.this.heartbeat <= 0 || ts != SocketIOConnection.this.transport || ts == null || !ts.isConnected()) {
                    return;
                }
                SocketIOConnection.this.transport.send("2:::");
                if (SocketIOConnection.this.transport != null) {
                    SocketIOConnection.this.transport.getServer().postDelayed(this, SocketIOConnection.this.heartbeat);
                }
            }
        };
        heartbeatRunner.run();
    }

    private void select(String endpoint, SelectCallback callback) {
        for (SocketIOClient client : this.clients) {
            if (endpoint != null && !TextUtils.equals((CharSequence)client.endpoint, (CharSequence)endpoint)) continue;
            callback.onSelect(client);
        }
    }

    private void delayReconnect() {
        if (this.transport != null || this.clients.size() == 0) {
            return;
        }
        boolean disconnected = false;
        for (SocketIOClient client : this.clients) {
            if (!client.disconnected) continue;
            disconnected = true;
            break;
        }
        if (!disconnected) {
            return;
        }
        this.httpClient.getServer().postDelayed(new Runnable(){

            @Override
            public void run() {
                SocketIOConnection.this.reconnect(null);
            }
        }, this.nextReconnectDelay(this.reconnectDelay));
        this.reconnectDelay *= 2L;
        if (this.request.config.reconnectDelayMax > 0L) {
            this.reconnectDelay = Math.min(this.reconnectDelay, this.request.config.reconnectDelayMax);
        }
    }

    private long nextReconnectDelay(long targetDelay) {
        if (targetDelay < 2L || targetDelay > 0x3FFFFFFFFFFFFFFFL || !this.request.config.randomizeReconnectDelay) {
            return targetDelay;
        }
        return (targetDelay >> 1) + (long)((double)targetDelay * Math.random());
    }

    private void reportDisconnect(final Exception ex) {
        if (ex != null) {
            this.request.loge("socket.io disconnected", ex);
        } else {
            this.request.logi("socket.io disconnected");
        }
        this.select(null, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                if (client.connected) {
                    client.disconnected = true;
                    DisconnectCallback closed = client.getDisconnectCallback();
                    if (closed != null) {
                        closed.onDisconnect(ex);
                    }
                } else {
                    ConnectCallback callback = client.connectCallback;
                    if (callback != null) {
                        callback.onConnectCompleted(ex, client);
                    }
                }
            }
        });
        this.delayReconnect();
    }

    private void reportConnect(String endpoint) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                if (client.isConnected()) {
                    return;
                }
                if (!client.connected) {
                    client.connected = true;
                    ConnectCallback callback = client.connectCallback;
                    if (callback != null) {
                        callback.onConnectCompleted(null, client);
                    }
                } else if (client.disconnected) {
                    client.disconnected = false;
                    ReconnectCallback callback = client.reconnectCallback;
                    if (callback != null) {
                        callback.onReconnect();
                    }
                }
            }
        });
    }

    private void reportJson(String endpoint, final JSONObject jsonMessage, final Acknowledge acknowledge) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                JSONCallback callback = client.jsonCallback;
                if (callback != null) {
                    callback.onJSON(jsonMessage, acknowledge);
                }
            }
        });
    }

    private void reportString(String endpoint, final String string, final Acknowledge acknowledge) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                StringCallback callback = client.stringCallback;
                if (callback != null) {
                    callback.onString(string, acknowledge);
                }
            }
        });
    }

    private void reportEvent(String endpoint, final String event, final JSONArray arguments, final Acknowledge acknowledge) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                client.onEvent(event, arguments, acknowledge);
            }
        });
    }

    private void reportError(String endpoint, final String error) {
        this.select(endpoint, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                ErrorCallback callback = client.errorCallback;
                if (callback != null) {
                    callback.onError(error);
                }
            }
        });
    }

    private Acknowledge acknowledge(String _messageId, final String endpoint) {
        if (TextUtils.isEmpty((CharSequence)_messageId)) {
            return null;
        }
        final String messageId = _messageId.replaceAll("\\+$", "");
        return new Acknowledge(){

            @Override
            public void acknowledge(JSONArray arguments) {
                SocketIOTransport transport;
                String data = "";
                if (arguments != null) {
                    data = data + "+" + arguments.toString();
                }
                if ((transport = SocketIOConnection.this.transport) == null) {
                    final SocketIOException e = new SocketIOException("not connected to server");
                    SocketIOConnection.this.select(endpoint, new SelectCallback(){

                        @Override
                        public void onSelect(SocketIOClient client) {
                            ExceptionCallback callback = client.exceptionCallback;
                            if (callback != null) {
                                callback.onException(e);
                            }
                        }
                    });
                    return;
                }
                transport.send(String.format("6:::%s%s", messageId, data));
            }
        };
    }

    private void attach() {
        if (this.transport.heartbeats()) {
            this.setupHeartbeat();
        }
        this.transport.setClosedCallback(new CompletedCallback(){

            @Override
            public void onCompleted(Exception ex) {
                SocketIOConnection.this.transport = null;
                SocketIOConnection.this.reportDisconnect(ex);
            }
        });
        this.transport.setStringCallback(new SocketIOTransport.StringCallback(){

            @Override
            public void onStringAvailable(String message) {
                try {
                    String[] parts = message.split(":", 4);
                    int code = Integer.parseInt(parts[0]);
                    switch (code) {
                        case 0: {
                            SocketIOConnection.this.transport.disconnect();
                            SocketIOConnection.this.reportDisconnect(null);
                            break;
                        }
                        case 1: {
                            SocketIOConnection.this.reportConnect(parts[2]);
                            break;
                        }
                        case 2: {
                            SocketIOConnection.this.transport.send("2::");
                            break;
                        }
                        case 3: {
                            SocketIOConnection.this.reportString(parts[2], parts[3], SocketIOConnection.this.acknowledge(parts[1], parts[2]));
                            break;
                        }
                        case 4: {
                            String dataString = parts[3];
                            JSONObject jsonMessage = new JSONObject(dataString);
                            SocketIOConnection.this.reportJson(parts[2], jsonMessage, SocketIOConnection.this.acknowledge(parts[1], parts[2]));
                            break;
                        }
                        case 5: {
                            String dataString = parts[3];
                            JSONObject data = new JSONObject(dataString);
                            String event = data.getString("name");
                            JSONArray args = data.optJSONArray("args");
                            SocketIOConnection.this.reportEvent(parts[2], event, args, SocketIOConnection.this.acknowledge(parts[1], parts[2]));
                            break;
                        }
                        case 6: {
                            String[] ackParts = parts[3].split("\\+", 2);
                            Acknowledge ack = SocketIOConnection.this.acknowledges.remove(ackParts[0]);
                            if (ack == null) {
                                return;
                            }
                            JSONArray arguments = null;
                            if (ackParts.length == 2) {
                                arguments = new JSONArray(ackParts[1]);
                            }
                            ack.acknowledge(arguments);
                            break;
                        }
                        case 7: {
                            SocketIOConnection.this.reportError(parts[2], parts[3]);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        default: {
                            throw new SocketIOException("unknown code");
                        }
                    }
                }
                catch (Exception ex) {
                    SocketIOConnection.this.transport.setClosedCallback(null);
                    SocketIOConnection.this.transport.disconnect();
                    SocketIOConnection.this.transport = null;
                    SocketIOConnection.this.reportDisconnect(ex);
                }
            }
        });
        this.select(null, new SelectCallback(){

            @Override
            public void onSelect(SocketIOClient client) {
                if (TextUtils.isEmpty((CharSequence)client.endpoint)) {
                    return;
                }
                SocketIOConnection.this.connect(client);
            }
        });
    }

    private static interface SelectCallback {
        public void onSelect(SocketIOClient var1);
    }
}

