/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.AssetManager;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncServerSocket;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.ListenCallback;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.WebSocket;
import com.koushikdutta.async.http.WebSocketImpl;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.server.AsyncHttpServerRequest;
import com.koushikdutta.async.http.server.AsyncHttpServerRequestImpl;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import com.koushikdutta.async.http.server.AsyncHttpServerResponseImpl;
import com.koushikdutta.async.http.server.HttpServerRequestCallback;
import com.koushikdutta.async.http.server.UnknownRequestBody;
import com.koushikdutta.async.util.StreamUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;

@TargetApi(value=5)
public class AsyncHttpServer {
    ArrayList<AsyncServerSocket> mListeners = new ArrayList();
    ListenCallback mListenCallback = new ListenCallback(){

        @Override
        public void onAccepted(final AsyncSocket socket) {
            AsyncHttpServerRequestImpl req = new AsyncHttpServerRequestImpl(){
                HttpServerRequestCallback match;
                String fullPath;
                String path;
                boolean responseComplete;
                boolean requestComplete;
                AsyncHttpServerResponseImpl res;
                boolean hasContinued;

                @Override
                protected AsyncHttpRequestBody onUnknownBody(Headers headers) {
                    return AsyncHttpServer.this.onUnknownBody(headers);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onHeadersReceived() {
                    Headers headers = this.getHeaders();
                    if (!this.hasContinued && "100-continue".equals(headers.get("Expect"))) {
                        this.pause();
                        Util.writeAll((DataSink)this.mSocket, "HTTP/1.1 100 Continue\r\n\r\n".getBytes(), new CompletedCallback(){

                            @Override
                            public void onCompleted(Exception ex) {
                                this.resume();
                                if (ex != null) {
                                    this.report(ex);
                                    return;
                                }
                                hasContinued = true;
                                this.onHeadersReceived();
                            }
                        });
                        return;
                    }
                    String statusLine = this.getStatusLine();
                    String[] parts = statusLine.split(" ");
                    this.fullPath = parts[1];
                    this.path = this.fullPath.split("\\?")[0];
                    this.method = parts[0];
                    Hashtable<String, ArrayList<Pair>> hashtable = AsyncHttpServer.this.mActions;
                    synchronized (hashtable) {
                        ArrayList<Pair> pairs = AsyncHttpServer.this.mActions.get(this.method);
                        if (pairs != null) {
                            for (Pair p : pairs) {
                                Matcher m = p.regex.matcher(this.path);
                                if (!m.matches()) continue;
                                this.mMatcher = m;
                                this.match = p.callback;
                                break;
                            }
                        }
                    }
                    this.res = new AsyncHttpServerResponseImpl(socket, this){

                        @Override
                        protected void report(Exception e) {
                            super.report(e);
                            if (e != null) {
                                socket.setDataCallback(new DataCallback.NullDataCallback());
                                socket.setEndCallback(new CompletedCallback.NullCompletedCallback());
                                socket.close();
                            }
                        }

                        @Override
                        protected void onEnd() {
                            super.onEnd();
                            this.mSocket.setEndCallback(null);
                            responseComplete = true;
                            this.handleOnCompleted();
                        }
                    };
                    boolean handled = AsyncHttpServer.this.onRequest(this, this.res);
                    if (this.match == null && !handled) {
                        this.res.code(404);
                        this.res.end();
                        return;
                    }
                    if (!this.getBody().readFullyOnRequest()) {
                        AsyncHttpServer.this.onRequest(this.match, this, this.res);
                    } else if (this.requestComplete) {
                        AsyncHttpServer.this.onRequest(this.match, this, this.res);
                    }
                }

                @Override
                public void onCompleted(Exception e) {
                    if (this.res.code() == 101) {
                        return;
                    }
                    this.requestComplete = true;
                    super.onCompleted(e);
                    this.mSocket.setDataCallback(new DataCallback.NullDataCallback(){

                        @Override
                        public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                            super.onDataAvailable(emitter, bb);
                            mSocket.close();
                        }
                    });
                    this.handleOnCompleted();
                    if (this.getBody().readFullyOnRequest()) {
                        AsyncHttpServer.this.onRequest(this.match, this, this.res);
                    }
                }

                private void handleOnCompleted() {
                    if (this.requestComplete && this.responseComplete) {
                        if (HttpUtil.isKeepAlive(Protocol.HTTP_1_1, this.getHeaders())) {
                            this.onAccepted(socket);
                        } else {
                            socket.close();
                        }
                    }
                }

                @Override
                public String getPath() {
                    return this.path;
                }

                @Override
                public Multimap getQuery() {
                    String[] parts = this.fullPath.split("\\?", 2);
                    if (parts.length < 2) {
                        return new Multimap();
                    }
                    return Multimap.parseQuery(parts[1]);
                }
            };
            req.setSocket(socket);
            socket.resume();
        }

        @Override
        public void onCompleted(Exception error) {
            AsyncHttpServer.this.report(error);
        }

        @Override
        public void onListening(AsyncServerSocket socket) {
            AsyncHttpServer.this.mListeners.add(socket);
        }
    };
    CompletedCallback mCompletedCallback;
    final Hashtable<String, ArrayList<Pair>> mActions = new Hashtable();
    static Hashtable<String, String> mContentTypes = new Hashtable();
    private static Hashtable<Integer, String> mCodes = new Hashtable();

    public AsyncHttpServer() {
        mContentTypes.put("js", "application/javascript");
        mContentTypes.put("json", "application/json");
        mContentTypes.put("png", "image/png");
        mContentTypes.put("jpg", "image/jpeg");
        mContentTypes.put("html", "text/html");
        mContentTypes.put("css", "text/css");
        mContentTypes.put("mp4", "video/mp4");
        mContentTypes.put("mov", "video/quicktime");
        mContentTypes.put("wmv", "video/x-ms-wmv");
    }

    public void stop() {
        if (this.mListeners != null) {
            for (AsyncServerSocket listener : this.mListeners) {
                listener.stop();
            }
        }
    }

    protected boolean onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        return false;
    }

    protected void onRequest(HttpServerRequestCallback callback, AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
        if (callback != null) {
            callback.onRequest(request, response);
        }
    }

    protected AsyncHttpRequestBody onUnknownBody(Headers headers) {
        return new UnknownRequestBody(headers.get("Content-Type"));
    }

    public AsyncServerSocket listen(AsyncServer server, int port) {
        return server.listen(null, port, this.mListenCallback);
    }

    private void report(Exception ex) {
        if (this.mCompletedCallback != null) {
            this.mCompletedCallback.onCompleted(ex);
        }
    }

    public AsyncServerSocket listen(int port) {
        return this.listen(AsyncServer.getDefault(), port);
    }

    public void listenSecure(final int port, final SSLContext sslContext) {
        AsyncServer.getDefault().listen(null, port, new ListenCallback(){

            @Override
            public void onAccepted(AsyncSocket socket) {
                AsyncSSLSocketWrapper.handshake(socket, null, port, sslContext.createSSLEngine(), null, null, false, new AsyncSSLSocketWrapper.HandshakeCallback(){

                    @Override
                    public void onHandshakeCompleted(Exception e, AsyncSSLSocket socket) {
                        if (socket != null) {
                            AsyncHttpServer.this.mListenCallback.onAccepted(socket);
                        }
                    }
                });
            }

            @Override
            public void onListening(AsyncServerSocket socket) {
                AsyncHttpServer.this.mListenCallback.onListening(socket);
            }

            @Override
            public void onCompleted(Exception ex) {
                AsyncHttpServer.this.mListenCallback.onCompleted(ex);
            }
        });
    }

    public ListenCallback getListenCallback() {
        return this.mListenCallback;
    }

    public void setErrorCallback(CompletedCallback callback) {
        this.mCompletedCallback = callback;
    }

    public CompletedCallback getErrorCallback() {
        return this.mCompletedCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAction(String action, String regex) {
        Hashtable<String, ArrayList<Pair>> hashtable = this.mActions;
        synchronized (hashtable) {
            ArrayList<Pair> pairs = this.mActions.get(action);
            if (pairs == null) {
                return;
            }
            for (int i = 0; i < pairs.size(); ++i) {
                Pair p = pairs.get(i);
                if (!regex.equals(p.regex.toString())) continue;
                pairs.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAction(String action, String regex, HttpServerRequestCallback callback) {
        Pair p = new Pair();
        p.regex = Pattern.compile("^" + regex);
        p.callback = callback;
        Hashtable<String, ArrayList<Pair>> hashtable = this.mActions;
        synchronized (hashtable) {
            ArrayList<Pair> pairs = this.mActions.get(action);
            if (pairs == null) {
                pairs = new ArrayList();
                this.mActions.put(action, pairs);
            }
            pairs.add(p);
        }
    }

    public void websocket(String regex, WebSocketRequestCallback callback) {
        this.websocket(regex, null, callback);
    }

    public void websocket(String regex, final String protocol, final WebSocketRequestCallback callback) {
        this.get(regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
                boolean hasUpgrade = false;
                String connection = request.getHeaders().get("Connection");
                if (connection != null) {
                    String[] connections;
                    for (String c : connections = connection.split(",")) {
                        if (!"Upgrade".equalsIgnoreCase(c.trim())) continue;
                        hasUpgrade = true;
                        break;
                    }
                }
                if (!"websocket".equalsIgnoreCase(request.getHeaders().get("Upgrade")) || !hasUpgrade) {
                    response.code(404);
                    response.end();
                    return;
                }
                String peerProtocol = request.getHeaders().get("Sec-WebSocket-Protocol");
                if (!TextUtils.equals((CharSequence)protocol, (CharSequence)peerProtocol)) {
                    response.code(404);
                    response.end();
                    return;
                }
                callback.onConnected(new WebSocketImpl(request, response), request);
            }
        });
    }

    public void get(String regex, HttpServerRequestCallback callback) {
        this.addAction("GET", regex, callback);
    }

    public void post(String regex, HttpServerRequestCallback callback) {
        this.addAction("POST", regex, callback);
    }

    public static android.util.Pair<Integer, InputStream> getAssetStream(Context context, String asset) {
        AssetManager am = context.getAssets();
        try {
            InputStream is = am.open(asset);
            return new android.util.Pair((Object)is.available(), (Object)is);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getContentType(String path) {
        String type = AsyncHttpServer.tryGetContentType(path);
        if (type != null) {
            return type;
        }
        return "text/plain";
    }

    public static String tryGetContentType(String path) {
        String e;
        String ct;
        int index = path.lastIndexOf(".");
        if (index != -1 && (ct = mContentTypes.get(e = path.substring(index + 1))) != null) {
            return ct;
        }
        return null;
    }

    public void directory(Context context, String regex, final String assetPath) {
        final Context _context = context.getApplicationContext();
        this.addAction("GET", regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, final AsyncHttpServerResponse response) {
                String path = request.getMatcher().replaceAll("");
                android.util.Pair<Integer, InputStream> pair = AsyncHttpServer.getAssetStream(_context, assetPath + path);
                if (pair == null || pair.second == null) {
                    response.code(404);
                    response.end();
                    return;
                }
                final InputStream is = (InputStream)pair.second;
                response.getHeaders().set("Content-Length", String.valueOf(pair.first));
                response.code(200);
                response.getHeaders().add("Content-Type", AsyncHttpServer.getContentType(assetPath + path));
                Util.pump(is, (DataSink)response, new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        response.end();
                        StreamUtility.closeQuietly(is);
                    }
                });
            }
        });
        this.addAction("HEAD", regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, AsyncHttpServerResponse response) {
                String path = request.getMatcher().replaceAll("");
                android.util.Pair<Integer, InputStream> pair = AsyncHttpServer.getAssetStream(_context, assetPath + path);
                if (pair == null || pair.second == null) {
                    response.code(404);
                    response.end();
                    return;
                }
                InputStream is = (InputStream)pair.second;
                StreamUtility.closeQuietly(is);
                response.getHeaders().set("Content-Length", String.valueOf(pair.first));
                response.code(200);
                response.getHeaders().add("Content-Type", AsyncHttpServer.getContentType(assetPath + path));
                response.writeHead();
                response.end();
            }
        });
    }

    public void directory(String regex, File directory) {
        this.directory(regex, directory, false);
    }

    public void directory(String regex, final File directory, final boolean list) {
        assert (directory.isDirectory());
        this.addAction("GET", regex, new HttpServerRequestCallback(){

            @Override
            public void onRequest(AsyncHttpServerRequest request, final AsyncHttpServerResponse response) {
                String path = request.getMatcher().replaceAll("");
                File file = new File(directory, path);
                if (file.isDirectory() && list) {
                    ArrayList<File> dirs = new ArrayList<File>();
                    ArrayList<File> files = new ArrayList<File>();
                    for (File f : file.listFiles()) {
                        if (f.isDirectory()) {
                            dirs.add(f);
                            continue;
                        }
                        files.add(f);
                    }
                    Comparator<File> c = new Comparator<File>(){

                        @Override
                        public int compare(File lhs, File rhs) {
                            return lhs.getName().compareTo(rhs.getName());
                        }
                    };
                    Collections.sort(dirs, c);
                    Collections.sort(files, c);
                    files.addAll(0, dirs);
                    return;
                }
                if (!file.isFile()) {
                    response.code(404);
                    response.end();
                    return;
                }
                try {
                    FileInputStream is = new FileInputStream(file);
                    response.code(200);
                    Util.pump(is, (DataSink)response, new CompletedCallback(){

                        @Override
                        public void onCompleted(Exception ex) {
                            response.end();
                        }
                    });
                }
                catch (FileNotFoundException ex) {
                    response.code(404);
                    response.end();
                }
            }
        });
    }

    public static String getResponseCodeDescription(int code) {
        String d = mCodes.get(code);
        if (d == null) {
            return "Unknown";
        }
        return d;
    }

    static {
        mCodes.put(200, "OK");
        mCodes.put(206, "Partial Content");
        mCodes.put(101, "Switching Protocols");
        mCodes.put(301, "Moved Permanently");
        mCodes.put(302, "Found");
        mCodes.put(404, "Not Found");
    }

    public static interface WebSocketRequestCallback {
        public void onConnected(WebSocket var1, AsyncHttpServerRequest var2);
    }

    private static class Pair {
        Pattern regex;
        HttpServerRequestCallback callback;

        private Pair() {
        }
    }
}

