/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.util;

import com.koushikdutta.async.ByteBufferList;
import java.nio.ByteBuffer;

public class Allocator {
    final int maxAlloc;
    int currentAlloc = 0;
    int minAlloc = 4096;

    public Allocator(int maxAlloc) {
        this.maxAlloc = maxAlloc;
    }

    public Allocator() {
        this.maxAlloc = ByteBufferList.MAX_ITEM_SIZE;
    }

    public ByteBuffer allocate() {
        return this.allocate(this.currentAlloc);
    }

    public ByteBuffer allocate(int currentAlloc) {
        return ByteBufferList.obtain(Math.min(Math.max(currentAlloc, this.minAlloc), this.maxAlloc));
    }

    public void track(long read) {
        this.currentAlloc = (int)read * 2;
    }

    public int getMaxAlloc() {
        return this.maxAlloc;
    }

    public void setCurrentAlloc(int currentAlloc) {
        this.currentAlloc = currentAlloc;
    }

    public int getMinAlloc() {
        return this.minAlloc;
    }

    public Allocator setMinAlloc(int minAlloc) {
        this.minAlloc = minAlloc;
        return this;
    }
}

