/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import java.util.Hashtable;

public enum Protocol {
    HTTP_1_0("http/1.0"),
    HTTP_1_1("http/1.1"),
    SPDY_3("spdy/3.1"),
    HTTP_2("h2-13");

    private final String protocol;
    private static final Hashtable<String, Protocol> protocols;

    private Protocol(String protocol) {
        this.protocol = protocol;
    }

    public static Protocol get(String protocol) {
        if (protocol == null) {
            return null;
        }
        return protocols.get(protocol.toLowerCase());
    }

    public String toString() {
        return this.protocol;
    }

    static {
        protocols = new Hashtable();
        protocols.put(HTTP_1_0.toString(), HTTP_1_0);
        protocols.put(HTTP_1_1.toString(), HTTP_1_1);
        protocols.put(SPDY_3.toString(), SPDY_3);
        protocols.put(HTTP_2.toString(), HTTP_2);
    }
}

