/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.spdy;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.http.spdy.ByteString;
import com.koushikdutta.async.http.spdy.Header;
import com.koushikdutta.async.http.spdy.Spdy3;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class HeaderReader {
    Inflater inflater = new Inflater(){

        @Override
        public int inflate(byte[] buffer, int offset, int count) throws DataFormatException {
            int result = super.inflate(buffer, offset, count);
            if (result == 0 && this.needsDictionary()) {
                this.setDictionary(Spdy3.DICTIONARY);
                result = super.inflate(buffer, offset, count);
            }
            return result;
        }
    };

    public List<Header> readHeader(ByteBufferList bb, int length) throws IOException {
        byte[] bytes = new byte[length];
        bb.get(bytes);
        this.inflater.setInput(bytes);
        ByteBufferList source = new ByteBufferList().order(ByteOrder.BIG_ENDIAN);
        while (!this.inflater.needsInput()) {
            ByteBuffer b = ByteBufferList.obtain(8192);
            try {
                int read = this.inflater.inflate(b.array());
                b.limit(read);
                source.add(b);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }
        int numberOfPairs = source.getInt();
        ArrayList<Header> entries = new ArrayList<Header>(numberOfPairs);
        for (int i = 0; i < numberOfPairs; ++i) {
            ByteString name = HeaderReader.readByteString(source).toAsciiLowercase();
            ByteString values = HeaderReader.readByteString(source);
            if (name.size() == 0) {
                throw new IOException("name.size == 0");
            }
            entries.add(new Header(name, values));
        }
        return entries;
    }

    private static ByteString readByteString(ByteBufferList source) {
        int length = source.getInt();
        return ByteString.of(source.getBytes(length));
    }
}

