/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http;

import android.net.Uri;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.LineEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncSSLEngineConfigurator;
import com.koushikdutta.async.http.AsyncSocketMiddleware;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;

public class AsyncSSLSocketMiddleware
extends AsyncSocketMiddleware {
    protected SSLContext sslContext;
    protected TrustManager[] trustManagers;
    protected HostnameVerifier hostnameVerifier;
    protected List<AsyncSSLEngineConfigurator> engineConfigurators = new ArrayList<AsyncSSLEngineConfigurator>();

    public AsyncSSLSocketMiddleware(AsyncHttpClient client) {
        super(client, "https", 443);
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public SSLContext getSSLContext() {
        return this.sslContext != null ? this.sslContext : AsyncSSLSocketWrapper.getDefaultSSLContext();
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void addEngineConfigurator(AsyncSSLEngineConfigurator engineConfigurator) {
        this.engineConfigurators.add(engineConfigurator);
    }

    public void clearEngineConfigurators() {
        this.engineConfigurators.clear();
    }

    protected SSLEngine createConfiguredSSLEngine(AsyncHttpClientMiddleware.GetSocketData data, String host, int port) {
        SSLContext sslContext = this.getSSLContext();
        SSLEngine sslEngine = sslContext.createSSLEngine();
        for (AsyncSSLEngineConfigurator configurator : this.engineConfigurators) {
            configurator.configureEngine(sslEngine, data, host, port);
        }
        return sslEngine;
    }

    protected AsyncSSLSocketWrapper.HandshakeCallback createHandshakeCallback(AsyncHttpClientMiddleware.GetSocketData data, final ConnectCallback callback) {
        return new AsyncSSLSocketWrapper.HandshakeCallback(){

            @Override
            public void onHandshakeCompleted(Exception e, AsyncSSLSocket socket) {
                callback.onConnectCompleted(e, socket);
            }
        };
    }

    protected void tryHandshake(AsyncSocket socket, AsyncHttpClientMiddleware.GetSocketData data, Uri uri, int port, ConnectCallback callback) {
        AsyncSSLSocketWrapper.handshake(socket, uri.getHost(), port, this.createConfiguredSSLEngine(data, uri.getHost(), port), this.trustManagers, this.hostnameVerifier, true, this.createHandshakeCallback(data, callback));
    }

    @Override
    protected ConnectCallback wrapCallback(final AsyncHttpClientMiddleware.GetSocketData data, final Uri uri, final int port, final boolean proxied, final ConnectCallback callback) {
        return new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, final AsyncSocket socket) {
                if (ex != null) {
                    callback.onConnectCompleted(ex, socket);
                    return;
                }
                if (!proxied) {
                    AsyncSSLSocketMiddleware.this.tryHandshake(socket, data, uri, port, callback);
                    return;
                }
                String connect = String.format("CONNECT %s:%s HTTP/1.1\r\nHost: %s\r\n\r\n", uri.getHost(), port, uri.getHost());
                data.request.logv("Proxying: " + connect);
                Util.writeAll((DataSink)socket, connect.getBytes(), new CompletedCallback(){

                    @Override
                    public void onCompleted(Exception ex) {
                        if (ex != null) {
                            callback.onConnectCompleted(ex, socket);
                            return;
                        }
                        LineEmitter liner = new LineEmitter();
                        liner.setLineCallback(new LineEmitter.StringCallback(){
                            String statusLine;

                            @Override
                            public void onStringAvailable(String s) {
                                data.request.logv(s);
                                if (this.statusLine == null) {
                                    this.statusLine = s.trim();
                                    if (!this.statusLine.matches("HTTP/1.\\d 2\\d\\d .*")) {
                                        socket.setDataCallback(null);
                                        socket.setEndCallback(null);
                                        callback.onConnectCompleted(new IOException("non 2xx status line: " + this.statusLine), socket);
                                    }
                                } else if (TextUtils.isEmpty((CharSequence)s.trim())) {
                                    socket.setDataCallback(null);
                                    socket.setEndCallback(null);
                                    AsyncSSLSocketMiddleware.this.tryHandshake(socket, data, uri, port, callback);
                                }
                            }
                        });
                        socket.setDataCallback(liner);
                        socket.setEndCallback(new CompletedCallback(){

                            @Override
                            public void onCompleted(Exception ex) {
                                if (!socket.isOpen() && ex == null) {
                                    ex = new IOException("socket closed before proxy connect response");
                                }
                                callback.onConnectCompleted(ex, socket);
                            }
                        });
                    }
                });
            }
        };
    }
}

