/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.spdy;

import android.net.Uri;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.MultiFuture;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncSSLEngineConfigurator;
import com.koushikdutta.async.http.AsyncSSLSocketMiddleware;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.spdy.AsyncSpdyConnection;
import com.koushikdutta.async.http.spdy.Header;
import com.koushikdutta.async.http.spdy.Settings;
import com.koushikdutta.async.http.spdy.SpdyTransport;
import com.koushikdutta.async.util.Charsets;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SpdyMiddleware
extends AsyncSSLSocketMiddleware {
    boolean initialized;
    Field peerHost;
    Field peerPort;
    Field sslParameters;
    Field npnProtocols;
    Field alpnProtocols;
    Field sslNativePointer;
    Field useSni;
    Method nativeGetNpnNegotiatedProtocol;
    Method nativeGetAlpnNegotiatedProtocol;
    Hashtable<String, SpdyConnectionWaiter> connections = new Hashtable();
    boolean spdyEnabled;
    private static final NoSpdyException NO_SPDY = new NoSpdyException();

    public SpdyMiddleware(AsyncHttpClient client) {
        super(client);
        this.addEngineConfigurator(new AsyncSSLEngineConfigurator(){

            @Override
            public void configureEngine(SSLEngine engine, AsyncHttpClientMiddleware.GetSocketData data, String host, int port) {
                SpdyMiddleware.this.configure(engine, data, host, port);
            }
        });
    }

    private void configure(SSLEngine engine, AsyncHttpClientMiddleware.GetSocketData data, String host, int port) {
        if (!this.initialized && this.spdyEnabled) {
            this.initialized = true;
            try {
                this.peerHost = engine.getClass().getSuperclass().getDeclaredField("peerHost");
                this.peerPort = engine.getClass().getSuperclass().getDeclaredField("peerPort");
                this.sslParameters = engine.getClass().getDeclaredField("sslParameters");
                this.npnProtocols = this.sslParameters.getType().getDeclaredField("npnProtocols");
                this.alpnProtocols = this.sslParameters.getType().getDeclaredField("alpnProtocols");
                this.useSni = this.sslParameters.getType().getDeclaredField("useSni");
                this.sslNativePointer = engine.getClass().getDeclaredField("sslNativePointer");
                String nativeCryptoName = this.sslParameters.getType().getPackage().getName() + ".NativeCrypto";
                this.nativeGetNpnNegotiatedProtocol = Class.forName(nativeCryptoName, true, this.sslParameters.getType().getClassLoader()).getDeclaredMethod("SSL_get_npn_negotiated_protocol", Long.TYPE);
                this.nativeGetAlpnNegotiatedProtocol = Class.forName(nativeCryptoName, true, this.sslParameters.getType().getClassLoader()).getDeclaredMethod("SSL_get0_alpn_selected", Long.TYPE);
                this.peerHost.setAccessible(true);
                this.peerPort.setAccessible(true);
                this.sslParameters.setAccessible(true);
                this.npnProtocols.setAccessible(true);
                this.alpnProtocols.setAccessible(true);
                this.useSni.setAccessible(true);
                this.sslNativePointer.setAccessible(true);
                this.nativeGetNpnNegotiatedProtocol.setAccessible(true);
                this.nativeGetAlpnNegotiatedProtocol.setAccessible(true);
            }
            catch (Exception e) {
                this.sslParameters = null;
                this.npnProtocols = null;
                this.alpnProtocols = null;
                this.useSni = null;
                this.sslNativePointer = null;
                this.nativeGetNpnNegotiatedProtocol = null;
                this.nativeGetAlpnNegotiatedProtocol = null;
            }
        }
        if (!this.canSpdyRequest(data)) {
            return;
        }
        if (this.sslParameters != null) {
            try {
                byte[] protocols = SpdyMiddleware.concatLengthPrefixed(Protocol.HTTP_1_1, Protocol.SPDY_3);
                this.peerHost.set(engine, host);
                this.peerPort.set(engine, port);
                Object sslp = this.sslParameters.get(engine);
                this.alpnProtocols.set(sslp, protocols);
                this.useSni.set(sslp, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getSpdyEnabled() {
        return this.spdyEnabled;
    }

    public void setSpdyEnabled(boolean enabled) {
        this.spdyEnabled = enabled;
    }

    @Override
    public void setSSLContext(SSLContext sslContext) {
        super.setSSLContext(sslContext);
        this.initialized = false;
    }

    static byte[] concatLengthPrefixed(Protocol ... protocols) {
        ByteBuffer result = ByteBuffer.allocate(8192);
        for (Protocol protocol : protocols) {
            if (protocol == Protocol.HTTP_1_0) continue;
            result.put((byte)protocol.toString().length());
            result.put(protocol.toString().getBytes(Charsets.UTF_8));
        }
        result.flip();
        byte[] ret = new ByteBufferList(result).getAllByteArray();
        return ret;
    }

    private static String requestPath(Uri uri) {
        String pathAndQuery = uri.getEncodedPath();
        if (pathAndQuery == null) {
            pathAndQuery = "/";
        } else if (!pathAndQuery.startsWith("/")) {
            pathAndQuery = "/" + pathAndQuery;
        }
        if (!TextUtils.isEmpty((CharSequence)uri.getEncodedQuery())) {
            pathAndQuery = pathAndQuery + "?" + uri.getEncodedQuery();
        }
        return pathAndQuery;
    }

    private void noSpdy(String key) {
        SpdyConnectionWaiter conn = this.connections.remove(key);
        if (conn != null) {
            conn.setComplete(NO_SPDY);
        }
    }

    private void invokeConnect(String key, ConnectCallback callback, Exception e, AsyncSSLSocket socket) {
        SpdyConnectionWaiter waiter = this.connections.get(key);
        if (waiter.originalCancellable.setComplete()) {
            callback.onConnectCompleted(e, socket);
        }
    }

    @Override
    protected AsyncSSLSocketWrapper.HandshakeCallback createHandshakeCallback(final AsyncHttpClientMiddleware.GetSocketData data, final ConnectCallback callback) {
        final String key = (String)data.state.get("spdykey");
        if (key == null) {
            return super.createHandshakeCallback(data, callback);
        }
        return new AsyncSSLSocketWrapper.HandshakeCallback(){

            @Override
            public void onHandshakeCompleted(Exception e, AsyncSSLSocket socket) {
                String protoString;
                data.request.logv("checking spdy handshake");
                if (e != null || SpdyMiddleware.this.nativeGetAlpnNegotiatedProtocol == null) {
                    SpdyMiddleware.this.invokeConnect(key, callback, e, socket);
                    SpdyMiddleware.this.noSpdy(key);
                    return;
                }
                try {
                    long ptr = (Long)SpdyMiddleware.this.sslNativePointer.get(socket.getSSLEngine());
                    byte[] proto = (byte[])SpdyMiddleware.this.nativeGetAlpnNegotiatedProtocol.invoke(null, ptr);
                    if (proto == null) {
                        SpdyMiddleware.this.invokeConnect(key, callback, null, socket);
                        SpdyMiddleware.this.noSpdy(key);
                        return;
                    }
                    protoString = new String(proto);
                    Protocol p = Protocol.get(protoString);
                    if (p == null) {
                        SpdyMiddleware.this.invokeConnect(key, callback, null, socket);
                        SpdyMiddleware.this.noSpdy(key);
                        return;
                    }
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)ex);
                }
                AsyncSpdyConnection connection = new AsyncSpdyConnection(socket, Protocol.get(protoString)){
                    boolean hasReceivedSettings;

                    @Override
                    public void settings(boolean clearPrevious, Settings settings) {
                        super.settings(clearPrevious, settings);
                        if (!this.hasReceivedSettings) {
                            try {
                                this.sendConnectionPreface();
                            }
                            catch (IOException e1) {
                                e1.printStackTrace();
                            }
                            this.hasReceivedSettings = true;
                            SpdyConnectionWaiter waiter = SpdyMiddleware.this.connections.get(key);
                            if (waiter.originalCancellable.setComplete()) {
                                data.request.logv("using new spdy connection for host: " + data.request.getUri().getHost());
                                SpdyMiddleware.this.newSocket(data, this, callback);
                            }
                            waiter.setComplete(this);
                        }
                    }
                };
            }
        };
    }

    private void newSocket(AsyncHttpClientMiddleware.GetSocketData data, AsyncSpdyConnection connection, ConnectCallback callback) {
        AsyncHttpRequest request = data.request;
        data.protocol = connection.protocol.toString();
        AsyncHttpRequestBody requestBody = data.request.getBody();
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header(Header.TARGET_METHOD, request.getMethod()));
        headers.add(new Header(Header.TARGET_PATH, SpdyMiddleware.requestPath(request.getUri())));
        String host = request.getHeaders().get("Host");
        if (Protocol.SPDY_3 == connection.protocol) {
            headers.add(new Header(Header.VERSION, "HTTP/1.1"));
            headers.add(new Header(Header.TARGET_HOST, host));
        } else if (Protocol.HTTP_2 == connection.protocol) {
            headers.add(new Header(Header.TARGET_AUTHORITY, host));
        } else {
            throw new AssertionError();
        }
        headers.add(new Header(Header.TARGET_SCHEME, request.getUri().getScheme()));
        Multimap mm = request.getHeaders().getMultiMap();
        for (String key : mm.keySet()) {
            if (SpdyTransport.isProhibitedHeader(connection.protocol, key)) continue;
            for (String value : (List)mm.get(key)) {
                headers.add(new Header(key.toLowerCase(), value));
            }
        }
        request.logv("\n" + request);
        AsyncSpdyConnection.SpdySocket spdy = connection.newStream(headers, requestBody != null, true);
        callback.onConnectCompleted(null, spdy);
    }

    private boolean canSpdyRequest(AsyncHttpClientMiddleware.GetSocketData data) {
        return data.request.getBody() == null;
    }

    @Override
    protected ConnectCallback wrapCallback(AsyncHttpClientMiddleware.GetSocketData data, Uri uri, int port, boolean proxied, ConnectCallback callback) {
        final ConnectCallback superCallback = super.wrapCallback(data, uri, port, proxied, callback);
        final String key = (String)data.state.get("spdykey");
        if (key == null) {
            return superCallback;
        }
        return new ConnectCallback(){

            @Override
            public void onConnectCompleted(Exception ex, AsyncSocket socket) {
                SpdyConnectionWaiter conn;
                if (ex != null && (conn = SpdyMiddleware.this.connections.remove(key)) != null) {
                    conn.setComplete(ex);
                }
                superCallback.onConnectCompleted(ex, socket);
            }
        };
    }

    @Override
    public Cancellable getSocket(final AsyncHttpClientMiddleware.GetSocketData data) {
        Uri uri = data.request.getUri();
        int port = this.getSchemePort(data.request.getUri());
        if (port == -1) {
            return null;
        }
        if (!this.spdyEnabled) {
            return super.getSocket(data);
        }
        if (!this.canSpdyRequest(data)) {
            return super.getSocket(data);
        }
        String key = uri.getHost() + port;
        SpdyConnectionWaiter conn = this.connections.get(key);
        if (conn != null) {
            if (conn.tryGetException() instanceof NoSpdyException) {
                return super.getSocket(data);
            }
            if (conn.tryGet() != null && !((AsyncSpdyConnection)conn.tryGet()).socket.isOpen()) {
                this.connections.remove(key);
                conn = null;
            }
        }
        if (conn == null) {
            data.state.put("spdykey", key);
            Cancellable ret = super.getSocket(data);
            if (ret.isDone() || ret.isCancelled()) {
                return ret;
            }
            conn = new SpdyConnectionWaiter();
            this.connections.put(key, conn);
            return conn.originalCancellable;
        }
        data.request.logv("waiting for potential spdy connection for host: " + data.request.getUri().getHost());
        final SimpleCancellable ret = new SimpleCancellable();
        conn.setCallback((FutureCallback)new FutureCallback<AsyncSpdyConnection>(){

            @Override
            public void onCompleted(Exception e, AsyncSpdyConnection conn) {
                if (e instanceof NoSpdyException) {
                    data.request.logv("spdy not available");
                    ret.setParent(SpdyMiddleware.super.getSocket(data));
                    return;
                }
                if (e != null) {
                    if (ret.setComplete()) {
                        data.connectCallback.onConnectCompleted(e, null);
                    }
                    return;
                }
                data.request.logv("using existing spdy connection for host: " + data.request.getUri().getHost());
                if (ret.setComplete()) {
                    SpdyMiddleware.this.newSocket(data, conn, data.connectCallback);
                }
            }
        });
        return ret;
    }

    @Override
    public boolean exchangeHeaders(final AsyncHttpClientMiddleware.OnExchangeHeaderData data) {
        if (!(data.socket instanceof AsyncSpdyConnection.SpdySocket)) {
            return super.exchangeHeaders(data);
        }
        AsyncHttpRequestBody requestBody = data.request.getBody();
        if (requestBody != null) {
            data.response.sink(data.socket);
        }
        data.sendHeadersCallback.onCompleted(null);
        final AsyncSpdyConnection.SpdySocket spdySocket = (AsyncSpdyConnection.SpdySocket)data.socket;
        spdySocket.headers().then(new TransformFuture<Headers, List<Header>>(){

            @Override
            protected void transform(List<Header> result) throws Exception {
                Headers headers = new Headers();
                for (Header header : result) {
                    String key = header.name.utf8();
                    String value = header.value.utf8();
                    headers.add(key, value);
                }
                String status = headers.remove(Header.RESPONSE_STATUS.utf8());
                String[] statusParts = status.split(" ", 2);
                data.response.code(Integer.parseInt(statusParts[0]));
                if (statusParts.length == 2) {
                    data.response.message(statusParts[1]);
                }
                data.response.protocol(headers.remove(Header.VERSION.utf8()));
                data.response.headers(headers);
                this.setComplete(headers);
            }
        }).setCallback((FutureCallback)new FutureCallback<Headers>(){

            @Override
            public void onCompleted(Exception e, Headers result) {
                data.receiveHeadersCallback.onCompleted(e);
                DataEmitter emitter = HttpUtil.getBodyDecoder(spdySocket, spdySocket.getConnection().protocol, result, false);
                data.response.emitter(emitter);
            }
        });
        return true;
    }

    @Override
    public void onRequestSent(AsyncHttpClientMiddleware.OnRequestSentData data) {
        if (!(data.socket instanceof AsyncSpdyConnection.SpdySocket)) {
            return;
        }
        if (data.request.getBody() != null) {
            data.response.sink().end();
        }
    }

    private static class NoSpdyException
    extends Exception {
        private NoSpdyException() {
        }
    }

    private static class SpdyConnectionWaiter
    extends MultiFuture<AsyncSpdyConnection> {
        SimpleCancellable originalCancellable = new SimpleCancellable();

        private SpdyConnectionWaiter() {
        }
    }
}

