/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.spdy;

import android.net.Uri;
import android.text.TextUtils;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncSSLSocketWrapper;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.ConnectCallback;
import com.koushikdutta.async.future.Cancellable;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.future.SimpleCancellable;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.AsyncSSLEngineConfigurator;
import com.koushikdutta.async.http.AsyncSSLSocketMiddleware;
import com.koushikdutta.async.http.Headers;
import com.koushikdutta.async.http.HttpUtil;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.Protocol;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.async.http.spdy.AsyncSpdyConnection;
import com.koushikdutta.async.http.spdy.Header;
import com.koushikdutta.async.http.spdy.SpdyTransport;
import com.koushikdutta.async.util.Charsets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SpdyMiddleware
extends AsyncSSLSocketMiddleware {
    boolean initialized;
    Field peerHost;
    Field peerPort;
    Field sslParameters;
    Field npnProtocols;
    Field alpnProtocols;
    Field sslNativePointer;
    Field useSni;
    Method nativeGetNpnNegotiatedProtocol;
    Method nativeGetAlpnNegotiatedProtocol;
    Hashtable<String, AsyncSpdyConnection> connections = new Hashtable();
    boolean spdyEnabled;

    public SpdyMiddleware(AsyncHttpClient client) {
        super(client);
        this.addEngineConfigurator(new AsyncSSLEngineConfigurator(){

            @Override
            public void configureEngine(SSLEngine engine, AsyncHttpClientMiddleware.GetSocketData data, String host, int port) {
                SpdyMiddleware.this.configure(engine, data, host, port);
            }
        });
    }

    private void configure(SSLEngine engine, AsyncHttpClientMiddleware.GetSocketData data, String host, int port) {
        if (!this.initialized && this.spdyEnabled) {
            this.initialized = true;
            try {
                this.peerHost = engine.getClass().getSuperclass().getDeclaredField("peerHost");
                this.peerPort = engine.getClass().getSuperclass().getDeclaredField("peerPort");
                this.sslParameters = engine.getClass().getDeclaredField("sslParameters");
                this.npnProtocols = this.sslParameters.getType().getDeclaredField("npnProtocols");
                this.alpnProtocols = this.sslParameters.getType().getDeclaredField("alpnProtocols");
                this.useSni = this.sslParameters.getType().getDeclaredField("useSni");
                this.sslNativePointer = engine.getClass().getDeclaredField("sslNativePointer");
                String nativeCryptoName = this.sslParameters.getType().getPackage().getName() + ".NativeCrypto";
                this.nativeGetNpnNegotiatedProtocol = Class.forName(nativeCryptoName, true, this.sslParameters.getType().getClassLoader()).getDeclaredMethod("SSL_get_npn_negotiated_protocol", Long.TYPE);
                this.nativeGetAlpnNegotiatedProtocol = Class.forName(nativeCryptoName, true, this.sslParameters.getType().getClassLoader()).getDeclaredMethod("SSL_get0_alpn_selected", Long.TYPE);
                this.peerHost.setAccessible(true);
                this.peerPort.setAccessible(true);
                this.sslParameters.setAccessible(true);
                this.npnProtocols.setAccessible(true);
                this.alpnProtocols.setAccessible(true);
                this.useSni.setAccessible(true);
                this.sslNativePointer.setAccessible(true);
                this.nativeGetNpnNegotiatedProtocol.setAccessible(true);
                this.nativeGetAlpnNegotiatedProtocol.setAccessible(true);
            }
            catch (Exception e) {
                this.sslParameters = null;
                this.npnProtocols = null;
                this.alpnProtocols = null;
                this.useSni = null;
                this.sslNativePointer = null;
                this.nativeGetNpnNegotiatedProtocol = null;
                this.nativeGetAlpnNegotiatedProtocol = null;
            }
        }
        if (!this.canSpdyRequest(data)) {
            return;
        }
        if (this.sslParameters != null) {
            try {
                byte[] protocols = SpdyMiddleware.concatLengthPrefixed(Protocol.HTTP_1_1, Protocol.SPDY_3);
                this.peerHost.set(engine, host);
                this.peerPort.set(engine, port);
                Object sslp = this.sslParameters.get(engine);
                this.alpnProtocols.set(sslp, protocols);
                this.useSni.set(sslp, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getSpdyEnabled() {
        return this.spdyEnabled;
    }

    public void setSpdyEnabled(boolean enabled) {
        this.spdyEnabled = enabled;
    }

    @Override
    public void setSSLContext(SSLContext sslContext) {
        super.setSSLContext(sslContext);
        this.initialized = false;
    }

    static byte[] concatLengthPrefixed(Protocol ... protocols) {
        ByteBuffer result = ByteBuffer.allocate(8192);
        for (Protocol protocol : protocols) {
            if (protocol == Protocol.HTTP_1_0) continue;
            result.put((byte)protocol.toString().length());
            result.put(protocol.toString().getBytes(Charsets.UTF_8));
        }
        result.flip();
        byte[] ret = new ByteBufferList(result).getAllByteArray();
        return ret;
    }

    private static String requestPath(Uri uri) {
        String pathAndQuery = uri.getEncodedPath();
        if (pathAndQuery == null) {
            pathAndQuery = "/";
        } else if (!pathAndQuery.startsWith("/")) {
            pathAndQuery = "/" + pathAndQuery;
        }
        if (!TextUtils.isEmpty((CharSequence)uri.getEncodedQuery())) {
            pathAndQuery = pathAndQuery + "?" + uri.getEncodedQuery();
        }
        return pathAndQuery;
    }

    @Override
    protected AsyncSSLSocketWrapper.HandshakeCallback createHandshakeCallback(final AsyncHttpClientMiddleware.GetSocketData data, final ConnectCallback callback) {
        return new AsyncSSLSocketWrapper.HandshakeCallback(){

            @Override
            public void onHandshakeCompleted(Exception e, AsyncSSLSocket socket) {
                if (e != null || SpdyMiddleware.this.nativeGetAlpnNegotiatedProtocol == null) {
                    callback.onConnectCompleted(e, socket);
                    return;
                }
                try {
                    long ptr = (Long)SpdyMiddleware.this.sslNativePointer.get(socket.getSSLEngine());
                    byte[] proto = (byte[])SpdyMiddleware.this.nativeGetAlpnNegotiatedProtocol.invoke(null, ptr);
                    if (proto == null) {
                        callback.onConnectCompleted(null, socket);
                        return;
                    }
                    String protoString = new String(proto);
                    Protocol p = Protocol.get(protoString);
                    if (p == null) {
                        callback.onConnectCompleted(null, socket);
                        return;
                    }
                    AsyncSpdyConnection connection = new AsyncSpdyConnection(socket, Protocol.get(protoString));
                    connection.sendConnectionPreface();
                    SpdyMiddleware.this.connections.put(data.request.getUri().getHost(), connection);
                    SpdyMiddleware.this.newSocket(data, connection, callback);
                }
                catch (Exception ex) {
                    socket.close();
                    callback.onConnectCompleted(ex, null);
                }
            }
        };
    }

    private void newSocket(AsyncHttpClientMiddleware.GetSocketData data, AsyncSpdyConnection connection, ConnectCallback callback) {
        AsyncHttpRequest request = data.request;
        request.logv("using spdy connection");
        data.protocol = connection.protocol.toString();
        AsyncHttpRequestBody requestBody = data.request.getBody();
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header(Header.TARGET_METHOD, request.getMethod()));
        headers.add(new Header(Header.TARGET_PATH, SpdyMiddleware.requestPath(request.getUri())));
        String host = request.getHeaders().get("Host");
        if (Protocol.SPDY_3 == connection.protocol) {
            headers.add(new Header(Header.VERSION, "HTTP/1.1"));
            headers.add(new Header(Header.TARGET_HOST, host));
        } else if (Protocol.HTTP_2 == connection.protocol) {
            headers.add(new Header(Header.TARGET_AUTHORITY, host));
        } else {
            throw new AssertionError();
        }
        headers.add(new Header(Header.TARGET_SCHEME, request.getUri().getScheme()));
        Multimap mm = request.getHeaders().getMultiMap();
        for (String key : mm.keySet()) {
            if (SpdyTransport.isProhibitedHeader(connection.protocol, key)) continue;
            for (String value : (List)mm.get(key)) {
                headers.add(new Header(key.toLowerCase(), value));
            }
        }
        request.logv("\n" + request);
        AsyncSpdyConnection.SpdySocket spdy = connection.newStream(headers, requestBody != null, true);
        callback.onConnectCompleted(null, spdy);
    }

    private boolean canSpdyRequest(AsyncHttpClientMiddleware.GetSocketData data) {
        return data.request.getBody() == null;
    }

    @Override
    public Cancellable getSocket(AsyncHttpClientMiddleware.GetSocketData data) {
        if (!this.spdyEnabled) {
            return super.getSocket(data);
        }
        Uri uri = data.request.getUri();
        int port = this.getSchemePort(data.request.getUri());
        if (port == -1) {
            return null;
        }
        if (!this.canSpdyRequest(data)) {
            return super.getSocket(data);
        }
        String host = uri.getHost();
        AsyncSpdyConnection conn = this.connections.get(host);
        if (conn == null || !conn.socket.isOpen()) {
            this.connections.remove(host);
            return super.getSocket(data);
        }
        this.newSocket(data, conn, data.connectCallback);
        SimpleCancellable ret = new SimpleCancellable();
        ret.setComplete();
        return ret;
    }

    @Override
    public boolean exchangeHeaders(final AsyncHttpClientMiddleware.OnExchangeHeaderData data) {
        if (!(data.socket instanceof AsyncSpdyConnection.SpdySocket)) {
            return super.exchangeHeaders(data);
        }
        AsyncHttpRequestBody requestBody = data.request.getBody();
        if (requestBody != null) {
            data.response.sink(data.socket);
        }
        data.sendHeadersCallback.onCompleted(null);
        final AsyncSpdyConnection.SpdySocket spdySocket = (AsyncSpdyConnection.SpdySocket)data.socket;
        spdySocket.headers().then(new TransformFuture<Headers, List<Header>>(){

            @Override
            protected void transform(List<Header> result) throws Exception {
                Headers headers = new Headers();
                for (Header header : result) {
                    String key = header.name.utf8();
                    String value = header.value.utf8();
                    headers.add(key, value);
                }
                String status = headers.remove(Header.RESPONSE_STATUS.utf8());
                String[] statusParts = status.split(" ", 2);
                data.response.code(Integer.parseInt(statusParts[0]));
                data.response.message(statusParts[1]);
                data.response.protocol(headers.remove(Header.VERSION.utf8()));
                data.response.headers(headers);
                this.setComplete(headers);
            }
        }).setCallback((FutureCallback)new FutureCallback<Headers>(){

            @Override
            public void onCompleted(Exception e, Headers result) {
                data.receiveHeadersCallback.onCompleted(e);
                DataEmitter emitter = HttpUtil.getBodyDecoder(spdySocket, spdySocket.getConnection().protocol, result, false);
                data.response.emitter(emitter);
            }
        });
        return true;
    }

    @Override
    public void onRequestSent(AsyncHttpClientMiddleware.OnRequestSentData data) {
        if (!(data.socket instanceof AsyncSpdyConnection.SpdySocket)) {
            return;
        }
        if (data.request.getBody() != null) {
            data.response.sink().end();
        }
    }
}

