/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.body;

import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.http.Multimap;
import com.koushikdutta.async.http.libcore.RawHeaders;
import java.io.File;
import java.util.List;
import org.apache.http.NameValuePair;

public class Part {
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    RawHeaders mHeaders;
    Multimap mContentDisposition;
    private int length = -1;

    public Part(RawHeaders headers) {
        this.mHeaders = headers;
        this.mContentDisposition = Multimap.parseHeader(this.mHeaders, CONTENT_DISPOSITION);
    }

    public String getName() {
        return this.mContentDisposition.getString("name");
    }

    public Part(String name, int length, List<NameValuePair> contentDisposition) {
        this.length = length;
        this.mHeaders = new RawHeaders();
        StringBuilder builder = new StringBuilder(String.format("form-data; name=\"%s\"", name));
        if (contentDisposition != null) {
            for (NameValuePair pair : contentDisposition) {
                builder.append(String.format("; %s=\"%s\"", pair.getName(), pair.getValue()));
            }
        }
        this.mHeaders.set(CONTENT_DISPOSITION, builder.toString());
        this.mContentDisposition = Multimap.parseHeader(this.mHeaders, CONTENT_DISPOSITION);
    }

    public RawHeaders getRawHeaders() {
        return this.mHeaders;
    }

    public String getContentType() {
        return this.mHeaders.get("Content-Type");
    }

    public void setContentType(String contentType) {
        this.mHeaders.set("Content-Type", contentType);
    }

    public String getFilename() {
        String file = this.mContentDisposition.getString("filename");
        if (file == null) {
            return null;
        }
        return new File(file).getName();
    }

    public boolean isFile() {
        return this.mContentDisposition.containsKey("filename");
    }

    public int length() {
        return this.length;
    }

    public void write(DataSink sink, CompletedCallback callback) {
        assert (false);
    }
}

