/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import android.text.TextUtils;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.http.filter.ChunkedOutputFilter;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.http.libcore.ResponseHeaders;
import com.koushikdutta.async.http.server.AsyncHttpServer;
import com.koushikdutta.async.http.server.AsyncHttpServerRequestImpl;
import com.koushikdutta.async.http.server.AsyncHttpServerResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.json.JSONObject;

public class AsyncHttpServerResponseImpl
implements AsyncHttpServerResponse {
    private RawHeaders mRawHeaders = new RawHeaders();
    private int mContentLength = -1;
    private ResponseHeaders mHeaders = new ResponseHeaders(null, this.mRawHeaders);
    AsyncSocket mSocket;
    BufferedDataSink mSink;
    AsyncHttpServerRequestImpl mRequest;
    boolean mHasWritten = false;
    BufferedDataSink mChunker;
    private boolean mHeadWritten = false;
    boolean mEnded;

    @Override
    public ResponseHeaders getHeaders() {
        return this.mHeaders;
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    AsyncHttpServerResponseImpl(AsyncSocket socket, AsyncHttpServerRequestImpl req) {
        this.mSocket = socket;
        this.mSink = new BufferedDataSink(socket);
        this.mRequest = req;
        this.mRawHeaders.set("Connection", "Keep-Alive");
    }

    @Override
    public void write(ByteBuffer bb) {
        if (bb.remaining() == 0) {
            return;
        }
        this.writeInternal(bb);
    }

    private void writeInternal(ByteBuffer bb) {
        this.initFirstWrite();
        this.mChunker.write(bb);
    }

    void initFirstWrite() {
        if (this.mHasWritten) {
            return;
        }
        assert (null != this.mRawHeaders.getStatusLine());
        if (this.mContentLength < 0) {
            this.mRawHeaders.set("Transfer-Encoding", "Chunked");
            this.mChunker = new ChunkedOutputFilter(this.mSink);
        } else {
            this.mChunker = this.mSink;
        }
        this.writeHead();
        this.mSink.setMaxBuffer(0);
        this.mHasWritten = true;
    }

    private void writeInternal(ByteBufferList bb) {
        assert (!this.mEnded);
        this.initFirstWrite();
        this.mChunker.write(bb);
    }

    @Override
    public void write(ByteBufferList bb) {
        if (bb.remaining() == 0) {
            return;
        }
        this.writeInternal(bb);
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.initFirstWrite();
        this.mChunker.setWriteableCallback(handler);
    }

    @Override
    public WritableCallback getWriteableCallback() {
        this.initFirstWrite();
        return this.mChunker.getWriteableCallback();
    }

    @Override
    public void end() {
        if (null == this.mRawHeaders.get("Transfer-Encoding") && !this.mHasWritten) {
            this.send("text/html", "");
            this.onEnd();
            return;
        }
        this.initFirstWrite();
        this.mChunker.setMaxBuffer(Integer.MAX_VALUE);
        this.mChunker.write(new ByteBufferList());
        this.onEnd();
    }

    @Override
    public void writeHead() {
        assert (!this.mHeadWritten);
        this.mHeadWritten = true;
        this.mSink.write(ByteBuffer.wrap(this.mRawHeaders.toHeaderString().getBytes()));
    }

    @Override
    public void setContentType(String contentType) {
        assert (!this.mHeadWritten);
        this.mRawHeaders.set("Content-Type", contentType);
    }

    @Override
    public void send(String contentType, String string) {
        block4: {
            try {
                if (this.mRawHeaders.getStatusLine() == null) {
                    this.responseCode(200);
                }
                assert (this.mContentLength < 0);
                byte[] bytes = string.getBytes("UTF-8");
                this.mContentLength = bytes.length;
                this.mRawHeaders.set("Content-Length", Integer.toString(bytes.length));
                this.mRawHeaders.set("Content-Type", contentType);
                this.writeHead();
                this.mSink.write(ByteBuffer.wrap(string.getBytes()));
                this.onEnd();
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    protected void onEnd() {
        this.mEnded = true;
    }

    protected void report(Exception e) {
    }

    @Override
    public void send(String string) {
        this.responseCode(200);
        this.send("text/html; charset=utf8", string);
    }

    @Override
    public void send(JSONObject json) {
        this.send("application/json; charset=utf8", json.toString());
    }

    @Override
    public void sendFile(File file) {
        int start = 0;
        int end = (int)file.length();
        String range = this.mRequest.getHeaders().getHeaders().get("Range");
        if (range != null) {
            String[] parts = range.split("=");
            if (parts.length != 2 || !"bytes".equals(parts[0])) {
                this.responseCode(416);
                this.end();
                return;
            }
            parts = parts[1].split("-");
            try {
                if (parts.length > 2) {
                    throw new Exception();
                }
                if (!TextUtils.isEmpty((CharSequence)parts[0])) {
                    start = Integer.parseInt(parts[0]);
                }
                end = parts.length == 2 && !TextUtils.isEmpty((CharSequence)parts[1]) ? Integer.parseInt(parts[1]) : (start != 0 ? (int)file.length() : Math.min((int)file.length(), start + 50000));
                this.responseCode(206);
                this.getHeaders().getHeaders().set("Content-Range", String.format("bytes %d-%d/%d", start, end - 1, file.length()));
            }
            catch (Exception e) {
                this.responseCode(416);
                this.end();
                return;
            }
        }
        try {
            FileInputStream fin = new FileInputStream(file);
            if ((long)start != fin.skip(start)) {
                throw new Exception();
            }
            this.mRawHeaders.set("Content-Type", AsyncHttpServer.getContentType(file.getAbsolutePath()));
            this.mContentLength = end - start;
            this.mRawHeaders.set("Content-Length", "" + this.mContentLength);
            if (this.getHeaders().getHeaders().getStatusLine() == null) {
                this.responseCode(200);
            }
            Util.pump(fin, end - start, this, new CompletedCallback(){

                @Override
                public void onCompleted(Exception ex) {
                    AsyncHttpServerResponseImpl.this.end();
                }
            });
        }
        catch (Exception e) {
            this.responseCode(404);
            this.end();
        }
    }

    @Override
    public void responseCode(int code) {
        String status = AsyncHttpServer.getResponseCodeDescription(code);
        this.mRawHeaders.setStatusLine(String.format("HTTP/1.1 %d %s", code, status));
    }

    @Override
    public void redirect(String location) {
        this.responseCode(302);
        this.mRawHeaders.set("Location", location);
        this.end();
    }

    @Override
    public void onCompleted(Exception ex) {
        if (ex != null) {
            ex.printStackTrace();
        }
        this.end();
    }

    @Override
    public boolean isOpen() {
        return this.mSink.isOpen();
    }

    @Override
    public void close() {
        this.end();
        if (this.mChunker != null) {
            this.mChunker.close();
        } else {
            this.mSink.close();
        }
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSink.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSink.getClosedCallback();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }
}

