/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.http.server;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.FilteredDataEmitter;
import java.nio.ByteBuffer;

public class BoundaryEmitter
extends FilteredDataEmitter {
    private byte[] boundary;
    int state = 2;

    public void setBoundary(String boundary) {
        this.boundary = ("\r\n--" + boundary).getBytes();
    }

    public String getBoundary() {
        if (this.boundary == null) {
            return null;
        }
        return new String(this.boundary, 4, this.boundary.length - 4);
    }

    public String getBoundaryStart() {
        assert (this.boundary != null);
        return new String(this.boundary, 2, this.boundary.length - 2);
    }

    public String getBoundaryEnd() {
        assert (this.boundary != null);
        return this.getBoundaryStart() + "--\r\n";
    }

    protected void onBoundaryStart() {
    }

    protected void onBoundaryEnd() {
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        ByteBufferList list;
        if (this.state > 0) {
            ByteBuffer b = ByteBuffer.wrap(this.boundary, 0, this.state).duplicate();
            bb.addFirst(b);
            this.state = 0;
        }
        int last = 0;
        byte[] buf = new byte[bb.remaining()];
        bb.get(buf);
        for (int i = 0; i < buf.length; ++i) {
            if (this.state >= 0) {
                if (buf[i] == this.boundary[this.state]) {
                    ++this.state;
                    if (this.state != this.boundary.length) continue;
                    this.state = -1;
                    continue;
                }
                if (this.state <= 0) continue;
                i -= this.state;
                this.state = 0;
                continue;
            }
            if (this.state == -1) {
                if (buf[i] == 13) {
                    this.state = -4;
                    int len = i - last - this.boundary.length;
                    if (last != 0 || len != 0) {
                        ByteBuffer b = ByteBuffer.wrap(buf, last, len);
                        ByteBufferList list2 = new ByteBufferList();
                        list2.add(b);
                        super.onDataAvailable(this, list2);
                    }
                    this.onBoundaryStart();
                    continue;
                }
                if (buf[i] == 45) {
                    this.state = -2;
                    continue;
                }
                this.report(new Exception("Invalid multipart/form-data. Expected \r or -"));
                return;
            }
            if (this.state == -2) {
                if (buf[i] == 45) {
                    this.state = -3;
                    continue;
                }
                this.report(new Exception("Invalid multipart/form-data. Expected -"));
                return;
            }
            if (this.state == -3) {
                if (buf[i] == 13) {
                    this.state = -4;
                    ByteBuffer b = ByteBuffer.wrap(buf, last, i - last - this.boundary.length - 2);
                    list = new ByteBufferList();
                    list.add(b);
                    super.onDataAvailable(this, list);
                    this.onBoundaryEnd();
                    continue;
                }
                this.report(new Exception("Invalid multipart/form-data. Expected \r"));
                return;
            }
            if (this.state == -4) {
                if (buf[i] == 10) {
                    last = i + 1;
                    this.state = 0;
                    continue;
                }
                this.report(new Exception("Invalid multipart/form-data. Expected \n"));
                continue;
            }
            assert (false);
            this.report(new Exception("Invalid multipart/form-data. Unknown state?"));
        }
        if (last < buf.length) {
            int keep = Math.max(this.state, 0);
            ByteBuffer b = ByteBuffer.wrap(buf, last, buf.length - last - keep);
            list = new ByteBufferList();
            list.add(b);
            super.onDataAvailable(this, list);
        }
    }
}

