/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataEmitterBase;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.DataCallback;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileDataEmitter
extends DataEmitterBase {
    AsyncServer server;
    File file;
    DataCallback callback;
    boolean paused;
    ByteBufferList pending = new ByteBufferList();
    FileChannel channel;
    Runnable pumper = new Runnable(){

        @Override
        public void run() {
            try {
                if (FileDataEmitter.this.channel == null) {
                    FileDataEmitter.this.channel = new FileInputStream(FileDataEmitter.this.file).getChannel();
                }
                if (!FileDataEmitter.this.pending.isEmpty()) {
                    Util.emitAllData((DataEmitter)FileDataEmitter.this, FileDataEmitter.this.pending);
                    if (!FileDataEmitter.this.pending.isEmpty()) {
                        return;
                    }
                }
                do {
                    ByteBuffer b;
                    if (-1 == FileDataEmitter.this.channel.read(b = ByteBufferList.obtain(8192))) {
                        FileDataEmitter.this.report(null);
                        return;
                    }
                    b.flip();
                    FileDataEmitter.this.pending.add(b);
                    Util.emitAllData((DataEmitter)FileDataEmitter.this, FileDataEmitter.this.pending);
                } while (FileDataEmitter.this.pending.remaining() == 0 && !FileDataEmitter.this.isPaused());
            }
            catch (Exception e) {
                FileDataEmitter.this.report(e);
            }
        }
    };

    public FileDataEmitter(AsyncServer server, File file) {
        this.server = server;
        this.file = file;
        boolean bl = this.paused = !server.isAffinityThread();
        if (!this.paused) {
            this.doResume();
        }
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.callback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.callback;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        this.paused = false;
        this.doResume();
    }

    @Override
    protected void report(Exception e) {
        try {
            this.channel.close();
        }
        catch (Exception ex) {
            e = ex;
        }
        super.report(e);
    }

    private void doResume() {
        this.server.post(this.pumper);
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    @Override
    public AsyncServer getServer() {
        return this.server;
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

