/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async.stream;

import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class OutputStreamDataCallback
implements DataCallback,
CompletedCallback {
    private OutputStream mOutput;

    public OutputStreamDataCallback(OutputStream os) {
        this.mOutput = os;
    }

    public OutputStream getOutputStream() {
        return this.mOutput;
    }

    @Override
    public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
        try {
            while (bb.size() > 0) {
                ByteBuffer b = bb.remove();
                this.mOutput.write(b.array(), b.arrayOffset() + b.position(), b.remaining());
            }
        }
        catch (Exception ex) {
            this.onCompleted(ex);
        }
        bb.clear();
    }

    public void close() {
        try {
            this.mOutput.close();
        }
        catch (IOException e) {
            this.onCompleted(e);
        }
    }

    @Override
    public void onCompleted(Exception error) {
        error.printStackTrace();
    }
}

