/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import android.os.Build;
import com.koushikdutta.async.AsyncSSLException;
import com.koushikdutta.async.AsyncSSLSocket;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.AsyncSocket;
import com.koushikdutta.async.BufferedDataEmitter;
import com.koushikdutta.async.BufferedDataSink;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.callback.DataCallback;
import com.koushikdutta.async.callback.WritableCallback;
import com.koushikdutta.async.wrapper.AsyncSocketWrapper;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public class AsyncSSLSocketWrapper
implements AsyncSocketWrapper,
AsyncSSLSocket {
    AsyncSocket mSocket;
    BufferedDataEmitter mEmitter;
    BufferedDataSink mSink;
    ByteBuffer mReadTmp = ByteBuffer.allocate(8192);
    boolean mUnwrapping = false;
    TrustManager[] trustManagers;
    boolean clientMode;
    static SSLContext sslContext;
    SSLEngine engine;
    boolean finishedHandshake = false;
    private String mHost;
    private int mPort;
    private boolean mWrapping = false;
    ByteBuffer mWriteTmp = ByteBuffer.allocate(8192);
    WritableCallback mWriteableCallback;
    DataCallback mDataCallback;
    X509Certificate[] peerCertificates;

    @Override
    public void end() {
        this.mSocket.end();
    }

    public AsyncSSLSocketWrapper(AsyncSocket socket, String host, int port) {
        this(socket, host, port, sslContext, null, true);
    }

    public AsyncSSLSocketWrapper(AsyncSocket socket, String host, int port, SSLContext sslContext, TrustManager[] trustManagers, boolean clientMode) {
        this.mSocket = socket;
        this.clientMode = clientMode;
        this.trustManagers = trustManagers;
        if (sslContext == null) {
            sslContext = AsyncSSLSocketWrapper.sslContext;
        }
        this.engine = host != null ? sslContext.createSSLEngine(host, port) : sslContext.createSSLEngine();
        this.mHost = host;
        this.mPort = port;
        this.engine.setUseClientMode(clientMode);
        this.mSink = new BufferedDataSink(socket);
        this.mSink.setMaxBuffer(0);
        this.mEmitter = new BufferedDataEmitter(socket);
        this.mEmitter.setDataCallback(new DataCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDataAvailable(DataEmitter emitter, ByteBufferList bb) {
                if (AsyncSSLSocketWrapper.this.mUnwrapping) {
                    return;
                }
                try {
                    int remaining;
                    AsyncSSLSocketWrapper.this.mUnwrapping = true;
                    ByteBufferList out = new ByteBufferList();
                    AsyncSSLSocketWrapper.this.mReadTmp.position(0);
                    AsyncSSLSocketWrapper.this.mReadTmp.limit(AsyncSSLSocketWrapper.this.mReadTmp.capacity());
                    ByteBuffer b = bb.size() > 0 ? bb.getAll() : ByteBuffer.allocate(0);
                    do {
                        remaining = b.remaining();
                        SSLEngineResult res = AsyncSSLSocketWrapper.this.engine.unwrap(b, AsyncSSLSocketWrapper.this.mReadTmp);
                        if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                            AsyncSSLSocketWrapper.this.addToPending(out);
                            AsyncSSLSocketWrapper.this.mReadTmp = ByteBuffer.allocate(AsyncSSLSocketWrapper.this.mReadTmp.remaining() * 2);
                            remaining = -1;
                        }
                        AsyncSSLSocketWrapper.this.handleResult(res);
                    } while (b.remaining() != remaining);
                    if (b.remaining() > 0) {
                        bb.add(0, b);
                    }
                    AsyncSSLSocketWrapper.this.addToPending(out);
                    Util.emitAllData((DataEmitter)AsyncSSLSocketWrapper.this, out);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    AsyncSSLSocketWrapper.this.report(ex);
                }
                finally {
                    AsyncSSLSocketWrapper.this.mUnwrapping = false;
                }
            }
        });
    }

    void addToPending(ByteBufferList out) {
        if (this.mReadTmp.position() > 0) {
            this.mReadTmp.limit(this.mReadTmp.position());
            this.mReadTmp.position(0);
            out.add(this.mReadTmp);
            this.mReadTmp = ByteBuffer.allocate(this.mReadTmp.capacity());
        }
    }

    public String getHost() {
        return this.mHost;
    }

    public int getPort() {
        return this.mPort;
    }

    private void handleResult(SSLEngineResult res) {
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task = this.engine.getDelegatedTask();
            task.run();
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            this.write(ByteBuffer.allocate(0));
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            this.mEmitter.onDataAvailable();
        }
        try {
            if (!(this.finishedHandshake || this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED)) {
                if (this.clientMode) {
                    TrustManager[] trustManagers = this.trustManagers;
                    if (trustManagers == null) {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init((KeyStore)null);
                        trustManagers = tmf.getTrustManagers();
                    }
                    boolean trusted = false;
                    for (TrustManager tm : trustManagers) {
                        try {
                            X509TrustManager xtm = (X509TrustManager)tm;
                            this.peerCertificates = (X509Certificate[])this.engine.getSession().getPeerCertificates();
                            xtm.checkServerTrusted(this.peerCertificates, "SSL");
                            if (this.mHost != null) {
                                StrictHostnameVerifier verifier = new StrictHostnameVerifier();
                                verifier.verify(this.mHost, StrictHostnameVerifier.getCNs((X509Certificate)this.peerCertificates[0]), StrictHostnameVerifier.getDNSSubjectAlts((X509Certificate)this.peerCertificates[0]));
                            }
                            trusted = true;
                            break;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.finishedHandshake = true;
                    if (!trusted) {
                        AsyncSSLException e = new AsyncSSLException();
                        this.report(e);
                        if (!e.getIgnore()) {
                            throw e;
                        }
                    }
                }
                if (this.mWriteableCallback != null) {
                    this.mWriteableCallback.onWriteable();
                }
                this.mEmitter.onDataAvailable();
            }
        }
        catch (Exception ex) {
            this.report(ex);
        }
    }

    private void writeTmp() {
        this.mWriteTmp.limit(this.mWriteTmp.position());
        this.mWriteTmp.position(0);
        if (this.mWriteTmp.remaining() > 0) {
            this.mSink.write(this.mWriteTmp);
        }
    }

    boolean checkWrapResult(SSLEngineResult res) {
        if (res.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
            this.mWriteTmp = ByteBuffer.allocate(this.mWriteTmp.remaining() * 2);
            return false;
        }
        return true;
    }

    @Override
    public void write(ByteBuffer bb) {
        int remaining;
        if (this.mWrapping) {
            return;
        }
        if (this.mSink.remaining() > 0) {
            return;
        }
        this.mWrapping = true;
        SSLEngineResult res = null;
        do {
            if (this.finishedHandshake && bb.remaining() == 0) {
                this.mWrapping = false;
                return;
            }
            remaining = bb.remaining();
            this.mWriteTmp.position(0);
            this.mWriteTmp.limit(this.mWriteTmp.capacity());
            try {
                res = this.engine.wrap(bb, this.mWriteTmp);
                if (!this.checkWrapResult(res)) {
                    remaining = -1;
                }
                this.writeTmp();
                this.handleResult(res);
            }
            catch (SSLException e) {
                this.report(e);
            }
        } while ((remaining != bb.remaining() || res != null && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) && this.mSink.remaining() == 0);
        this.mWrapping = false;
    }

    @Override
    public void write(ByteBufferList bb) {
        int remaining;
        if (this.mWrapping) {
            return;
        }
        if (this.mSink.remaining() > 0) {
            return;
        }
        this.mWrapping = true;
        SSLEngineResult res = null;
        do {
            if (this.finishedHandshake && bb.remaining() == 0) {
                this.mWrapping = false;
                return;
            }
            remaining = bb.remaining();
            this.mWriteTmp.position(0);
            this.mWriteTmp.limit(this.mWriteTmp.capacity());
            try {
                ByteBuffer[] arr = bb.getAllArray();
                res = this.engine.wrap(arr, this.mWriteTmp);
                bb.addAll(arr);
                if (!this.checkWrapResult(res)) {
                    remaining = -1;
                }
                this.writeTmp();
                this.handleResult(res);
            }
            catch (SSLException e) {
                this.report(e);
            }
        } while ((remaining != bb.remaining() || res != null && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_WRAP) && this.mSink.remaining() == 0);
        this.mWrapping = false;
    }

    @Override
    public void setWriteableCallback(WritableCallback handler) {
        this.mWriteableCallback = handler;
    }

    @Override
    public WritableCallback getWriteableCallback() {
        return this.mWriteableCallback;
    }

    private void report(Exception e) {
        CompletedCallback cb = this.getEndCallback();
        if (cb != null) {
            cb.onCompleted(e);
        }
    }

    @Override
    public void setDataCallback(DataCallback callback) {
        this.mDataCallback = callback;
    }

    @Override
    public DataCallback getDataCallback() {
        return this.mDataCallback;
    }

    @Override
    public boolean isChunked() {
        return this.mSocket.isChunked();
    }

    @Override
    public boolean isOpen() {
        return this.mSocket.isOpen();
    }

    @Override
    public void close() {
        this.mSocket.close();
    }

    @Override
    public void setClosedCallback(CompletedCallback handler) {
        this.mSocket.setClosedCallback(handler);
    }

    @Override
    public CompletedCallback getClosedCallback() {
        return this.mSocket.getClosedCallback();
    }

    @Override
    public void setEndCallback(CompletedCallback callback) {
        this.mSocket.setEndCallback(callback);
    }

    @Override
    public CompletedCallback getEndCallback() {
        return this.mSocket.getEndCallback();
    }

    @Override
    public void pause() {
        this.mSocket.pause();
    }

    @Override
    public void resume() {
        this.mSocket.resume();
    }

    @Override
    public boolean isPaused() {
        return this.mSocket.isPaused();
    }

    @Override
    public AsyncServer getServer() {
        return this.mSocket.getServer();
    }

    @Override
    public AsyncSocket getSocket() {
        return this.mSocket;
    }

    @Override
    public DataEmitter getDataEmitter() {
        return this.mSocket;
    }

    @Override
    public X509Certificate[] getPeerCertificates() {
        return this.peerCertificates;
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 15) {
                throw new Exception();
            }
            sslContext = SSLContext.getInstance("Default");
        }
        catch (Exception ex) {
            try {
                sslContext = SSLContext.getInstance("TLS");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        for (X509Certificate cert : certs) {
                            cert.getCriticalExtensionOIDs().remove("2.5.29.15");
                        }
                    }
                }};
                sslContext.init(null, trustAllCerts, null);
            }
            catch (Exception ex2) {
                ex.printStackTrace();
                ex2.printStackTrace();
            }
        }
    }
}

