/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.async;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;

public class ByteBufferList {
    LinkedList<ByteBuffer> mBuffers = new LinkedList();
    ByteOrder order = ByteOrder.BIG_ENDIAN;
    private int remaining = 0;

    public ByteOrder order() {
        return this.order;
    }

    public ByteBufferList order(ByteOrder order) {
        this.order = order;
        return this;
    }

    public ByteBufferList() {
    }

    public ByteBufferList(ByteBuffer ... b) {
        this.addAll(b);
    }

    public ByteBufferList(byte[] buf) {
        ByteBuffer b = ByteBuffer.wrap(buf);
        this.add(b);
    }

    public void addAll(ByteBuffer ... bb) {
        for (ByteBuffer b : bb) {
            this.add(b);
        }
    }

    public byte[] getAllByteArray() {
        byte[] ret = new byte[this.remaining()];
        this.get(ret);
        return ret;
    }

    public ByteBuffer[] getAllArray() {
        ByteBuffer[] ret = new ByteBuffer[this.mBuffers.size()];
        ret = this.mBuffers.toArray(ret);
        this.clear();
        return ret;
    }

    public boolean isEmpty() {
        return this.remaining == 0;
    }

    public int remaining() {
        return this.remaining;
    }

    public int getInt() {
        int ret = this.read(4).getInt();
        this.remaining -= 4;
        return ret;
    }

    public char getByteChar() {
        char ret = (char)this.read(1).get();
        --this.remaining;
        return ret;
    }

    public int getShort() {
        short ret = this.read(2).getShort();
        this.remaining -= 2;
        return ret;
    }

    public byte get() {
        byte ret = this.read(1).get();
        --this.remaining;
        return ret;
    }

    public long getLong() {
        long ret = this.read(8).getLong();
        this.remaining -= 8;
        return ret;
    }

    public void get(byte[] bytes) {
        this.get(bytes, 0, bytes.length);
    }

    public void get(byte[] bytes, int offset, int length) {
        this.read(length).get(bytes, offset, length);
        this.remaining -= length;
    }

    public void get(ByteBufferList into, int length) {
        if (this.remaining() < length) {
            throw new IllegalArgumentException("length");
        }
        int offset = 0;
        for (ByteBuffer b : this.mBuffers) {
            int remaining = b.remaining();
            if (remaining == 0) continue;
            if (offset > length) break;
            if (offset + remaining > length) {
                int need = length - offset;
                into.add(ByteBuffer.wrap(b.array(), b.arrayOffset() + b.position(), need));
                b.position(b.position() + need);
            } else {
                into.add(ByteBuffer.wrap(b.array(), b.arrayOffset() + b.position(), remaining));
                b.position(b.limit());
            }
            offset += remaining;
        }
        this.remaining -= length;
    }

    public ByteBufferList get(int length) {
        ByteBufferList ret = new ByteBufferList();
        this.get(ret, length);
        return ret.order(this.order);
    }

    public ByteBuffer getAll() {
        this.read(this.remaining());
        return this.remove();
    }

    private ByteBuffer read(int count) {
        int toRead;
        if (this.remaining() < count) {
            throw new IllegalArgumentException("count");
        }
        ByteBuffer first = this.mBuffers.peek();
        while (first != null && first.position() == first.limit()) {
            this.mBuffers.remove();
            first = this.mBuffers.peek();
        }
        if (first == null) {
            return ByteBuffer.wrap(new byte[0]).order(this.order);
        }
        if (first.remaining() >= count) {
            return first.order(this.order);
        }
        byte[] bytes = new byte[count];
        Buffer bb = null;
        for (int offset = 0; offset < count; offset += toRead) {
            bb = this.mBuffers.remove();
            toRead = Math.min(count - offset, bb.remaining());
            ((ByteBuffer)bb).get(bytes, offset, toRead);
        }
        assert (bb != null);
        if (bb.position() < bb.limit()) {
            this.mBuffers.add(0, (ByteBuffer)bb);
        }
        ByteBuffer ret = ByteBuffer.wrap(bytes);
        this.mBuffers.add(0, ret);
        return ret.order(this.order);
    }

    public void trim() {
        this.read(0);
    }

    public void add(ByteBuffer b) {
        if (b.remaining() <= 0) {
            return;
        }
        this.addRemaining(b.remaining());
        this.mBuffers.add(b);
        this.trim();
    }

    public void add(int location, ByteBuffer b) {
        this.addRemaining(b.remaining());
        this.mBuffers.add(location, b);
    }

    private void addRemaining(int remaining) {
        if (this.remaining() >= 0) {
            this.remaining += remaining;
        }
    }

    public void add(ByteBufferList b) {
        if (b.remaining() <= 0) {
            return;
        }
        this.addRemaining(b.remaining());
        this.mBuffers.addAll(b.mBuffers);
        this.trim();
    }

    public void clear() {
        this.mBuffers.clear();
        this.remaining = 0;
    }

    public ByteBuffer remove() {
        ByteBuffer ret = this.mBuffers.remove();
        this.remaining -= ret.remaining();
        return ret;
    }

    public int size() {
        return this.mBuffers.size();
    }

    public void spewString() {
        System.out.println(this.peekString());
    }

    public String peekString() {
        StringBuilder builder = new StringBuilder();
        for (ByteBuffer bb : this.mBuffers) {
            builder.append(new String(bb.array(), bb.arrayOffset() + bb.position(), bb.remaining()));
        }
        return builder.toString();
    }

    public String readString() {
        String ret = this.peekString();
        this.clear();
        return ret;
    }
}

